/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Jan 97                                                   *
*  Last Update : Jan 97                                                   *
*                                                                         *
*  This Module is part of the UNILIB                                      *
*                                                                         *
*  Module      : trace.m4                                                 *
*                                                                         *
*  Function    : tracing facilities (for VAMPIR TRACE)                    *
*                                                                         *
**************************************************************************/

#if defined (VT)

#include "dalib.h"
#include "VT.h"

#undef DEBUG

/*******************************************************************
*                                                                  *
*  Global variables                                                *
*                                                                  *
*******************************************************************/

# define MAX_CODES 512

static int vt_codes   [MAX_CODES];
static int vt_offsets [MAX_CODES];
static int vt_number     = 0;

/*******************************************************************
*                                                                  *
*  vt_table:                                                       *
*                                                                  *
*     NAME1\0NAME2\0NAME3\0....                                    *
*                          |                                       *
*                       vt_table_top                               *
*                                                                  *
*******************************************************************/

# define VT_TABLE_SIZE  MAX_CODES*14

static int vt_table_top  = 0;

static char vt_table[VT_TABLE_SIZE];

/*******************************************************************
*                                                                  *
*  int dalib_search_routine (char sname[])                         *
*                                                                  *
*     - searches sname within the vt_table                         *
*                                                                  *
*     - 0 <= pos < vt_number   : string found at pos               *
*     - pos == vt_number       : string not found                  *
*                                                                  *
*******************************************************************/

int dalib_search_routine (sname)
char *sname;

{ int found;
  int pos;

  pos   = 0;
  found = 0;

  while ( (pos < vt_number) && (!found) )

    { if (strcmp (sname, vt_table + vt_offsets[pos]) == 0) found = 1;

      if (!found) pos++;
    }

#ifdef DEBUG
  printf ("%d: search %s, pos = %d, found = %d\n", pcb.i, sname, pos, found);
#endif

  return (pos);

} /* dalib_search_routine */

/*******************************************************************
*                                                                  *
*  void dalib_add_routine (sname)                                  *
*                                                                  *
*******************************************************************/

void dalib_add_routine (sname)
char *sname;

{ int i;
  int len;
  int code;
  int ierr;

  if (vt_number == MAX_CODES)

     {  /* tables are too small, now serious error */

        dalib_internal_error ("VT tables too small");
        dalib_stop ();
     }

  len = strlen (sname);

  code = 400 + vt_number;

  vt_offsets [vt_number] = vt_table_top;
  vt_codes   [vt_number] = code;

  if (vt_table_top + len + 1 > VT_TABLE_SIZE)

     { /* table with routine names is too small */

       dalib_internal_error ("VT routine table too small");
       dalib_stop ();
     }

  for (i=0; i<len; i++) vt_table[vt_table_top++] = sname[i];

  vt_table[vt_table_top ++] = '\0';

  ierr = VT_symdef (code, sname, "HPF");

  if (ierr != 0)

     printf ("VT ERROR\n");

  vt_number++;

#ifdef DEBUG
  printf ("%d: new routine %s added, code = %d\n", pcb.i, sname, code);
#endif

} /* dalib_add_routine */

/*******************************************************************
*                                                                  *
*  int dalib_find_code (char *sname)                               *
*                                                                  *
*    - returns an internal code for the subroutine name as int     *
*                                                                  *
*******************************************************************/

int dalib_find_code (sname)
char *sname;

{ int pos;

  pos = dalib_search_routine (sname);

  if (pos == vt_number)
     dalib_add_routine (sname);

#ifdef DEBUG
  printf ("%d: code for %s = %d\n", pcb.i, sname, vt_codes[pos]);
#endif

  return vt_codes[pos];

} /* dalib_find_code */

/*******************************************************************
*                                                                  *
*  hpf_trace_on (char *sname)                                      *
*                                                                  *
*******************************************************************/

void hpf_trace_on (sname)
char *sname;

{ int code;
  int ierr;

  code = dalib_find_code (sname);
  ierr = VT_begin (code);

  if (ierr < 0)
     printf ("%d: VT_begin, code = %d, error = %d\n", pcb.i, code, ierr);

} /* hpf_trace_on */

/*******************************************************************
*                                                                  *
*  hpf_trace_off (char *sname)                                     *
*                                                                  *
*******************************************************************/

void hpf_trace_off (sname)
char *sname;

{ int code;
  int ierr;

  code = dalib_find_code (sname);
  ierr = VT_end (code);

  if (ierr < 0)
     printf ("%d: VT_end, code = %d, error = %d\n", pcb.i, code, ierr);

} /* hpf_trace_off */

void dalib_trace_define ()

{
   VT_symdef (TRACE_GROUP_BCAST, "bcast", "DALIB");
   VT_symdef (TRACE_GROUP_REDUCE, "reduce", "DALIB");
   VT_symdef (TRACE_OVERLAP_UPDATE, "ov_upd", "DALIB");
}

/*******************************************************************
*                                                                  *
*  void dalib_trace_on  (code)                                     *
*  void dalib_trace_off (code)                                     *
*                                                                  *
*    - used for internal tracing with DALIB                        *
*                                                                  *
*******************************************************************/

void dalib_trace_on (code)
int code;

{
   VT_begin (code);
}

void dalib_trace_off (code)
int code;

{
   VT_end (code);
}

#endif
