/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Mar 96                                                   *
*  Last Update : Mar 96                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : scatter                                                  *
*                                                                         *
*  Function    : scatter operatons on local arrays                        *
*                                                                         *
*                                                                         *
**************************************************************************/

#undef DEBUG
#undef CHECK

#include "dalib.h"
#include "inspector.h"
#include <stdio.h>

/**********************************************************************
*                                                                     *
*  dalib_scatter  (int *op, array_info *array_dsp, char *array_vals,  *
*                           array_info *base_dsp,  char *base_vals,   *
*                           array_info *ind1_dsp,  char *ind1_vals,   *
*                           .......................................   *
*                           array_info *ind7_dsp,  char *ind7_vals)   *
*                                                                     *
*   op         : kind of scatter reduction (op = 0 for copy)          *
*                                                                     *
*   base_dsp   : array that will be indirectly addressed              *
*                (rank of this array is k)                            *
*                                                                     *
*   ind1_dsp   : integer array 1                                      *
*   ...                                                               *
*   indk_dsp   : integer array k                                      *
*                                                                     *
**********************************************************************/
 
void FUNCTION(dalib_scatter)
 
         (op, array_vals,  array_dsp,
              base_vals,   base_dsp,
              mask_vals,   mask_dsp,
              ind1_vals,   ind1_dsp,
              ind2_vals,   ind2_dsp,
              ind3_vals,   ind3_dsp,
              ind4_vals,   ind4_dsp,
              ind5_vals,   ind5_dsp,
              ind6_vals,   ind6_dsp,
              ind7_vals,   ind7_dsp)

int *op;
 
array_info *array_dsp, *base_dsp, *mask_dsp;
char       *array_vals, *base_vals, *mask_vals;
 
array_info *ind1_dsp, *ind2_dsp, *ind3_dsp, *ind4_dsp,
           *ind5_dsp, *ind6_dsp, *ind7_dsp;
 
char       *ind1_vals, *ind2_vals, *ind3_vals, *ind4_vals,
           *ind5_vals, *ind6_vals, *ind7_vals;
 
{ int *offsets;
 
  int base_rank;
  array_info source_array;
  int no_indexes;
  int size, bytes;

  char *source_vals;    /* contiguous values of source array    */
  int is_new;           /* true if source_vals is new allocated */

  unsigned char *ptr;
 
  int *indexes[MAX_DIMENSIONS];
  int index_new[MAX_DIMENSIONS];
  int *mask_data;
  int mask_new;

  inspector_info S;

       /******************************************
       *   set global data                       *
       ******************************************/
 
  dalib_insp_info_set_source (&S, array_dsp);
  dalib_insp_info_set_base   (&S, base_dsp);
  dalib_insp_info_set_mask   (&S, mask_dsp, mask_vals);
 
  base_rank = (*base_dsp)->rank;
  no_indexes = S.number_of_indexes;

#ifdef DEBUG
  printf ("%d: scatter, indexes = %d, target (rank=%d,top=%d)\n",
           pcb.i, no_indexes, base_rank, base_topology);
#endif
 
  switch (base_rank) {
 
    case 7 : dalib_insp_info_set_index (&S, 7, ind7_dsp, ind7_vals);
    case 6 : dalib_insp_info_set_index (&S, 6, ind6_dsp, ind6_vals);
    case 5 : dalib_insp_info_set_index (&S, 5, ind5_dsp, ind5_vals);
    case 4 : dalib_insp_info_set_index (&S, 4, ind4_dsp, ind4_vals);
    case 3 : dalib_insp_info_set_index (&S, 3, ind3_dsp, ind3_vals);
    case 2 : dalib_insp_info_set_index (&S, 2, ind2_dsp, ind2_vals);
    case 1 : dalib_insp_info_set_index (&S, 1, ind1_dsp, ind1_vals);
             break;
 
    default : dalib_internal_error ("scatter, illegal rank");
              dalib_stop ();
 
   } /* switch */
 
       /******************************************
       *   compute global addresses/processors   *
       ******************************************/
 
   dalib_insp_info_get (&S, indexes, index_new, &mask_data, &mask_new);

   offsets = (int *) dalib_int_malloc (no_indexes, "indexes_local_offsets");
 
   dalib_make_global_offsets (offsets, no_indexes, *base_dsp,
                              mask_data, indexes);

   ptr = (*base_dsp)->data;

   /* use internal data structures for receiving values in source 
      source_vals must contain also old values                     */

   dalib_secarray_get_data (*array_dsp, 1, &size, 
                            &bytes, &source_vals, &is_new);

   if (mask_data == (int *) 0)

    { /* there is no mask defined */

      if (*op == 0)
          dalib_memset (ptr, offsets, source_vals, size, bytes);
        else
          dalib_set (*op, ptr, offsets, source_vals, size);
    }

    else

    { /* there is a mask available */

      if (*op == 0)
          dalib_memsetm (ptr, offsets, source_vals, mask_data, size, bytes);
        else
          dalib_setm (*op, ptr, offsets, source_vals, mask_data, size);
    }

   if (is_new) 

       { /* copy source vals (contiguous) back to non-contiguous section */

         dalib_secarray_unpack (*array_dsp, source_vals);

       }

   dalib_int_free (offsets, no_indexes);

   dalib_insp_info_free (&S, indexes, index_new, mask_data, mask_new);

} /* dalib_scatter */
