/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Feb 96                                                   *
*  Last Update : Apr 96                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : rma_access.m4                                            *
*                                                                         *
*  Function: machine dependent remote memory access                       *
*                                                                         *
*      DUMMY version (not                                                 *
*                                                                         *
*  Export :  internal Interface                                           *
*  ============================                                           *
*                                                                         *
*   void dalib_system_rma_init ()                                         *
*                                                                         *
*     - starts remote memory access (if initialization is necessary)      *
*                                                                         *
*   void dalib_system_rma_exit ()                                         *
*                                                                         *
*     - stops remote memory access (can happen for server mode)           *
*                                                                         *
*   void dalib_system_rma_get (char *data, int remote_pid,                *
*                              void *address, int size)                   *
*                                                                         *
*     - read remote data at address on remote_pid (size bytes)            *
*                                                                         *
*   void dalib_system_rma_put (char *data, int remote_pid,                *
*                              void *address, int size)                   *
*                                                                         *
*     - write remote data at address on remote_pid (size bytes)           *
*                                                                         *
*   void dalib_system_rma_update (int op, char *data, int remote_pid,     *
*                                void *address, int size)                 *
*                                                                         *
*     - (atomic) update of remote data at address                         *
*                                                                         *
**************************************************************************/

