/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Feb 97                                                   *
*  Last Update : Feb 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : reshape.m4                                               *
*                                                                         *
*  Function    : F90 intrinsics reshape                                   *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
**************************************************************************/

#define CHECK
#undef DEBUG

#include <stdio.h>
#include "dalib.h"

/**************************************************************************
*                                                                         *
*   void dalib_check_permutation (int perm[], int rank)                   *
*                                                                         *
*    perm = permutation of 1 .. rank                                      *
*                                                                         *
**************************************************************************/

static void dalib_check_permutation (perm, rank)
int perm[];
int rank;

{ int i, j, val;
  int used[MAX_DIMENSIONS];

#ifdef DEBUG
  printf ("Permutation (rank = %d) : ", rank);
  for (i=0; i<rank; i++) printf ("%d ", perm[i]);
  printf ("\n");
#endif 

  for (i=0; i<rank; i++) used[i] = 0;

  for (i=0; i<rank; i++)

    { val = perm[i];

      /* val must be between 1 and rank */

      if ((val < 1) || (val > rank))

         { dalib_internal_error ("illegal permuation value");
           printf ("Permutation (rank = %d) : ", rank);
           for (j=0; j<rank; j++) printf ("%d ", perm[j]);
           printf ("\n");
           dalib_stop ();
         }

      val--;  /* now consider val in 0 <= val < rank */

      if (used[val])

         { dalib_internal_error ("illegal permuation (double vals)");
           printf ("Permutation (rank = %d) : ", rank);
           for (j=0; j<rank; j++) printf ("%d ", perm[j]);
           printf ("\n");
           dalib_stop ();
         }

      used[val] = 1;

      perm[i] = val;  /* later we use 0 .. rank - 1 */

    }

}  /* dalib_check_permutation */

/**************************************************************************
*                                                                         *
*  FUNCTION (dalib_reshape)                                               * 
*                                                                         *
*    (result, source, shape, pad, order, ...)                             *
*                                                                         *
*   RESULT = RESHAPE (SOURCE, SHAPE, [,PAD] [,ORDER])                     *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_reshape) (result,     source,     shape,     
                              pad,        order,
                              result_dsp, source_dsp, shape_dsp, 
                              pad_dsp,    order_dsp)

char *result;
char *source;
char *shape;
char *pad;
char *order;

array_info *result_dsp;
array_info *source_dsp;
array_info *shape_dsp;
array_info *pad_dsp;
array_info *order_dsp;

{  if (dalib_secarray_is_mapped (result_dsp))

     { dalib_internal_error ("RESHAPE : result is mapped (unsupported)");
       dalib_stop ();
     }

   if (dalib_secarray_is_mapped (source_dsp))

     { dalib_internal_error ("RESHAPE : source is mapped (unsupported)");
       dalib_stop ();
     }

   if (FUNCTION(dalib_present) (pad))

      { dalib_internal_error ("RESHAPE: pad argument not supported");
        dalib_stop ();
      }

   if (FUNCTION(dalib_present) (order))

      { int i, rank;
        int *perm;
        dalib_secarray_pack (&perm, *order_dsp);
        rank = dalib_secarray_rank (result_dsp);
        dalib_check_permutation (perm, rank);
        dalib_secarray_perm_copy (*result_dsp, *source_dsp, perm);
        free (perm);
      }

     else

       dalib_secarray_copy (*result_dsp, *source_dsp);

} /* FUNCTION(dalib_reshape) */
