/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Mar 97                                                   *
*  Last Update : Mar 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : replicate.m4                                             *
*                                                                         *
*  Function    : utility routines for replicated data                     *
*                                                                         *
**************************************************************************/

# include "dalib.h"

#define CHECK
#undef  DEBUG

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/
 
void dalib_replicate_out (data, length, out_data, out_dsp)
 
char *data, *out_data;
int          length;
section_info *out_dsp;
 
{ int size;

  array_info array_id;

  if (dalib_is_array_info (*out_dsp))
 
     { array_id = (array_info) (*out_dsp);
     }
 
   else if (dalib_is_section_info (*out_dsp))
 
     { array_id = (*out_dsp)->array_id;
     }
 
   else
 
     { dalib_internal_error ("replicate out : no array/section/scalar");
       dalib_stop ();
     }

  /* assume that out_dsp is replicated */
  
  dalib_memcopy (out_data, data, length);
 
} /* replicate_out */
