/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Apr 92                                                   *
*  Last Update : Oct 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : owner.m4                                                 *
*                                                                         *
*  Function    : determination of owner for distributed arrays            *
*                                                                         *
*  Attention: owner is relative id in topology (0 <= owner < top_size)    *
*                                                                         *
*  Changes:                                                               *
*  ========                                                               *
*                                                                         *
*    10/97   :   extension for advanced mapping features                  *
*                (completely redesigned, now import distribute_addr)      *
*                                                                         *
**************************************************************************/

#undef DEBUG
#include "dalib.h"
#include <stdio.h>

/**************************************************************************
*                                                                         *
*  void dalib_find_owners (int owners[], int nr, array_info base_dsp,     *
*                          int mask[], int *indexes[], int index_new[])   *
*                                                                         *
**************************************************************************/

void dalib_find_owners (owners, nr, base_dsp, mask, indexes, index_new)

int owners[];
int nr;
int *indexes[];
int *index_new;
int mask[];
array_info base_dsp;

{ int base_top_id;

  int base_index_dim   [MAX_RANK];    /* index dim mapped to top dim  */
  int base_lb          [MAX_RANK];    /* lb relevant for top dim      */
  int base_ub          [MAX_RANK];
  int base_base        [MAX_RANK];
  int base_stride      [MAX_RANK];
  DistDim base_mapping [MAX_RANK];    /* distribution kind for top dim */

  int i, base_top_rank;

  /* initialize base_index_dim, otherwise segmentation violation
     should be no longer necessary with the new calculations      */

  for (i=0; i<MAX_RANK; i++)
     base_index_dim [i] = 0;

  dalib_array_top_mapping (base_dsp, &base_top_id,
                           base_index_dim,
                           base_base, base_stride,
                           base_lb, base_ub, base_mapping);

  base_top_rank = dalib_top_rank (base_top_id);

#ifdef DEBUG
  printf ("%d: find owners on topid = %d, rank = %d\n",
           pcb.i, base_top_id, base_top_rank);
#endif

  /* make some verifications that this routine works fine */

  for (i=0; i < base_top_rank; i++)
    
   { int top_dim, kind;
 
     dalib_dim_mapping_info (base_mapping[i], &kind, &top_dim);
  
     /* note that i+1 should be top_dim */

     if (i+1 != top_dim)

        { dalib_internal_error ("internal error for find_owners");
          dalib_stop ();
        }

#ifdef DEBUG
   printf ("%d: dim %d on index %d, I -> %d*I+%d (%d:%d), kind = %d\n",
             pcb.i, i+1, base_index_dim[i], base_base[i], base_stride[i],
             base_lb[i], base_ub[i], kind);
#endif

    }

  /* initialize all owner to 0, and -1 if mask is set (vectorized) */

  if (mask == (int *) 0)
      for (i=0; i<nr; i++) owners[i] = 0;
    else
      for (i=0; i<nr; i++)
         if (mask[i]) owners[i] = 0; else owners[i] = -1;
 
  for (i=base_top_rank; i>0; i--)

    {  int NP, NId;
       int idim;
       int j;

       dalib_top_info (base_top_id, i, &NP, &NId);

       idim = base_index_dim[i-1] - 1;

#ifdef DEBUG
       printf ("%d: find owners, idim = %d, top_id = %d (dim=%d, %d of %d)\n",
               pcb.i, idim+1, base_top_id, i, NId, NP);
#endif 

       /*  pid = (p3 * NP2 + p2) * NP1 + p1  */

       if ( (NP > 1) && (i < base_top_rank) )

         { if (mask == (int *) 0) 
              for (j=0; j<nr; j++) owners[j] *= NP;  /* no mask */
            else
              for (j=0; j<nr; j++) if (mask[j]) owners[j] *= NP; 
         }
 
       dalib_distribution_addresses (NP, base_mapping[i-1],
                                     base_base[i-1], base_stride[i-1],
                                     base_lb[i-1], base_ub[i-1],
                                     nr, indexes+idim, index_new + idim,
                                     owners);

    }

#ifdef DEBUG
   printf ("%d: find owners -> ", pcb.i);
   for (i=0; i<nr; i++)
     { int j;
       printf ("(%d,[", owners[i]);
       for (j=0; j<base_dsp->rank; j++)
           printf (" %d", *(indexes[j]+i));
       printf ("]) ");
     }
   printf ("\n");
#endif

} /* dalib_find_owners */

/**************************************************************************
*                                                                         *
*  int dalib_multidim_owner (array_info array_id, int global_indexes[])   *
*                                                                         *
**************************************************************************/

int dalib_multidim_owner (array_id, global_indices)
 
array_info array_id;
int global_indices [];

{ int top_id, top_rank;
 
  int index_dim [MAX_RANK];    /* index dim mapped to top dim  */
  int lb        [MAX_RANK];    /* lb relevant for top dim      */
  int ub        [MAX_RANK];
  int base      [MAX_RANK];
  int stride    [MAX_RANK];

  DistDim mapping [MAX_RANK];
 
  int i, NId, NP, firstpos;
  int pid, id;
  int top_dim;

  dalib_array_top_mapping (array_id, &top_id,
                           index_dim, base, stride, lb, ub, mapping);

  top_rank = dalib_top_rank (top_id);
 
#ifdef DEBUG
  printf ("%d: find owners on topid = %d, rank = %d\n",
           pcb.i, top_id, top_rank);
  for (i=0; i < dalib_top_rank (top_id); i++)
     printf ("%d: dim %d on index %d, lb = %d, ub = %d\n",
              pcb.i, i+1, index_dim[i], 
              lb[i], ub[i]);
#endif

  pid = 0;

  for (i=top_rank-1; i>=0; i--)

    { dalib_top_info (top_id, i+1, &NP, &NId);

      dalib_distribution_owner (global_indices [index_dim[i]] - 1,
                                lb[i], ub[i], top_id, mapping[i],
                                &top_dim, &id);

      pid = pid * NP + (id - 1);

    }
 
#ifdef DEBUG
  printf ("%d: owner = %d\n", pcb.i, pid);
#endif

  return (pid);

} /* dalib_multidim_owner */
