/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Nov 93                                                   *
*  Last Update : Nov 93                                                   *
*                                                                         *
*  This Module is part of the UNILIB                                      *
*                                                                         *
*  Module      : never.c                                                  *
*                                                                         *
*  Function    : dummy functions for unilib version of DALIB              *
*                these routines will never be called                      *
*                                                                         *
**************************************************************************/

#include <stdio.h>
#include "dalib.h"

        /******************************************************
        *                                                     *
        *  GENERAL ERROR MESSAGE for never called routine     *
        *                                                     *
        ******************************************************/

void dalib_never_error (msg)
char msg[];
{
  fprintf (stderr, "%s should never be called for uniprocessor version\n",
           msg);
  exit (-1);
}

        /******************************************************
        *                                                     *
        *  ROTUINES FOR Message Passing are never called      *
        *                                                     *
        ******************************************************/

void asend (from, to, message, length)
int from, to;
unsigned char *message;
int length;

{  dalib_never_error ("asend");
}

void areceive (to, from, message, length)
int to, from;
unsigned char *message;
int length;

{ dalib_never_error ("areceive");
}

void dalib_receive (from, message, length) 
int *from;
unsigned char * message;
int *length;

{ dalib_never_error ("dalib_receive"); }

void dalib_send (to, message, length) 
int *to;
unsigned char * message;
int *length;

{ dalib_never_error ("dalib_send"); }

        /******************************************************
        *                                                     *
        *  ROTUINES FOR topology with broadcast               *
        *                                                     *
        ******************************************************/

void dalib_top_info (topid, dim, N, I)

int topid, dim;
int *N, *I;

{ dalib_never_error ("dalib_topology");
}

void dalib_top_broadcast (topid, dim, data, size)
unsigned char *data;
int      topid, dim, size;

{ dalib_never_error ("dalib_top_broadcast");
}

void dalib_send_ddt ()

{ dalib_never_error ("dalib_send_ddt");
}

void dalib_recv_ddt_op ()

{ dalib_never_error ("dalib_recv_ddt_op");
}

void dalib_top_broadcast_ddt ()

{ dalib_never_error ("dalib_top_broadcast_ddt");
}

void dalib_replicate ()

{ dalib_never_error ("dalib_replicate_");
}

int dalib_is_replicated ()
{
  return (0); 
}

void dalib_array_dim_mapping (array_id, dim, base, stride,
                              lb, ub, topology, mapping)
 
array_info array_id;
int dim;
int *topology;
int *base, *stride, *lb, *ub;
DistDim *mapping;
 
{ *base   = 0;
  *stride = 1;
  *lb     = array_id->dimensions[dim-1].global_size[0];
  *ub     = array_id->dimensions[dim-1].global_size[1];

  *topology = 0;  /* 0 stands for replicated array */
  *mapping  = NO_DIST_DIM;

} /* dalib_array_dim_mapping */

/**************************************************************************
*                                                                         *
*  dalib_dim_mapping_info (DistDim mapping => int kind, int top_dim)      *
*                                                                         *
**************************************************************************/

void dalib_dim_mapping_info (mapping, kind, top_dim)

/* Input Arguments : */

DistDim mapping;

/* Output Arguments : */

int     *kind;
int     *top_dim;

{ *kind = kSERIAL_DIM; 
  *top_dim = 0; 

} /* dalib_dim_mapping_info */


void dalib_top_neighbors () 
{
  dalib_never_error ("dalib_top_neighbors");
}

void dalib_remote_free ()
{
  dalib_never_error ("dalib_array_remote_free");
}

void dalib_array_remote_init ()
{
  dalib_never_error ("dalib_array_remote_init");
}

void dalib_array_remote_addressing ()
{
  dalib_never_error ("dalib_array_remote_addressing");
}

void dalib_array_shared_free ()
{
  dalib_never_error ("dalib_array_shared_free");
}

void dalib_shared_free ()
{
  dalib_never_error ("dalib_shared_free");
}

void dalib_array_shared_malloc ()
{
  dalib_never_error ("dalib_shared_alloc");
}

int dalib_array_map_underspecified ()
{
  return (0);  /* never underspecified in serial programs */
}

void dalib_align_local_sizes ()
{
  dalib_never_error ("dalib_align_local_sizes");
}

void dalib_dist_local_sizes ()
{
  dalib_never_error ("dalib_dist_local_sizes");

}

void dalib_dist_free ()
{
  dalib_never_error ("dalib_dist_free");
}

void dalib_align_free ()
{
  dalib_never_error ("dalib_align_free");
}

int dalib_is_aligned ()
{
  return (1);    /* everything is aligned by default */
}

void dalib_array_inherit_mapping (general_id, special_id)

array_info special_id, general_id;

{ /* will never be called as dalib_is_map_specialiazation is true */

} /* dalib_array_inherit_mapping */

/**************************************************************************
*                                                                         *
*  int dalib_is_map_specialization (special_dsp, general_dsp)             *
*                                                                         *
*  - routine is only called if general_dsp has underspecified mappings    *
*  - true if special_dsp (full mapping) is specialization of general      *
*                                                                         *
**************************************************************************/

int dalib_is_map_specialization (special_dsp, general_dsp)

{ return (0);

} /* dalib_is_map_specialization */

/**************************************************************************
*                                                                         *
*  void dalib_array_make_full_mapping (array_info array_id)               *
*                                                                         *
**************************************************************************/

void dalib_array_make_full_mapping (array_id)

array_info array_id;

{ /* nothing to do */

} /* dalib_array_make_full_mapping */

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_inspector_db_set_invalid (reuse_info)

int reuse_info;

{ /* nothing to do */

} /* dalib_inspector_db_set_invalid */

/**************************************************************************
*                                                                         *
*                                                                         *
*                                                                         *
**************************************************************************/

void dalib_indirect_overlap2 ()
{}

void dalib_indirect_ov_get ()
{}

void dalib_indirect_ov_set ()
{}

void dalib_indirect_ov_put ()
{}

void dalib_indirect_free ()
{}

          /***********************************************
          *                                              *
          *  INTEGER MY_PROCESSOR   ! HPF Local Library  *
          *                                              *
          ***********************************************/

int FUNCTION(dalib_my_processor) ()

{
   return (0);

} /* FUNCTION(dalib_my_processor) */

void FUNCTION(dalib_distribute) () 

{
}

void FUNCTION(dalib_align_source) () 

{
}

void FUNCTION(dalib_align_target) () 

{
}
/**************************************************************************
*                                                                         *
*  void dalib_array_query (array_info *array_id, int *dim,                *
*                          int *low, int *high, int *stride, int *size)   *
*                                                                         *
*     - asking for the local size of an array dimensions                  *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_array_query) (array_id, dim, low, high, stride, size)

array_info *array_id;
int *dim, *low, *high, *stride, *size;

{ array_info descriptor;
  int array_dim;

  DimInfo *dims;

  descriptor = *array_id;
  array_dim = *dim - 1;

  dims    = descriptor->dimensions + array_dim;
  *low    = dims->global_size[0];
  *high   = dims->global_size[1];
  *stride = 1;

  /* local extent depends on packing, yes or no */

  *size   = dalib_dim_global_extent (dims);

#ifdef DEBUG
  printf ("%d: dalib_array_query (array_id = %d, dim = %d -> %d:%d:%d (%d)\n",
          pcb.i, *array_id, *dim, *low, *high, *stride, *size);
#endif

} /* dalib_array_query */

