/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : May 97                                                   *
*  Last Update : May 97                                                   *
*                                                                         *
*  This Module is part of the UNILIB                                      *
*                                                                         *
*  Module      : match1                                                   *
*                                                                         *
*  Function    : matching up descriptors / copy in - copy out             *
*                                                                         *
*  Changes:                                                               *
*                                                                         *
**************************************************************************/

#undef DEBUG

#include "dalib.h"

/*******************************************************************
*                                                                  *
*  FORTRAN Interface                                               *
*                                                                  *
*  Packing/Unpacking might be required when passing real           *
*  sections to subroutines (assumed shaped arrays)                 *
*                                                                  *
*  FUNCTION(dalib_copy_in) (dummy_dsp, actual_dsp,                 *
*                           actual_data, copy_flag)                *
*                                                                  *
*  FUNCTION(dalib_copy_out) (local_dsp, actual_dsp, copy_flag)     *
*                                                                  *
*******************************************************************/

void FUNCTION(dalib_copy_in) (dummy_dsp, actual_dsp, actual_data, copy_flag) 

array_info *dummy_dsp;
array_info *actual_dsp;
char       *actual_data;
int        *copy_flag;

{ if (!FUNCTION(dalib_present) (actual_dsp))

     { /* actual argument is a pointer, dummy will be descriptor for it */

       FUNCTION(dalib_array_setdata) (dummy_dsp, actual_data);

       return;  /* that works fine */
     }

  dalib_copy_valid_info (*dummy_dsp, *actual_dsp, 0);

  /* destroy flag is false as actual descriptor will not be destroyed */

  if (*dummy_dsp == *actual_dsp)
     return;                       /* actual descriptor is just dummy */

  if (dalib_use_actual_data (*dummy_dsp, *actual_dsp))

     {  dalib_get_actual_info (*dummy_dsp, *actual_dsp);

#ifdef DEBUG
        printf ("%d: copy in, local = %d, dummy = %d, not necessary\n",
                 pcb.i, *dummy_dsp, *actual_dsp);
#endif

        return;
     }

  /* new descriptor, so new data is needed, own_data_flag == 1 */

#ifdef DEBUG
  printf ("%d: copy in, local = %d, dummy = %d, new data necessary\n",
               pcb.i, *dummy_dsp, *actual_dsp);
#endif

  dalib_array_malloc (*dummy_dsp);        /* allocate memory */

  FUNCTION(dalib_array_set_dirty) (dummy_dsp);

  /* so copy in might be necessary */

  if (*copy_flag != 0)

     {  if (pcb.redist_flag) 
            printf ("ATTENTION: copy in redistribution\n"); 

       FUNCTION(dalib_assign) (dummy_dsp, actual_dsp); 
     }

#ifdef DEBUG
  printf ("copy in finished\n");
#endif 

} /* dalib_copy_in */

/*******************************************************************
*                                                                  *
*  FORTRAN Interface                                               *
*                                                                  *
*  FUNCTION(dalib_copy_out) (dummy_dsp, actual_dsp, copy_flag)      *
*                                                                  *
*    - copy local array back to dummy array                        *
*    - free the new descriptor                                     *
*                                                                  *
*******************************************************************/

void FUNCTION(dalib_copy_out) (dummy_dsp, actual_dsp, copy_flag) 

array_info *dummy_dsp;
array_info *actual_dsp;
int        *copy_flag;

{ if (!FUNCTION(dalib_present) (actual_dsp))

     { /* dummy is a pointer, checked within copy_in */

       return;
     }

  dalib_copy_valid_info (*actual_dsp, *dummy_dsp, 1);

  /* destroy flag is true as dummy descriptor will be freed afterwards */

  if (*dummy_dsp == *actual_dsp)
     return;                       /* local descriptor is just dummy */

  if (dalib_is_dummy_data (*dummy_dsp, *actual_dsp))

     { /* copy not necessary, same data, but delete descriptor */

#ifdef DEBUG
        printf ("%d: copy out, local = %d, dummy = %d, not necessary\n",
                 pcb.i, *dummy_dsp, *actual_dsp);
#endif
 
       dalib_free_descriptor (*dummy_dsp);  

       return;

     }

  /* different descriptors, so copy out be necessary */

#ifdef DEBUG
  printf ("%d: copy out, local = %d, dummy = %d, copy out necessary\n",
               pcb.i, *dummy_dsp, *actual_dsp);
#endif

  FUNCTION(dalib_array_set_dirty) (dummy_dsp);

  if (*copy_flag != 0)

     { if (pcb.redist_flag)

          printf ("ATTENTION: copy out redistribution\n"); 

       FUNCTION(dalib_assign) (actual_dsp, dummy_dsp);
     }

#ifdef DEBUG
   printf ("%d: copy out, local = %d, dummy = %d, done\n",
            pcb.i, *dummy_dsp, *actual_dsp);
#endif
 

  dalib_free_descriptor (*dummy_dsp);  /* do also delete data */

} /* dalib_copy_out */

