/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*                                                                         *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Mar 98                                                   *
*  Last Update : Mar 98                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : linear.m4                                                *
*                                                                         *
***************************************************************************/

#include <stdio.h>
#include "dalib.h"

#undef DEBUG
#define CHECK

/**************************************************************************
*                                                                         *
*  int dalib_linear1_abspos (int rank, int shape[], int relpos[])         *
*                                                                         *
*   - shape  = [n_1, n_2, ..., n_rank]                                    *
*   - relpos = [p_1, p_2, ..., p_rank],  1<=p_k<=n_k                      *
*                                                                         *
*   - returs linearized pos 1 <= pos <= n_1 * ... * n_rank                *
*                                                                         *
***************************************************************************/

int dalib_linear1_abspos (rank, shape, relpos)

int rank; 
int shape[];
int relpos [];

{ int i;        /* counter variable  */
  int pos;      /* used for position */
  int ofs;      /* used for offsets  */

  /* ofs = 1, ofs = n1, ofs = n1 * n2, ... */

  pos = 1;
  ofs = 1;

  for (i=0; i<rank; i++)  
    { pos += (relpos[i]-1) * ofs;
      ofs *= shape[i];
    }

  return pos;

} /* dalib_linear1_abspos */

int dalib_linear1_section (rank, lb, ub, is_range, r_lb, r_ub, r_str, 
                           new_rank, first, n, inc)

int rank;
int lb[];
int ub[];
int is_range[];
int r_lb[];
int r_ub[];
int r_str[];
int *new_rank;
int *first;
int n[];
int inc[];

{ int i;
  int sn;
  int dist;

  *new_rank = 0;
  *first    = 1;

  dist = 1;

  for (i=0; i<rank; i++)

    { sn = dalib_range_size (r_lb[i], r_ub[i], r_str[i]);

      *first += (r_lb[i]-lb[i]) * dist;

      if (is_range[i])

        { inc [*new_rank] = dist * r_str[i];
          n   [*new_rank] = sn;

          (*new_rank)++;
        }

       else

        {
        }

      if (lb[i] <= ub[i])
         dist *= (ub[i] - lb[i] + 1);
       else
         dist  = 0;
    }

} /* dalib_linear1_section */

int dalib_linear1_restrict (rank, shape, relpos, is_full,
                            new_rank, first, n, inc)

int rank;
int shape[];
int relpos[];
int is_full[];
int *new_rank;
int *first;
int n[];
int inc[];

{ int i;
  int sn;
  int dist;

  *new_rank = 0;
  *first    = 1;

  dist = 1;

  for (i=0; i<rank; i++)

    { if (is_full[i])

        { inc [*new_rank] = dist;
          n   [*new_rank] = shape[i];

          (*new_rank)++;
        }

       else

         *first += (relpos[i]-1) * dist;

       dist *= shape[i];
    }

} /* dalib_linear1_restrict */

/***************************************************************************
*                                                                          *
*  void dalib_linear_compress (int rank, int n[], int inc[],               *
*                              int *new_rank, int n1[], int inc1[])        *
*                                                                          *
*   elems = inc[0]*i0 + ... + inc[k]*ik     k = rank-1                     *
*                                                                          *
*            0 <= ij < n[j]                                                *
*                                                                          *
***************************************************************************/

void dalib_linear_compress (rank, n, inc, rank1, n1, inc1)

int rank;
int n[];
int inc[];
int *rank1;
int n1[];
int inc1[];

{ int i;
  int new_rank;

  new_rank = 0;

  for (i=0; i<rank; i++)

    { int doit = 1;

      if (n[i] == 1) doit = 0;

      if (doit && (new_rank > 0))

         { if (n1[new_rank] * inc1[new_rank] == inc[i])

              { n1[new_rank] *= n[i]; doit = 0; }
         }

      if (doit)

         { n1[new_rank] = n[i]; inc1[new_rank] = inc[i]; new_rank++; }

    } /* for i */

#ifdef DEBUG
    printf ("%d: compressed (", pcb.i);
    for (i=0; i<rank; i++) printf ("n=%d,inc=%d ",n[i],inc[i]);
    printf (") to (");
    for (i=0; i<new_rank; i++) printf ("n=%d,inc=%d ",n1[i],inc1[i]);
    printf (")\n");
#endif

  *rank1 = new_rank;

} /* dalib_linear_compress */
