/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Jan 98                                            *
*                                                                  *
*  This Module is part of the UNILIB                               *
*                                                                  *
*  MODULE : init1.m4                                               *
*                                                                  *
*   - initialization for uniprocessor generated programs           *
*   - this module is independent of all communication systems      *
*                                                                  *
*  UPDATES:                                                        *
*  ========                                                        *
*                                                                  *
*   01/1998  :  evaluate arguments, also time statistics possible  *
*                                                                  *
*******************************************************************/

#define SINGLE

#include "dalib.h"

/*******************************************************************
*                                                                  *
*  void dalib_init (int *int_size, int *real_size, int *addr_size) *
*                                                                  *
*******************************************************************/

void FUNCTION(dalib_init) (int_size, real_size, addr_size)
 
INTEGER *int_size, *real_size, *addr_size;
 
{ char msg[120];

  pcb.p         = 1;    /* number of processors = 1 */
  pcb.i         = 1;    /* my rank is 1             */
  pcb.time_flag = 0;    /* no time statistics       */

  /* verify the correct configuration of the runtime system */

  dalib_check_sizes (*int_size, *real_size, *addr_size);
 
  /* this is important */

  random_block_init ();

  if (pcb.time_flag)

    {
#ifdef DEBUG
      printf("%d: initialize time statistics\n",pcb.i);
#endif
      dalib_init_timestat();
    }

} /* dalib_init */

/*******************************************************************
*                                                                  *
*  void dalib_exit ()                                              *
*                                                                  *
*******************************************************************/

void FUNCTION(dalib_exit) () 

{ if (pcb.time_flag)
     dalib_collect_timestat ();

  dalib_alloc_statistic ();

} /* dalib_exit */

/*******************************************************************
*                                                                  *
*  int dalib_all_procs ()                                          *
*                                                                  *
*   - corresponds to NUMBER_OF_PROCESSORS() in HPF                 *
*                                                                  *
*******************************************************************/

int FUNCTION(dalib_all_procs) () 
{
  return (1);
}

/*******************************************************************
*                                                                  *
*  int dalib_active_procs ()                                       *
*                                                                  *
*   - corresponds to ACTIVE_NUM_PROCS() in HPF 2.0 extensions      *
*                                                                  *
*******************************************************************/

int FUNCTION(dalib_active_procs) () 
{
  return (1);
}

/*******************************************************************
*                                                                  *
*  int dalib_proc_rank ()                                          *
*                                                                  *
*******************************************************************/

int FUNCTION(dalib_proc_rank) () 
{
  return (1);
}
