/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : May 97                                                   *
*  Last Update : May 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : hpf_local.m4                                             *
*                                                                         *
*  Function    : HPF LOCAL LIBRARY                                        *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
*   Note : these routines are called from (local) HPF programs            *
*                                                                         *
**************************************************************************/

#define CHECK
#undef  DEBUG

#include "dalib.h"

/**************************************************************************
*                                                                         *
*                                                                         *
**************************************************************************/

static array_info dalib_get_global_dsp (dsp)

section_info *dsp;

{ array_info array_dsp;
  array_info global_dsp;

  if (dalib_is_section_info (*dsp))

      { array_dsp = (*dsp)->array_id; }

   else if (dalib_is_array_info (*dsp))

      { array_dsp = (array_info) (*dsp); }

   else 

      { dalib_internal_error ("dalib_get_global_dsp : not array/section");
        dalib_stop ();
      }

  global_dsp = array_dsp->GlobalInfo;

  if (global_dsp == NO_ARRAY)

      { dalib_internal_error ("dalib_get_global_dsp : no global array");
        dalib_stop ();
      }

  return global_dsp;

} /* dalib_get_global_dsp */

/**************************************************************************
*                                                                         *
*   GLOBAL_SIZE (ARRAY [,DIM])  -> returns default integer scalar         *
*                                                                         *
*   GLOBAL_SIZE (SIZE, ARRAY, DIM)                                        *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_global_size) (size, array, dim,
                                  size_dsp, array_dsp, dim_dsp)

INTEGER    *size;
char       *array;    /* values not used, only descriptor */
INTEGER    *dim;

array_info *size_dsp;    /* size is assumed to be replicated */
array_info *array_dsp;
array_info *dim_dsp;

{ int idim;

  if (FUNCTION(dalib_present) (dim))
     idim = *dim;
   else
     idim = -1;

  FUNCTION(f77_global_size) (size, array_dsp, &idim);

} /* dalib_global_size */

/**************************************************************************
*                                                                         *
*   GLOBAL_SHAPE (ARRAY)                                                  *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_global_shape) (shape, array, shape_dsp, array_dsp)

INTEGER    *shape;
char       *array;

array_info *shape_dsp;
array_info *array_dsp;

{ 

  FUNCTION(f77_global_shape) (shape, array_dsp);

} /* dalib_global_shape */

/**************************************************************************
*                                                                         *
*   GLOBAL_TEMPLATE (ARRAY, ...)                                          *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_global_template)

  ARGS(`alignee, template_rank, lb, ub, STRING_ARG(axis_type), axis_info,
        number_aligned, dynamic,
        alignee_dsp, rank_dsp, lb_dsp, ub_dsp,
        at_dsp, ai_dsp, na_dsp, dyn_dsp')

char *alignee;
int  *lb, *ub;
STRING_ARG_DECL(axis_type);
int  *axis_info, *number_aligned, *dynamic;
int  *template_rank;

section_info *alignee_dsp;
array_info *rank_dsp, *lb_dsp, *ub_dsp, *at_dsp, *ai_dsp, *na_dsp, *dyn_dsp;

{ array_info global_dsp;

  global_dsp = dalib_get_global_dsp (alignee_dsp);

  FUNCTION(dalib_hpf_template)

  ARGS(`alignee, template_rank, lb, ub, STRING_ARG(axis_type), axis_info,
        number_aligned, dynamic,
        &global_dsp, rank_dsp, lb_dsp, ub_dsp,
        at_dsp, ai_dsp, na_dsp, dyn_dsp');

} /* dalib_global_template */

/**************************************************************************
*                                                                         *
*   GLOBAL_DISTRIBUTION (ARRAY, ...)                                      *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_global_distribution)

 ARGS(`distributee, STRING_ARG(axis_type),
       axis_info,   processors_rank, processors_shape,
       plb,         pub,       pstride,     low_shadow,      high_shadow,
       dist_dsp,    type_dsp,  info_dsp,    rank_dsp,        shape_dsp,
       plb_dsp,     pub_dsp,   pstride_dsp, low_dsp,         high_dsp')

char *distributee;
STRING_ARG_DECL(axis_type);
int  *axis_info;
int  *processors_rank, *processors_shape;
int  *plb, *pub, *pstride, *low_shadow, *high_shadow;

section_info *dist_dsp, *type_dsp, *info_dsp, *rank_dsp, *shape_dsp,
             *plb_dsp,  *pub_dsp,  *pstride_dsp, *low_dsp, *high_dsp;

{ array_info global_dsp;

  global_dsp = dalib_get_global_dsp (dist_dsp);

  FUNCTION(dalib_hpf_distribution)

   ARGS(`distributee, STRING_ARG(axis_type),
         axis_info,   processors_rank, processors_shape,
         plb,         pub,       pstride,     low_shadow,      high_shadow,
         &global_dsp, type_dsp,  info_dsp,    rank_dsp,        shape_dsp,
         plb_dsp,     pub_dsp,   pstride_dsp, low_dsp,         high_dsp');

} /* dalib_global_template */

/**************************************************************************
*                                                                         *
*   GLOBAL_ALIGNMENT (ARRAY, ...)                                         *
*                                                                         *
**************************************************************************/

void FUNCTION(dalib_global_alignment)

  (alignee, lb, ub, stride, axis_map, identity_map, dynamic, ncopies,
   alignee_dsp, lb_dsp, ub_dsp, stride_dsp, map_dsp, id_dsp, ncopies_dsp)

char *alignee;
int  *lb, *ub, *stride, *identity_map, *dynamic, *ncopies;
int  *axis_map;

section_info *alignee_dsp;

{ array_info global_dsp;

  global_dsp = dalib_get_global_dsp (alignee_dsp);

  FUNCTION(dalib_hpf_alignment)

  (alignee, lb, ub, stride, axis_map, identity_map, dynamic, ncopies,
   &global_dsp, lb_dsp, ub_dsp, stride_dsp, map_dsp, id_dsp, ncopies_dsp);

} /* dalib_global_alignment */



