/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Apr 95                                                   *
*  Last Update : Mar 97                                                   *
*                                                                         *
*  This Module is part of the DALIB                                       *
*                                                                         *
*  Module      : functions.m4                                             *
*                                                                         *
*  Function    : realizes some Fortran 90/95 extensions                   *
*                                                                         *
*  Export :  FORTRAN Interface                                            *
*                                                                         *
**************************************************************************/

#define CHECK
#undef DEBUG

#include "dalib.h"

int FUNCTION(dalib_floor) (a)
float *a;

{ int n;
  float nf;
  n = (int) (*a);
  if (*a > 0)  return (n);
  nf = (float) n;
  if (nf == *a) 
      return (n);
    else 
      return (n-1);
} /* dalib_floor */
 
int FUNCTION(dalib_ceiling) (a)
float *a;

{ int n;
  float nf;
  n = (int) (*a);
  if (*a < 0)  return (n);
  nf = (float) n;
  if (nf == *a) 
      return (n);
    else 
      return (n+1);
} /* dalib_ceiling */

/*******************************************************************
*                                                                  *
*   int LEN_TRIM (string)                                          *
*                                                                  *
*     - result has a value equal to the number of characters       *
*       remaining after any trailing blanks in STRING are          *
*       removed. If the argument contains no nonblank characters,  *
*       the result is zero.                                        *
*                                                                  *
*    LEN_TRIM (' A B  ') has the value 4                           *
*    LEN_TRIM ('   ')    has the value 0                           *
*                                                                  *
*******************************************************************/

int FUNCTION(dalib_len_trim)
    ARGS(`STRING_ARG(string)')

STRING_ARG_DECL(string);

{ int len;
  char *ptr;

  int i, pos;

  ptr = STRING_PTR(string);
  len = STRING_LEN(string);

  pos = 0;

  for (i=0; i<len; i++)
    { if (ptr[i]!=' ') pos = i+1; }

  return (pos);
} /* dalib_len_trim */

int FUNCTION(dalib_verify)
    ARGS(`STRING_ARG(string), STRING_ARG(set), back')

STRING_ARG_DECL(string);
STRING_ARG_DECL(set);
INTEGER *back;                  /* LOGICAL */

{ int is_back, found;
  int i, j;

  char *str_pointer, *set_pointer;
  int  str_length, set_length;

  str_length     = STRING_LEN(string);
  set_length = STRING_LEN(set);

  str_pointer     = STRING_PTR(string);
  set_pointer = STRING_PTR(set);

  if (FUNCTION(dalib_present)(back))

     { if (*back)
         is_back = 1;
       else
         is_back = 0;
     }

    else

     is_back = 0;    /* default of back is .false. */

#ifdef DEBUG
  printf ("VERIFY, str_length = %d, set_length = %d, back = %d\n",
           str_length, set_length, is_back);
#endif

  if (is_back)

    { for (i=str_length-1; str_length >= 0; i--)

        { found = 0;

          for (j=0; j<set_length; j++)
             found = found || (str_pointer[i] == set_pointer[j]);

#ifdef DEBUG
          printf ("found at pos %d = %d\n", i+1, found);
#endif

          if (!found) return (i+1);
        }

    } /* search backward */

   else

    {  for (i=0; i<str_length; i++)

       { found = 0;

         for (j=0; j<set_length; j++)
            found = found || (str_pointer[i] == set_pointer[j]);

#ifdef DEBUG
         printf ("found at pos %d = %d\n", i+1, found);
#endif

         if (!found) return (i+1);
       }

    }  /* search forward */

  return (0);

} /* dalib_verify */

/*********************************************************************
*                                                                    *
*  void dalib_mvbits                                                 *
*                                                                    *
*  - copies bit sequence (from [frompos], ..., from[frompos+len-1])  *
*    into (to[topos], ..., to[topos+len-1])                          *
*                                                                    *
*********************************************************************/

void FUNCTION(dalib_mvbits) (from, frompos, len, to, topos)

int *from, *frompos, *len, *to, *topos;

{ int mask;

  mask = 0;

  /*  assert: frompos + len <= bit_size */
  /*  assert: topos + len <= bit_size   */

  /*  mask =    0 0  1  1  1  1 0 0 0  */

  mask = mask & (*from);
 
#ifdef SUN4SOL2
  FUNCTION(mvbits) (from, frompos, len, to, topos);
#else
  /* definitively not available on Cenju-3, SX-4 */
  dalib_internal_error ("MVBITS not realized yet");
  dalib_stop();
#endif

} /* dalib_mvbits */
