/**************************************************************************
*                                                                         *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                        *
*  Copyright   : GMD St. Augustin, Germany                                *
*  Date        : Jul 97                                                   *
*  Last Update : Jul 97                                                   *
*                                                                         *
*  This Module is part of the UNILIB                                      *
*                                                                         *
*  Module      : dummy                                                    *
*                                                                         *
*  Function    : operations for descriptors cumm - actual                 *
*                                                                         *
*  Changes:                                                               *
*                                                                         *
**************************************************************************/

#undef DEBUG

#include "dalib.h"

/**************************************************************************
*                                                                         *
*  PREDICATE dalib_array_same_dim (DimInfo *dim1, DimInfo *dim2)          *
*                                                                         *
*  - dim1 and dim2 must be have same global and local size                *
*  - local part must be relatively the same                               *
*  - dim1 (actual) must have bigger overlap than dim2 (dummy)             *
*                                                                         *
**************************************************************************/

int dalib_array_same_dim (a_dim, d_dim)

DimInfo *a_dim, *d_dim;

{ int extent, offset;

  /* same global size */

#ifdef DEBUG
  printf ("%d: same dim, size = (%d:%d-%d:%d), shdw = (%d:%d-%d:%d)\n",
           pcb.i, a_dim->global_size[0], a_dim->global_size[1],
           d_dim->global_size[0], d_dim->global_size[1],
           a_dim->overlap[0], a_dim->overlap[1],
           d_dim->overlap[0], d_dim->overlap[1]);
#endif

  extent = a_dim->global_size[1] - a_dim->global_size[0];
  if (d_dim->global_size[1] - d_dim->global_size[0] != extent) return (0);

  /* same local size */

  extent = a_dim->local_size[1] - a_dim->local_size[0];
  if (d_dim->local_size[1] - d_dim->local_size[0] != extent) return (0);
  if (a_dim->local_size[2] != d_dim->local_size[2]) return (0);

#ifdef DEBUG
  printf ("local (%d:%d:%d = %d:%d:%d), map (%d:%d)\n",
           d_dim->local_size[0], d_dim->local_size[1],
           d_dim->local_size[2], 
           a_dim->local_size[0], a_dim->local_size[1],
           a_dim->local_size[2],
           d_dim->map_flag,
           a_dim->map_flag);
#endif

  /* if it is a mapped dimension, they must have the same distribution */

  if (d_dim->map_flag != a_dim->map_flag) return (0);

  if (a_dim->map_flag)

     { /* both dimensions are mapped, so they should have same distrib. */

       return (0);
     }
  
  /* offset between global and local size must be the same */

  offset = a_dim->global_size[0] - d_dim->global_size[0];
  if (a_dim->local_size[0] - d_dim->local_size[0] != offset) return (0);

  /* check overlap size, a_dim must not have bigger one than d_dim */

  if (a_dim->overlap[0] > d_dim->overlap[0]) return (0);
  if (a_dim->overlap[1] > d_dim->overlap[1]) return (0);

  /* now everything is equal */

  return (1);

} /* dalib_array_same_dim */

/**************************************************************************
*                                                                         *
*  PREDICATE dalib_array_same_shape (array_id, dummy_id)                  *
*                                                                         *
*   - returns 1 if array_id and dummy_id are globally/locally conform     *
*     and if dummy_id has enough overlap                                  *
*                                                                         *
**************************************************************************/

int dalib_array_same_shape (array_id, dummy_id)

array_info array_id, dummy_id;

{ DimInfo *dim1, *ddim;
  int rank, size;
  int i, equal;

#ifdef DEBUG
  printf ("%d: dalib_array_same_shape of %d (rank=%d) and %d (rank=%d)\n", 
           pcb.i, array_id, array_id->rank, dummy_id, dummy_id->rank);
#endif

  rank = array_id->rank;
  if (rank != dummy_id->rank) return (0);

  size = array_id->size;
  if (size != dummy_id->size) return (0);

  dim1 = array_id->dimensions;
  ddim = dummy_id->dimensions;

  equal = 1;

  for (i=0; i<rank; i++)        /* comparison of every dimension */

     if (!dalib_array_same_dim (dim1+i,ddim+i)) 

       {
#ifdef DEBUG
         printf ("dim %d is different\n", i+1);
#endif
         equal = 0;
       }

#ifdef DEBUG
  printf ("%d: same shape, result = %d\n", pcb.i, equal);
#endif

  return (equal);

} /* dalib_array_same_shape */

/**************************************************************************
*                                                                         *
*   int dalib_use_actual_data (dummy_id, actual_id)                       *
*                                                                         *
*    - returns true if data of actual can be used directly                *
*    - condition 1 : actual_id has same local shape as dummy_id           *
*    - condition 2 : if dummy_id is shared, actual_id must be shared too  *
*                                                                         *
**************************************************************************/
 
int dalib_use_actual_data (dummy_id, actual_id)

array_info dummy_id, actual_id;

{ if (!dalib_array_same_shape (dummy_id, actual_id))

      return (0);

  /* if dummy is not shared but array should be shared */

  if (dummy_id->SharedInfo != NO_SHARED)

     { if (actual_id->SharedInfo == NO_SHARED)
          return (0);
     }

  return (1);

}  /* dalib_use_actual_data */

/**************************************************************************
*                                                                         *
*   int dalib_is_dummy_data (array_id, dummy_id)                          *
*                                                                         *
*    - returns true if array_id has still same data as dummy              *
*                                                                         *
**************************************************************************/
 
int dalib_is_dummy_data (array_id, dummy_id)

array_info array_id, dummy_id;

{ if (array_id->data != dummy_id->data) return (0);  /* cannot be used */

  if (array_id->dsp_status_flag == DSP_OWN_DATA)

     return (0);  /* has new data allocated */

  return (1);   /* now we are sure that it is the same data */

} /* dalib_is_dummy_data */

/*******************************************************************
*                                                                  *
*  void dalib_get_actual_info (array_info dummy_dsp, actual_dsp)   *
*                                                                  *
*  - dummy inherits the data directly from the actual argument     *
*  - dummy inherits also the overlap size of the actual argument   *
*                                                                  *
*******************************************************************/

void dalib_get_actual_info (dummy_dsp, actual_dsp)

array_info dummy_dsp, actual_dsp;

{ DimInfo *local_dims, *dummy_dims;
  int i, rank;
 
  local_dims = dummy_dsp->dimensions;
  dummy_dims = actual_dsp->dimensions;
 
  rank = dummy_dsp->rank;   /* == actual_dsp->rank */

  /* inherit data pointer */

  dummy_dsp->data            = actual_dsp->data;
  dummy_dsp->dsp_status_flag = actual_dsp->dsp_status_flag;

  if (actual_dsp->dsp_status_flag == DSP_OWN_DATA)
    dummy_dsp->dsp_status_flag = DSP_PTR_DATA;  /* is default, but make sure */

  /* inherit size of overlap area */

  for (i=0; i<rank; i++, local_dims++, dummy_dims++)

     { local_dims->overlap[0] = dummy_dims->overlap[0];
       local_dims->overlap[1] = dummy_dims->overlap[1];
     }

} /* dalib_get_actual_info */

/**************************************************************************
*                                                                         *
*  void dalib_copy_info (array_info dsp1, array_info dsp2)                *
*                                                                         *
*  - copy the valid info from descriptor dsp2 to dsp1                     *
*                                                                         *
**************************************************************************/

void dalib_copy_valid_info (dsp1, dsp2, destroy_flag)

array_info dsp1, dsp2;

int destroy_flag;

{ array_info a1, a2;

  if (dalib_is_section_info (dsp1))
     a1 = ((section_info) dsp1)->array_id;
    else
     a1 = dsp1;
    
  if (dalib_is_section_info (dsp2))
     a2 = ((section_info) dsp2)->array_id;
    else
     a2 = dsp2;
    
  if (a2->trace)

     { if (a1->trace)

         a1->reuse_bits = a2->reuse_bits;
   
        else if (destroy_flag)

         FUNCTION(dalib_array_set_dirty) (&a2);

     }

} /* dalib_copy_valid_info */

