/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Apr 93                                            *
*                                                                  *
*  MODULE : arguments.m4                                           *
*                                                                  *
*  void eval_arg (default_NP, max_NP)                              *
*                                                                  *
*  Get values for number of processors and set trace_flag          *
*                                                                  *
*   setenv NP 10 or 2x5 or 2x2x3                                   *
*   setenv TRACE on | 1 | ON                                       *
*                                                                  *
*  command line arguments have highest priority                    *
*                                                                  *
*******************************************************************/

#undef DEBUG

#if defined(SX4)
/* make sure that INDEX routine returns address and not integer */
#include <string.h>
#endif

#include "dalib.h"

#define ARG_SIZE 120 

char program_name [40];

extern char *getenv ();

void dalib_set_top1 (n1)
int n1;
{
#ifdef DEBUG
  printf ("dalib_set_top1 (%d)\n", n1);
#endif
  pcb.p = n1;
  pcb.p_rank = 1;
  pcb.p2_1 = 0;
  pcb.p2_2 = 0;
  pcb.p3_1 = 0;
  pcb.p3_2 = 0;
  pcb.p3_3 = 0;
} /* dalib_set_top1 */

void dalib_set_top2 (n1, n2)
int n1, n2;

{
#ifdef DEBUG
  printf ("dalib_set_top2 (%d, %d)\n", n1, n2);
#endif

  pcb.p = n1 * n2;
  pcb.p_rank = 2;
  pcb.p2_1 = n1;
  pcb.p2_2 = n2;
  pcb.p3_1 = 0;
  pcb.p3_2 = 0;
  pcb.p3_3 = 0;
}

void dalib_set_top3 (n1, n2, n3)
int n1, n2, n3;

{
#ifdef DEBUG
  printf ("dalib_set_top3 (%d, %d, %d)\n", n1, n2, n3);
#endif

  pcb.p = n1 * n2 * n3;
  pcb.p_rank = 3;
  pcb.p2_1 = 0;
  pcb.p2_2 = 0;
  pcb.p3_1 = n1;
  pcb.p3_2 = n2;
  pcb.p3_3 = n3;
}

void dalib_env_top2 (argument)
char *argument;

{ int n1, n2;
  if (sscanf (argument, "%dx%d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
  else if (sscanf (argument, "%dX%d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
  else if (sscanf (argument, "%d %d", &n1, &n2) == 2)
     dalib_set_top2 (n1, n2);
} /* dalib_env_top2 */

void dalib_env_top3 (argument)
char *argument;

{ int n1, n2, n3;
  if (sscanf (argument, "%dx%dx%d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
  else if (sscanf (argument, "%dX%dX%d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
  else if (sscanf (argument, "%d %d %d", &n1, &n2, &n3) == 3)
     dalib_set_top3 (n1, n2, n3);
} /* dalib_env_top3 */

void dalib_print_arg_info ()

{  printf (
     "<executable> [-call] [-redist] [-comm] [-time] [n1 [ x n2 [ x n3]]]\n"
   );

   /* normal termination without error: stops other processes (?) */

   dalib_exit (0);

} /* dalib_print_arg_info */

/*******************************************************************
*                                                                  *
*  void eval_arg (int default_NP, int max_NP)                      *
*                                                                  *
*******************************************************************/

void eval_arg (default_NP, max_NP)

int default_NP, max_NP;

{ char *argument;

#if defined(HPPA)
  char *GETARG ();
#elif  defined (CRAY)
  char *PXFGETARG (); int ilen; int ierror;
  _fcd argument_fcd;
#elif defined(PowerPC) 
  /* getarg not avialable */
#else
  char *getarg_ ();
#endif

  char argval[ARG_SIZE];
  char *p;
  int narg;

#if defined(HPPA) || defined(CRAY)
  int IARGC ();
#elif defined(PowerPC)
  /* iarg not available for PowerPC */
#else
  int iargc_ ();
#endif

  int i, j;
  int NP;

  /* defaults */

  NP = default_NP;

  dalib_set_top1 (NP);

  pcb.trace_flag = 0;    /* default start without trace */
  pcb.call_flag = 0;     /* default start without call trace */
  pcb.redist_flag = 0;   /* default start without redist trace */
  pcb.comm_flag = 0;     /* default start without comm statistics */
  pcb.time_flag = 0;     /* default start without time statistics */

  argument = getenv ("NP");
  if (argument != ((char *)0) )
     {  /* printf ("eval environment variable NP = %s\n", argument); */
        sscanf (argument, "%d", &NP);
        dalib_set_top1 (NP);
        dalib_env_top2 (argument);
        dalib_env_top3 (argument);
        NP = pcb.p;
     }

  argument = getenv ("TRACE");
  if (argument != ((char *)0) )
     {  /* printf ("eval environment variable TRACE = %s\n", argument); */
        if (strcmp(argument,"1") == 0)
           pcb.trace_flag = 1;
         else if (strcmp(argument,"on") == 0)
           pcb.trace_flag = 1;
         else if (strcmp(argument,"ON") == 0)
           pcb.trace_flag = 1;
#ifdef DEBUG
        printf ("trace_flag = %d\n", pcb.trace_flag);
#endif
     }

#if defined(HPPA)
  narg = IARGC ();
#elif defined(CRAY)
  narg = IARGC ();
#elif defined(PowerPC)
  narg = 0;
#else
  narg = iargc_ ();
#endif

  for (i=0;i<=narg;i++)

      { 
#if defined(HPPA)
        GETARG (&i, argval, ARG_SIZE-1);
#elif defined(CRAY)
        argument_fcd = _cptofcd (argval, ARG_SIZE-1);
        PXFGETARG (&i, argument_fcd, &ilen, &ierror);
#elif defined(PowerPC)
        /* getarg not available */
#else
        getarg_ (&i, argval, ARG_SIZE-1);
#endif

        /* Trim trailing blanks */

        p = (char *) INDEX(argval, ' ');

        if (p)   /* p can be the null pointer if no blanks in argval 
                    bug report of Soma Ghosh, 27th Nov 1997          */

           *p = '\0';

        printf ("arg[%d] = :%s:\n", i, argval);

        if (i == 0)
 
         { /* find the program name */

           p = (char *) strrchr (argval, '/');
 
           if (p != (char *) 0)
              p = p + 1;
            else
              p = argval;

           strcpy (program_name, p);

         }

         else if (strcmp (argval, "-t") == 0)
           pcb.trace_flag = 1;
         else if (strcmp (argval, "-call") == 0)
           pcb.call_flag = 1;
         else if (strcmp (argval, "-redist") == 0)
           pcb.redist_flag = 1;
         else if (strcmp (argval, "-time") == 0)
           pcb.time_flag = 1;
         else if (strcmp (argval, "-comm") == 0)
           pcb.comm_flag = 1;
          else if (strcmp (argval, "-help") == 0)
           dalib_print_arg_info ();
          else if (strcmp (argval, "-n") == 0)
           pcb.trace_flag = 0;
          else
           { sscanf (argval, "%d", &NP);
             dalib_set_top1 (NP);
             dalib_env_top2 (argval);
             dalib_env_top3 (argval);
             NP = pcb.p;
           }
      }

  /* Enter number of processes */

  while ((NP > max_NP) || (NP < 1))
   { printf ("Please enter number of processes : \n");
     scanf ("%d",&NP);
     dalib_set_top1 (NP);
     if ((NP > max_NP) || (NP < 1))
       { printf ("Illegal Number of Processes (only %d - %d)\n", 1, max_NP);
         NP = 0;
       }
   }

  NP = pcb.p;

  if (pcb.trace_flag == 1)
     printf ("starting %d processes with trace\n", NP);
#ifdef DEBUG
    else
     printf ("starting %d processes\n", NP);
#endif

}  /* eval_arg */
