/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, SCAI.LAB                 *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Apr 96                                            *
*  Last Update : Apr 96                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  INITIALIZATION OF PROGRAM for PVM (Version 3.0)                 *
*  SPECIAL VERSION for the CRAY T3D                                *
*                                                                  *
*  MODULE : init.c                                                 *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*  INTERFACE                                                       *
*  =========                                                       *
*                                                                  *
*    void dalib_machine_exit ()                                    *
*                                                                  *
*    void dalib_machine_enroll (int *AllNP)                        *
*                                                                  *
*      - makes machine dependent initialization                    *
*      - return in pcb.i the relative processor position           *
*      - return in pcb.p the number of real existing processes     *
*      - Process 0 or 1 returns in AllNP number of processes       *
*        that will be used really (from environment, command line) *
*                                                                  *
*******************************************************************/

#include <stdio.h>
#include <string.h>
#include "pvm3.h"
#include "dalib.h"

#undef DEBUG

/*******************************************************************
*                                                                  *
*  Task Ids for PVM version 3.0                                    *
*                                                                  *
*******************************************************************/

int tids[MAXP1];

int NP;   /* number of processes that are really used */

/*******************************************************************
*                                                                  *
*  Machine dependent functions                                     *
*                                                                  *
*******************************************************************/

# define INIT_MSGID  9999

          /***********************************************
          *                                              *
          *  dalib_machine_exit ()                       *
          *                                              *
          ***********************************************/

void dalib_machine_exit ()

{

  pvm_exit ();

} /* dalib_machine_exit */

/*********************************************************************
*                                                                    *
*    enroll: starts and makes initializations                        *
*                                                                    *
*********************************************************************/

void dalib_machine_enroll (AllNP)

int *AllNP;

{ int my_tid, NP;
  int i;
 
  /* enroll in PVM */
 
  my_tid = _my_pe();
  NP     = _num_pes ();
 
#ifdef DEBUG
  printf ("node %d of %d started\n", my_tid, NP);
#endif
 
  /* setting the task identifiers is very simple */
 
  for (i=0; i<NP+1; i++)
     tids[i] = i-1;
 
  pcb.i  = my_tid + 1;
  pcb.p  = NP;
 
  /* definition of the process control block */
 
  if (pcb.i == 1)
     eval_arg (NP, NP);
 
  *AllNP     = NP;   /* that are all processors, but might be less later */
}
