/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, I1.LAB                   *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Feb 94                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  MODULE : init.c                                                 *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*                                                                  *
*******************************************************************/

/* #include <machine/param.h> */

#include <stdio.h>
#include <string.h>
#include <cm/cmmd.h>
#include <cm/cmmd/io.h>
#include "dalib.h"

void dalib_machine_exit ()

{ /* nothing to do at the end */
}

int tids [MAXP1];  /* task identfiers for CMMD processes */

#define INIT_MSGID 9999
#undef DEBUG

void dalib_io_node ()

{
  CMMD_fset_io_mode(stdin, CMMD_independent);
  CMMD_fset_io_mode(stdout, CMMD_independent);
  CMMD_fset_io_mode(stderr, CMMD_independent);
}

void dalib_machine_enroll (NP)

int *NP;

{ int rank, size;
  int i;

  rank = CMMD_self_address();
  size = CMMD_partition_size ();

#ifdef DEBUG
    printf( "Process %d of %d is alive\n", rank, size );
#endif

        pcb.i = rank+1;
        *NP   = size;

        dalib_io_node ();

        for (i=1; i<=size; i++)
           tids[i] = i-1;

    if (pcb.i == 1)

      { /* only first process gets the parameters */

        eval_arg (*NP, *NP);

      }

} /* dalib_machine_enroll */

