/* Copyright (c) 1989 Michel Fortier and Peter A. Buhr */

/*
 * this is a set of routine using a symbol table
 * it is used to store typedef, void and condition symbols
 */

#include <stdio.h>
#include <uUnix.h>

/* 
 * INCLUDE FILES
 */

/*
 * symbol_table.h contains value used in the symbol table
 */

#include "uMpp.h"
#include "uTable.h"

/* 
 * GLOBAL VARIABLES
 */

typedef struct Node {	/* description of an entry of the symbol table */
    char   *name;
    int    type;
    int    level;
    struct Node *next;
} Node;

static struct Node *symbol_table = 0; 		/* symbol table */
static int         symbol_level = 0;		/* current level */
static struct Node *other_table = 0;		/* other symbol table */
static struct Node *cond_table = 0;		/* table of condition */

/* 
 * search symbol in the symbol table
 */

int lookup_id( name )
    char *name;
{
    struct Node *l;
    int         found;
    
    l = symbol_table;
    found = 1;
    while ( l && found == 1 ) {
	if ( ! strcmp( name, l -> name ) && l -> level >= 0 ) {
	    found = 0;
	} else {
	    l = l -> next;
	}
    }
    return found;
}

/*
 * add symbol to the symbol table
 */

void add_typedef( name, type )
    char *name;
    int type;
{
   struct Node *n;
   
   n = ( Node * )xmalloc( sizeof( Node ) );
   n -> name = ( char * )xmalloc( strlen( name ) + 1 );
   strcpy( n -> name, name );
   n -> type = type;
   n -> level = symbol_level;
   n -> next = symbol_table;
   symbol_table = n;
}

/* 
 * return type of a symbol of the symbol table
 */

int typedef_type( name )
    char *name;
{
    struct Node *l;
    int         found;
    
    l = symbol_table;
    found = 1;
    while ( l && ( found = strcmp( name, l -> name ) ) ) {
	l = l -> next;
    }
    if ( found == 0 ) {
	return l -> type;
    }
    return 0;
}

/*
 * modify type of a symbol of the symbol table
 * and add it to the other symbol table
 */

void modify_typedef( name )
    char *name;
{
    struct Node *l, *n;
    int         found;
    
    l = symbol_table;
    found = 1;
    while ( l && ( found = strcmp( name, l -> name ) ) ) {
	l = l -> next;
    }
    if ( found == 0 ) {
	l -> level *= -1;
    }
    
    n = ( Node * )xmalloc( sizeof( Node ) );
    n -> name = ( char * )xmalloc( strlen( name ) + 1 );
    strcpy( n -> name, name );
    n -> level = symbol_level;
    n -> next = other_table;
    other_table = n;
}

/*
 * increment current level
 */

void push_level()
{
    symbol_level += 1;
}

/*
 * free all declaration at the current level
 * and decrement current level
 */

void pop_level()
{
    struct Node *l, *n;
    int         found;
    
    l = other_table;
    while ( l && l -> level == symbol_level ) {
	n = symbol_table;
	found = 1;
	while ( n && found == 1 ) {
	    if ( ! strcmp( l -> name, n -> name ) && n -> level < 0 ) {
		found = 0;
		n -> level *= -1;
	    } else {
		n = n -> next;
	    }
	}
	other_table = l -> next;
	free( l -> name );
	free( l );
	l = other_table;
    }
    
    l = symbol_table;
    while ( l != 0 && l -> level == symbol_level) {
	symbol_table = l -> next;
	free( l -> name );
	free( l );
	l = symbol_table;
    }
    
    symbol_level -= 1;
}

/*
 * add condition to the condition table
 */

void add_condition( type, name )
    int type;
    char *name;
{
    struct Node *n;
    
    n = ( Node * )xmalloc( sizeof( Node ) );
    n -> name = name;
    n -> type = type;
    n -> next = cond_table;
    cond_table = n;
}

