/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cpp.c -- Command for preforming the monitor preprocessor pass after the cpp preprocessor pass.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Sat Nov 17 12:05:29 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Sep  4 23:59:19 1994
 * Update Count     : 32
 */

#include <stdio.h>
#include <uUnix.h>
#include <shell.h>
#include <vstrcat.h>

#define MAX 1024

char *home = HOME;

int main( int argc, char *argv[] ) {

    int i;
    int code;
    char *dir = "/release";
    char tmp[MAX];
    char arg[MAX] = "";
    char argCppOnly[MAX] = "";
    char com[MAX] = "";
    char *cpp_in = (char *)0;
    char *cpp_out = (char *)0;
    int  mpp_flag = 0;
    int  mwk_flag = 0;

    /* get a name of a temporary file */
    
    sprintf( tmp, "/tmp/moncc%d", getpid() );

    /* process the arguments */
    
    for ( i = 1; i < argc; i += 1 ) {
	if ( argv[i][0] == '-' ) {
	    if ( strcmp( argv[i], "-D__MON__" ) == 0 ) {
		mpp_flag = 1;				/* strip the -D__MON__ flag */
	    } else if ( strcmp( argv[i], "-D__MONWORK__" ) == 0 ) {
		mwk_flag = 1;				/* strip the -D__MONWORK__ flag */
		dir = "/work";
	    } else if ( strncmp( argv[i], "-lang", strlen( "-lang" ) ) == 0 ) {
							/* strip the -lang flag */
	    } else if ( strcmp( argv[i], "-MD" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-MMD" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-imacros" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-include" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-idirafter" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-iprefix" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-iwithprefix" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( strcmp( argv[i], "-isystem" ) == 0 ) {
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
		i += 1;
		vstrcat( argCppOnly, " ", argv[i], (char *)0 );
	    } else if ( argv[i][1] != '+' ) {
		vstrcat( arg, " ", argv[i], (char *)0 );
	    } /* if */
	} else {
	    if ( cpp_in == (char *)0 ) {
		cpp_in = argv[i];
	    } else if ( cpp_out == (char *)0 ) {
		cpp_out = argv[i];
	    } else {
		fprintf( stderr, "usage: %s input-file [output-file] [options]\n", argv[0] );
		exit( 1 );
	    } /* if */
	} /* if */
    } /* for */

    if ( cpp_out == (char *)0 && mpp_flag ) {
	fprintf( stderr, "error: cannot use -E and -MON flags together.\n" );
	exit( -1 );
    } /* if */

    if ( cpp_out == (char *)0 ) {
	vstrcat( com, "gcc -E", arg, " ", argCppOnly, " ", cpp_in, (char *)0 );
	shell( com );
	exit( -1 );
    } /* if */

    /* Run the preprocessor on the source file and */
    /* save the resulting text in a temporary file. */

    vstrcat( com, "gcc -E", arg, " ", argCppOnly, " ", cpp_in, " > ", tmp, (char *)0 );
    code = shell( com );
    if ( code != 0 ) {
	unlink( tmp );
	exit( code );
    } /* if */

    strcpy( com, "" );

    /* If the user wishes to see the results of his efforts, run */
    /* the mon-cpp preprocessor on the file, and spill the output */
    /* onto standard output.  Then, we exit abnormally to halt */
    /* the compilation process. */
    
    if ( mpp_flag ) {
	vstrcat( com, home, "/monitor", dir, "/bin/mon-cpp ", tmp, (char *)0 );
	shell( com );
	unlink( tmp );
	exit( -1 );					/* do not continue compilation */
    } /* if */

    /* Otherwise, save the result into the output file or standard output */
    /* and let the host compiler continue. */

    vstrcat( com, home, "/monitor", dir, "/bin/mon-cpp ", tmp, " ", cpp_out, (char *)0 );
    code = shell( com );
    unlink( tmp );
    if ( code != 0 ) {					/* shell can return + and - code */
	exit( -1 );					/* do not continue compilation */
    } /* if */
    return( 0 );
} /* main */

/* Local Variables: */
/* compile-command: "/bin/make -k" */
/* End: */
