/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uReap.c -- Provides an asynchronous die facility.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:29:24 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:10:26 1992
 * Update Count     : 14
 */

#include <uSystem.h>
#include <uReap.h>

static uTask uReapTask = NULL;
static uSemaphore uFirst = U_SEMAPHORE( 1 );

static void uReap( void ) {

    uTask client;

    for ( ;; ) {
	client = uReceive( NULL, 0 );
	uReply( client, NULL, 0 );
	uAbsorb( client, NULL, 0 );
    } /* for */

} /* uReap */

volatile void uDieAlone( void ) {

    uP( &uFirst );
    if ( uReapTask == NULL ) {
	uReapTask = uEmit( uReap );
    } /* if */
    uV( &uFirst );
    
    uSend( uReapTask, NULL, 0, NULL, 0 );
    uDie( NULL, 0 );

    /* task never gets to this point */

} /* uDieAlone */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
