/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uStream.h -- Declaration of objects that the uSystem makes available to the user.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:24:19 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:10:43 1992
 * Update Count     : 61
 */

#ifndef __U_STREAMH__
#define __U_STREAMH__

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Handle to opaque uStream descriptor.
 */
typedef struct uStreamD *uStream;

/*
 * These are the external variables that the uKernel
 * provides.
 */

extern uStream uStdin;
extern uStream uStdout;
extern uStream uStderr;

extern void uInstallStandardStream( void );
extern void uDestallStandardStream( void );
extern int uFeof( uStream );
extern int uFerror( uStream );
extern void uClearerr( uStream );
extern int uFileno( uStream );
extern uStream uFopen( char *, char * );
extern int uFflush( uStream );
extern int uFclose( uStream );
extern int uFgetc( uStream );
extern char *uFgets( char *, int, uStream );
extern int uGetc( uStream );
extern int uGetchar( void );
extern char *uGets( char *, int );
extern int uUngetc( int, uStream );
extern int uFputc( char, uStream );
extern int uFputs( char *, uStream );
extern int uPutc( char, uStream );
extern int uPutchar( char );
extern void uPuts( char * );
extern int uFscanf( uStream, char *, ... );
extern int uScanf( char *, ... );
extern int uFprintf( uStream, char *, ... );
extern int uPrintf( char *, ... );
extern int uFread( char *, int, int, uStream );
extern int uFwrite( char *, int, int, uStream );
extern int uFseek( uStream, long, int );
extern uStream uFreopen( char *, char *, uStream );
extern void uRewind( uStream );
extern uStream uFinstall( FILE * );
extern void uFdestall( uStream );

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif /* __U_STREAMH__ */
