/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Frank J. Henigman 1990
 * 
 * uSGIGraphics.h -- Declarations of the uSystem SGI Graphics Interface package.
 * 
 * Author           : Frank J. Henigman
 * Created On       : Mon Jun 18 07:40:32 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:10:41 1992
 * Update Count     : 17
 */

#ifndef __U_SGIGRAPHICSH__
#define __U_SGIGRAPHICSH__

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <gl.h>
#include <device.h>

void uGrOpen( char * );
void uGrClose( char * );
void uGrAcquire( void );
void uGrRelease( void );

#define NULLWIN		(-1L)

typedef struct {
    Device device;
    long wid;
    short value;
} uGrEvent;

void uGrQdevice( Device, long );
void uGrUnqdevice( Device, long );
uGrEvent uGrQtest( void );
uGrEvent uGrQread( void );
void uGrQreset( Device, long );
Boolean uGrIsqueued( Device, long );
void uGrQenter( Device, long, short );
long uGrBlkQread( uGrEvent *, short );
void uGrTie( Device, long, Device, Device );
void uGrNoise( Device, long, short );

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif /* __U_SGIGRAPHICSH__ */
