/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uFile.h -- Declarations of uFile package.
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Mon Feb 26 20:56:31 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Jan  4 23:59:55 1994
 * Update Count     : 54
 */

#ifndef __U_FILEH__
#define __U_FILEH__

/*
 * Do not wrap system include files for AT&T C++ because
 * on some architectures C++ header files declare
 * prototypes which conflicit with system prototypes.
 */

#ifdef __GNUG__
extern "C" {
#endif

#include <sys/types.h>
#include <sys/file.h>
#include <fcntl.h>

#if __GNUG__
}
#endif

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Handle to opaque uFile descriptor
 */
typedef struct uFileD *uFile;

/*
 * These are the external variables that the uKernel provides.
 */
    
extern void uFileEnter( uFile );
extern void uFileLeave( uFile, uCluster );
extern int uFileFd( uFile );
extern uFile uOpen( char *, int, int );
extern int uRead( uFile, void *, int );
extern int uWrite( uFile, void *, int );
extern off_t uLseek( uFile, off_t, int );
extern int uFsync( uFile );
extern int uClose( uFile );
extern uFile uSocket( int, int, int );
extern int uBind( uFile, void *, int );
extern int uConnect( uFile, void *, int );
extern int uListen( uFile, int );
extern uFile uAccept( uFile, void *, int * );
extern int uSsend( uFile, void *, int, int );
extern int uSendto( uFile, void *, int, int, void *, int );
extern int uSendmsg( uFile, void *, int );
extern int uRecv( uFile, void *, int, int );
extern int uRecvfrom( uFile, void *, int, int, void *, int * );
extern int uRecvmsg( uFile, void *, int );
extern int uGetsockname( uFile, void *, int * );

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif /* __U_FILEH__ */
