/*                               -*- Mode: C -*- 
 *
 * uSystem Version 4.4.3, Copyright (C) Hamish Macdonald 1990
 *
 * uSysExcepts.c -- uSystem exception declarations. 
 *
 * Author          : Hamish Macdonald
 * Created On      : Thu Oct 11 15:30:38 1990
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Mon Jan 20 22:14:43 1992
 * Update Count    : 24
 */

#include "uSystem.h"

uException uSystemEx = U_EXCEPTION( &uAny );

uException   uKernelEx = U_EXCEPTION( &uSystemEx );
uException     uDataCommEx = U_EXCEPTION( &uKernelEx );
uException       uDataCopyEx = U_EXCEPTION( &uDataCommEx );
uException         uSendMsgTooLongEx = U_EXCEPTION( &uDataCopyEx );
uException         uReplyAreaTooShortEx = U_EXCEPTION( &uDataCopyEx );
uException         uForwardMsgTooLongEx = U_EXCEPTION( &uDataCopyEx );
uException         uAbsorbAreaTooShortEx = U_EXCEPTION( &uDataCopyEx );
uException         uSuspendMsgTooLongEx = U_EXCEPTION( &uDataCopyEx );
uException         uResumeMsgTooLongEx = U_EXCEPTION( &uDataCopyEx );
uException       uBadCoroutineEx = U_EXCEPTION( &uDataCommEx );
uException       uSyncFailEx = U_EXCEPTION( &uDataCommEx );
uException         uNotReplyBlockedEx = U_EXCEPTION( &uSyncFailEx );
uException         uInvalidForwardEx = U_EXCEPTION( &uSyncFailEx );
uException     uCreationEx = U_EXCEPTION( &uKernelEx );
uException       uCreateClusterEx = U_EXCEPTION( &uCreationEx );
uException       uEmitEx = U_EXCEPTION( &uCreationEx );
uException       uCocallEx = U_EXCEPTION( &uCreationEx );
uException       uCreateProcessorEx = U_EXCEPTION( &uCreationEx );
uException     uActiveTasksEx = U_EXCEPTION( &uKernelEx );

uException     uBadInterEx = U_EXCEPTION( &uKernelEx );

uException   uOutOfMemoryEx = U_EXCEPTION( &uSystemEx );
uException     uNoExtendEx = U_EXCEPTION( &uOutOfMemoryEx );

uException   uIOEx = U_EXCEPTION( &uSystemEx );
uException     uEofEx = U_EXCEPTION( &uIOEx );
uException     uIOErrorEx = U_EXCEPTION( &uIOEx );
uException       uSocketErrorEx = U_EXCEPTION( &uIOErrorEx );
uException         uCreateSockEx = U_EXCEPTION( &uSocketErrorEx );
uException         uNotSockEx = U_EXCEPTION( &uSocketErrorEx );
uException         uNoBufsEx = U_EXCEPTION( &uSocketErrorEx );
uException         uBadSockAddressEx = U_EXCEPTION( &uSocketErrorEx );
uException           uConnFailedEx = U_EXCEPTION( &uBadSockAddressEx );
uException       uFileStreamEx = U_EXCEPTION( &uIOErrorEx );
uException         uOpenEx = U_EXCEPTION( &uFileStreamEx );
uException           uOpenIOFailedEx = U_EXCEPTION( &uOpenEx );
uException           uOpenNoSpaceEx = U_EXCEPTION( &uOpenEx );
uException           uBadPathEx = U_EXCEPTION( &uOpenEx );
uException           uNoPermsEx = U_EXCEPTION( &uOpenEx );
uException           uNoFilesEx = U_EXCEPTION( &uOpenEx );
uException           uBadParmEx = U_EXCEPTION( &uOpenEx );
uException         uReadWriteEx = U_EXCEPTION( &uFileStreamEx );
uException           uIOFailedEx = U_EXCEPTION( &uReadWriteEx );
uException           uNoSpaceEx = U_EXCEPTION( &uReadWriteEx );
uException           uBadFileEx = U_EXCEPTION( &uReadWriteEx );

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
