/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uTaskQueue.i -- Task queue routines.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:18:43 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Mar 28 14:07:53 1993
 * Update Count     : 15
 */

static inline void uAcquireTaskQueue( uTaskQueue *queue ) {

    /*
     * This function locks a task queue.
     */

    uAcquireLock( &(queue->mutex) );			    /* lock the mutex variable associated with the queue */
}

static inline void uReleaseTaskQueue( uTaskQueue *queue ) {

    /*
     * This function unlocks a task queue.
     */

    uReleaseLock( &(queue->mutex) );			    /* unlock the mutex variable associated with the queue */
}

static inline uTask uTaskQueueHead( uTaskQueue *queue ) {

    /*
     * This function returns the head task on the queue.
     */

    return queue->head;
}

static inline uTask uTaskQueueLink( uTask task ) {

    /*
     * This function returns the next task on the queue.
     */

    return task->link;
}

static inline int uTaskQueueEmpty( uTaskQueue *queue ) {

    /*
     * This function tests a task queue to see if it is empty.
     */

    return queue->head == NULL;
}

static inline int uTaskQueueLength( uTaskQueue *queue ) {

    /*
     * This function returns the length of a task queue.
     */

    return queue->len;
}

static inline void uInsertTask( uTaskQueue *queue, uTask task ) {

    /*
     * This function adds a task to the end of a task queue.
     */

    if ( uTaskQueueEmpty( queue ) ) {			/* if the task queue is empty... */
	queue->head = task;				/* update the head pointer... */
    } else {						/* otherwise... */
	queue->tail->link = task;			/* link the task to the task currently at the end of the list */
    }
    queue->tail = task;					/* update the tail pointer */
    task->link = NULL;					/* that task is the end of the list */
    queue->len += 1;					/* increment the length of the queue */
}

static inline uTask uDeleteTask( uTaskQueue *queue ) {

    /*
     * This function removes a task from the front of a task queue
     * and returns a reference to this task.
     */

    uTask task;

    task = queue->head;					/* get a reference to the task at the head of the queue */
    queue->head = task->link;				/* move the head pointer to the next task */
    queue->len -= 1;					/* decrement the length of the queue */

    return task;					/* return a reference to the task */
}
