/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-sparc.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:20:17 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Jan  4 18:56:17 1994
 * Update Count     : 113
 */

#define __U_STACK_GROWS__DOWN__ 1			/* stack grows down */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    bcopy( src, dst, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {
    void *addr;

    asm volatile ( "mov %%sp, %0" : "=r" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "mov %0, %%sp" : : "r" (addr) : "%sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {
    void *addr;

    asm volatile ( "mov %%fp, %0" : "=r" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "mov %0, %%fp" : : "r" (addr) : "%fp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {
    void *addr;

    asm volatile ( "mov %%i7, %0" : "=r" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
    asm volatile ( "mov %0, %%i7" : : "r" (addr) : "%i7" );
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {

    /*
     * We must setup a correct SPARC stack frame.
     *
     * Load the first 6 arguments from the stack into
     * the registers o0, o1, o2, o3, o4, and o5, as the sparc
     * calling convention dictates.
     */
    
    asm volatile ( "mov %0, %%l0" : : "r" (begin) : "%l0" );
    asm volatile ( "ld [%%sp+0x44], %%o0" : : : "%o0" );
    asm volatile ( "ld [%%sp+0x48], %%o1" : : : "%o1" );
    asm volatile ( "ld [%%sp+0x4c], %%o2" : : : "%o2" );
    asm volatile ( "ld [%%sp+0x50], %%o3" : : : "%o3" );
    asm volatile ( "ld [%%sp+0x54], %%o4" : : : "%o4" );
    asm volatile ( "call %l0, 0" );
    asm volatile ( "ld [%%sp+0x58], %%o5" : : : "%o5" );
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {

    /*
     * The frame pointer will be initialized to point to a WINDOWSIZE byte area
     * allocated at the end of the stack.
     *
     * The stack pointer will be initialized to point to a stack frame of a size
     * determined by the arglen passed to this routine.
     *
     * The size of the stack frame is MINFRAME + MAX(arglen - ARGPUSHSIZE, 0).
     * This allocates space for the window area, the structure return address,
     * the parameter register save area, and any extra parameters indicated
     * by arglen.
     * The parameters are then copied to (stack pointer + ARGPUSH).
     */

    stack->fp = stack->base - WINDOWSIZE;
    stack->sp = stack->fp - U_CEILING( MINFRAME + (len - ARGPUSHSIZE > 0 ? len - ARGPUSHSIZE : 0 ), sizeof( double ) );
    uCopy( buf, stack->sp + ARGPUSH, len );
} /* uMakeFrameUsingStack */

static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     *
     * In this case, it is handled by having the SPARC flush
     * all register windows.
     */

    asm volatile ( "ta 3" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     *
     * The registers will be restored by the "restore" instruction at
     * the end of the calling routine.
     *
     * The register save area they are restored from is determined
     * by the frame pointer, which has already been restored from
     * the stack descriptor.
     */

} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the saved floating point registers.
     */

} /* uPopFloatRegs */
