/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * md-rs6000.i -- Machine dependent code for the uKernel.
 * 
 * Author           : Peter Buhr
 * Created On       : Thu Mar 15 10:42:34 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Mar 30 19:51:16 1993
 * Update Count     : 36
 */

#define __U_STACK_GROWS__DOWN__ 1			/* stack grows down */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    memcpy( dst, src, len );
} /* uCopy */

static inline void *uReadStackPointer( void ) {
    void *addr;
    
    asm volatile ( "ai %0,1,0": "=r" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "ai 1,%0,0" : : "r" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {
    void *addr;

    asm volatile ( "mflr 0; ai %0,0,0" : "=r" (addr) : : "r0" );
    return( addr );
} /* uReadReturnAddress */

static inline void *uReadTOC( void ) {
    void *addr;

    asm volatile ( "ai %0,2,0" : "=r" (addr) );
    return( addr );
} /* uReadTOC */

static inline void uWriteReturnAddress( void *addr ) {
    asm volatile ( "ai 0,%0,0; mtlr 0;" : : "r" (addr) : "r0" );
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    asm volatile ( "l 0,0(%0)" :: "r" (begin) : "r0" );	/* load register 0 with address of C routine */
    asm volatile ( "mtlr 0" );				/* load link register with C routine */
    asm volatile ( "l 3,24(1)" );			/* load parameter registers with first 8 arguments */
    asm volatile ( "l 4,28(1)" );
    asm volatile ( "l 5,32(1)" );
    asm volatile ( "l 6,36(1)" );
    asm volatile ( "l 7,40(1)" );
    asm volatile ( "l 8,44(1)" );
    asm volatile ( "l 9,48(1)" );
    asm volatile ( "l 10,52(1)" );
    asm volatile ( "brl" );				/* branch to C routine */
    asm volatile ( "cror 15,15,15" );			/* nop for pipeline  */
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    struct BasicStack {
	struct LA {
	    char *BackChain;
	    int SavedCR;
	    void *SavedLR;
	    int Reserved[2];
	    void *SavedTOC;
	} LinkArea;
	int InputParms[0];
    } *startFrame = stack->base - ( sizeof(struct BasicStack) + max( 8 * sizeof(int), U_CEILING( len, 8 ) ) );
    stack->sp = startFrame;
    uCopy( buf, &startFrame->InputParms, len );

    startFrame->LinkArea.BackChain = uReadStackPointer();
    startFrame->LinkArea.SavedLR = uReadReturnAddress();
    startFrame->LinkArea.SavedTOC = uReadTOC();
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {
    asm volatile ( "stu 1,-84(1)" );			/* decrement stack 84 bytes */
    asm volatile ( "mfcr 0" );				/* store condition register into register 0 */
    asm volatile ( "st 0,0(1)" );			/* store condition register on stack */
    asm volatile ( "st 2,4(1)" );			/* store fixed register 2 (TOC) on stack */
    asm volatile ( "stm 13,8(1)" );			/* store fixed registers 13-31 on stack */
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {
    asm volatile ( "lm 13,8(1)" );			/* restore fixed registers 13-31 from stack */
    asm volatile ( "l  2,4(1)" );			/* restore fixed register 2 (TOC) from stack */
    asm volatile ( "l  0,0(1)" );			/* restore condition register from stack */
    asm volatile ( "mtcr 0" );				/* restore condition register from register 0 */
    asm volatile ( "ai 1,1,84" );			/* increment stack 84 bytes */
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {
    asm volatile ( "stu 1,-144(1)" );			/* decrement stack 144 bytes */
    asm volatile ( "stfd 14,0(1)" );			/* store floating registers 14-31 on stack */
    asm volatile ( "stfd 15,8(1)" );
    asm volatile ( "stfd 16,16(1)" );
    asm volatile ( "stfd 17,24(1)" );
    asm volatile ( "stfd 18,32(1)" );
    asm volatile ( "stfd 19,40(1)" );
    asm volatile ( "stfd 20,48(1)" );
    asm volatile ( "stfd 21,56(1)" );
    asm volatile ( "stfd 22,64(1)" );
    asm volatile ( "stfd 23,72(1)" );
    asm volatile ( "stfd 24,80(1)" );
    asm volatile ( "stfd 25,88(1)" );
    asm volatile ( "stfd 26,96(1)" );
    asm volatile ( "stfd 27,104(1)" );
    asm volatile ( "stfd 28,112(1)" );
    asm volatile ( "stfd 29,120(1)" );
    asm volatile ( "stfd 30,128(1)" );
    asm volatile ( "stfd 31,136(1)" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {
    asm volatile ( "lfd 14,0(1)" );			/* store floating registers 14-31 on stack */
    asm volatile ( "lfd 15,8(1)" );
    asm volatile ( "lfd 16,16(1)" );
    asm volatile ( "lfd 17,24(1)" );
    asm volatile ( "lfd 18,32(1)" );
    asm volatile ( "lfd 19,40(1)" );
    asm volatile ( "lfd 20,48(1)" );
    asm volatile ( "lfd 21,56(1)" );
    asm volatile ( "lfd 22,64(1)" );
    asm volatile ( "lfd 23,72(1)" );
    asm volatile ( "lfd 24,80(1)" );
    asm volatile ( "lfd 25,88(1)" );
    asm volatile ( "lfd 26,96(1)" );
    asm volatile ( "lfd 27,104(1)" );
    asm volatile ( "lfd 28,112(1)" );
    asm volatile ( "lfd 29,120(1)" );
    asm volatile ( "lfd 30,128(1)" );
    asm volatile ( "lfd 31,136(1)" );
    asm volatile ( "ai 1,1,144" );			/* increment stack 144 bytes */
} /* uPopFloatRegs */
