/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * md-i386.i -- Machine dependent uKernel code.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Mar 15 10:50:34 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Mar 30 19:50:34 1993
 * Update Count     : 45
 */

#define __U_STACK_GROWS__DOWN__ 1			/* stack grows down */

static inline void uCopy( void *src, void *dst, unsigned int len ) {
    asm volatile ( "movl %0, %%esi" : : "g" (src) : "si" );
    asm volatile ( "movl %0, %%edi" : : "g" (dst) : "di" );
    asm volatile ( "movl %0, %%ecx" : : "g" (len) : "cx" );
    asm volatile ( "cld" );
    asm volatile ( "rep" );
    asm volatile ( "smovb" );
} /* uCopy */

static inline void *uReadStackPointer( void ) {

    void *addr;

    asm volatile ( "movl %%esp, %0" : "=g" (addr) );
    return( addr );
} /* uReadStackPointer */

static inline void uWriteStackPointer( void *addr ) {
    asm volatile ( "movl %0, %%esp" : : "g" (addr) : "sp" );
} /* uWriteStackPointer */

static inline void *uReadFramePointer( void ) {

    void *addr;

    asm volatile ( "movl %%ebp, %0" : "=g" (addr) );
    return( addr );
} /* uReadFramePointer */

static inline void uWriteFramePointer( void *addr ) {
    asm volatile ( "movl %0, %%ebp" : : "g" (addr) : "bp" );
} /* uWriteFramePointer */

static inline void *uReadReturnAddress( void ) {

    void *addr;

    asm volatile ( "movl 4(%%ebp), %0" : "=r" (addr) );
    return( addr );
} /* uReadReturnAddress */

static inline void uWriteReturnAddress( void *addr ) {
} /* uWriteReturnAddress */

static inline void uCallUsingStack( void (*begin)() ) {
    (*begin)();
} /* uCallUsingStack */

static inline void uMakeFrameUsingStack( uStack stack, void *buf, int len ) {
    stack->fp = stack->base;
    stack->sp = stack->fp - U_CEILING( len, sizeof( double ) );
    uCopy( buf, stack->sp, len );
} /* uMakeFrameUsingStack */
    
static inline void uPushFixedRegs( void ) {

    /*
     * Save only those registers that the GCC machine
     * configuration files specify as being saved across
     * functions calls.
     */

    asm volatile ( "pushl %ebx" );
    asm volatile ( "pushl %esi" );
    asm volatile ( "pushl %edi" );
} /* uPushFixedRegs */

static inline void uPopFixedRegs( void ) {

    /*
     * Restore the saved registers.
     */

    asm volatile ( "popl %edi" );
    asm volatile ( "popl %esi" );
    asm volatile ( "popl %ebx" );
} /* uPopFixedRegs */

static inline void uPushFloatRegs( void ) {

    /*
     * Allocate room on the stack so that
     * the entire state of the floating point
     * system can be saved.
     */
    
    asm volatile ( "leal -108(%esp), %esp" );
    asm volatile ( "fsave (%esp)" );
} /* uPushFloatRegs */

static inline void uPopFloatRegs( void ) {

    /*
     * Restore the floating point system
     * and deallocate the room from the stack.
     */
    
    asm volatile ( "frstor (%esp)" );
    asm volatile ( "leal 108(%esp), %esp" );
} /* uPopFloatRegs */
