/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * cd-sgi-irix-mips.i -- vendor dependent locking mechanisms
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Tue May  8 13:32:43 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Wed Mar  3 17:39:26 1993
 * Update Count     : 96
 */

#include <stdarg.h>

/*
 * These includes cause uCalibrate to fail because
 * uSigAlrm cannot be inlined as it takes its own address.
 */

#ifndef __U_CALIBRATE__
#include "configure/vd-sgi.i"
#include "configure/os-irix.i"
#include "configure/md-mips.i"
#endif

/*
 * If hardware locks are available, define the following macro.
 */

/* #define __SGI_HARDWARE_LOCK__ */

#include <ulocks.h>

#ifdef __U_MULTI__

#define NUM_SGI_LOCKS 128				/* must be a power of 2 for subsequent hashing */

static ulock_t uSGILocks[NUM_SGI_LOCKS];
static char uArenaFileName[L_tmpnam];

#endif

static inline void uCreateLocks( void ) {

#ifdef __U_MULTI__

    int i;
    usptr_t *LockArena;
    
    tmpnam( uArenaFileName );				/* create a temporary file name for the locks */
    /* usconfig( CONF_INITSIZE, 8 * 1024 ); */		/* room for locks */
    usconfig( CONF_ARENATYPE, US_SHAREDONLY );		/* unlink after creation */
    usconfig( CONF_INITUSERS, 64 );			/* maximum number of sproc processes that can access the shared memory */
    LockArena = usinit( uArenaFileName );		/* initialize lock file */
    if ( LockArena == NULL ) {
	uAbort( "uCreateLocks(): could not allocate the lock arena:%s.\n", uArenaFileName );
    } /* if */
    
    for ( i = 0; i < NUM_SGI_LOCKS; i += 1 ) {
	uSGILocks[i] = usnewlock( LockArena );
	if ( uSGILocks[i] == NULL ) {
	    uAbort( "uCreateLocks(): could only allocate %d of the desired %d shared locks.\n", i, NUM_SGI_LOCKS );
	} /* if */ 
    } /* for */

#endif
    
} /* uCreateLocks */

static inline void uDestroyLocks( void ) {

#ifdef __U_MULTI__
    /*
     * Lock arena is unlinked after creation and is deleted automatically
     * when the last process using it terminates.
     */
#endif

} /* uDestroyLocks */

/*
 * The following function, uAcquireLock(), is derived from page C-7 of
 * "The Guide to Parallel Programming", 2nd. Edition, Sequent Computer Systems.
 */

static inline void uAcquireLock( uLock *mutex ) {

#ifdef __U_MULTI__

    /*
     * Use a simple hash function that uses the address of the software lock to compute the index
     * to a hardware lock.  This function assumes that the software lock is aligned on a 4-byte
     * boundary, and discards the lower 2 bites by shifting.
     */

    ulock_t lock = uSGILocks[ ( (int)mutex >> 2 ) & ( NUM_SGI_LOCKS - 1 ) ]; /* select a hardware lock */

    for( ;; ) {
	while ( *mutex == U_LOCKED ) {			/* wait for software lock to be available */
	    /* spin */
	} /* while */
#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	while ( *(int *)lock & 1 ) {			/* grab hardware lock */
	    /* spin */
	} /* while */
#else
	ussetlock( lock );				/* grab hardware lock */
#endif
      if ( *mutex == U_UNLOCKED ) break;		/* can race with others trying to get the lock */

#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	*(int *)lock = 0;				/* lost race, try again */
#else
	usunsetlock( lock );				/* lost race, try again */
#endif
    } /* for */

    *mutex = U_LOCKED;					/* no race, or won it, so grab the lock */
#ifdef __SGI_HARDWARE_LOCK__
    /* faster but non-portable test-and-set code */
    *(int *)lock = 0;					/* release the hardware lock */
#else
    usunsetlock( lock );				/* release the hardware lock */
#endif

#endif

} /* uAcquireLock */

static inline int uTryAcquireLock( uLock *mutex ) {

    /*
     * This makes one try to obtain a lock and
     * returns:
     *   1 => lock was obtained
     *   0 => lock was not obtained
     */

#ifdef __U_MULTI__

    /*
     * Use a simple hash function that uses the address of the software lock to compute the index
     * to a hardware lock.  This function assumes that the software lock is aligned on a 4-byte
     * boundary, and discards the lower 2 bits by shifting.
     */

    ulock_t lock = uSGILocks[ ( (int)mutex >> 2 ) & ( NUM_SGI_LOCKS - 1 ) ]; /* select a hardware lock */

#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	while ( *(int *)lock & 1 ) {			/* grab hardware lock */
	    /* spin */
	} /* while */
#else
	ussetlock( lock );				/* grab hardware lock */
#endif

    if ( *(mutex) == U_UNLOCKED ) {			/* can race with others trying to get the lock */
	*mutex = U_LOCKED;				/* no race, or won it, so grab the lock */
#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	*(int *)lock = 0;				/* release the hardware lock */
#else
	usunsetlock( lock );				/* release the hardware lock */
#endif
	return 1;
    } else {
#ifdef __SGI_HARDWARE_LOCK__
	/* faster but non-portable test-and-set code */
	*(int *)lock = 0;				/* release the hardware lock */
#else
	usunsetlock( lock );				/* release the hardware lock */
#endif
	return 0;
    } /* if */

#endif

} /* uTryAcquireLock */

static inline void uReleaseLock( uLock *mutex ) {

#ifdef __U_MULTI__
    
    /*
     * This function causes a task to release a lock.
     */

    *mutex = U_UNLOCKED;				/* release the lock */

#endif

} /* uReleaseLock */
