/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uDebug.i -- Debugging routines to print out uSystem control blocks
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Dec 18 19:29:24 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Jan 20 22:18:22 1992
 * Update Count     : 7
 */

inline void uPr_uSemaphore( char *f, uSemaphore *h ) {
    uPrintf( "%s.mutex:%d, %s.len:%d, %s.idle:%d, %s.head:%x, %s.tail:%x\n",
	    f, h->mutex, f, h->len, f, h->idle, f, h->head, f, h->tail );
} /* uPr_uSemaphore */

inline void uPr_uMsgD( char *f, struct uMsgD *m ) {
    uPrintf( "%s: ", f );
    uPr_uSemaphore( "snd", &(m->snd) );
    uPrintf( "%s: ", f );
    uPr_uSemaphore( "rcv", &(m->rcv) );
    uPrintf( "%s.to:%x, %s.from:%x, %s.sbuf:%x, %s.slen:%d, %s.rbuf:%x, %s.rlen:%d\n",
	    f, m->to, f, m->from, f, m->sbuf, f, m->slen, f, m->rbuf, f, m->rlen );
} /* uPr_uMsgD */

inline void uPr_uTaskD( char *f, uTask t ) {
    uPrintf( "%s.mutex:%d, %s.state:%d, %s.save:%d\n",
	    f, t->mutex, f, t->state, f, t->save );
    uPrintf( "%s: ", f );
    uPr_uSemaphore( "done", &(t->done) );
    uPrintf( "%s: ", f );
    uPr_uMsgD( "ipc", &(t->ipc) );
    uPrintf( "%s.name:\"%s\"\n", f, t->name );
    uPrintf( "%s.owner:%x, %s.restarter:%x, %s.resumer:%x, %s.link:%x\n",
	    f, t->owner, f, t->restarter, f, t->resumer, f, t->link );
} /* uPr_uTaskD */	
