/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * concc.c -- Compiles uSystem applications.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Mon Feb 12 14:56:40 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Sun Sep  4 20:11:24 1994
 * Update Count     : 133
 */

#include <stdio.h>
#include "uUnix.h"
#include "shell.h"
#include "vstrcat.h"

#define MAX 1024

char *home = HOME;

void main( int argc, char *argv[] ) {

    int i;
    char hi[MAX] = "";
    char lo[MAX] = "";
    char kernel[MAX] = "";
    char library[MAX] = "";
    char opt[MAX] = "";
    char syslib[MAX] = "";
    char com[MAX] = "";
    char arg[MAX] = "";
    char *dir;
    char *multi;
    char *debug;
    char *unixrc;
    char flags[MAX] = " -D__U_SYSTEM__";
    char heading[MAX] = "uSystem Version 4.4.3";
    char *compiler = "gcc";				/* default compiler is GNU C */

    int work_flag = 0;

    int multi_flag = 0;
    int debug_flag = 1;
    int unixrc_flag = 1;

    int heading_flag = 1;
    int link_flag = 1;
    int verbose_flag = 0;
    int clen;
    
    for ( i = 1; i < argc; i += 1 ) {
	if ( argv[i][0] == '-' ) {
	    if ( strcmp( argv[i], "-work" ) == 0 ) {
		work_flag = 1;
	    } else if ( strcmp( argv[i], "-multi" ) == 0 ) {
		multi_flag = 1;
	    } else if ( strcmp( argv[i], "-nomulti" ) == 0 ) {
		multi_flag = 0;
	    } else if ( strcmp( argv[i], "-debug" ) == 0 ) {
		debug_flag = 1;
	    } else if ( strcmp( argv[i], "-nodebug" ) == 0 ) {
		debug_flag = 0;
	    } else if ( strcmp( argv[i], "-unixrc" ) == 0 ) {
		unixrc_flag = 1;
	    } else if ( strcmp( argv[i], "-nounixrc" ) == 0 ) {
		unixrc_flag = 0;
	    } else if ( strcmp( argv[i], "-quiet" ) == 0 ) {
		heading_flag = 0;
	    } else if ( strcmp( argv[i], "-noquiet" ) == 0 ) {
		heading_flag = 1;
	    } else if ( strcmp( argv[i], "-compiler" ) == 0 ) { /* change compiler */
		i += 1;
		compiler = argv[i];
	    } else if ( strncmp( argv[i], "-l", 2 ) == 0 ) { /* if user specifies a library, */
		vstrcat( syslib, " ", argv[i], 0 );	/* load it after rest of user code. */
	    } else {
		vstrcat( arg, " ", argv[i], 0 );
		if ( strcmp( argv[i], "-c" ) == 0 || strcmp( argv[i], "-S" ) == 0 || strcmp( argv[i], "-E" ) == 0 ) {
		    link_flag = 0;
		} else if ( strcmp( argv[i], "-v" ) == 0 ) {
		    verbose_flag = 1;
		} /* if */
	    } /* if */
	} else {
	    vstrcat( arg, " ", argv[i], 0 );
	} /* if */
    } /* for */

    if ( work_flag ) {
	strcat( heading, " (work)" );
	dir = "/work";
    } else {
	strcat( heading, " (release)" );
	dir = "/release";
    } /* if */

#ifdef __ibm__
    strcat( syslib, " -lbsd" );
#endif

#if defined( __sun__ ) && ( __svr4__ )
    strcat( syslib, " -Xlinker -R/usr/ucblib -L/usr/ucblib -lucb -lelf -lsocket -lnsl" );
#endif

    if ( multi_flag ) {
	strcat( heading, " (multiple processor)" );
	multi = "-m";
	vstrcat( flags, " -D__U_MULTI__", 0 );
#ifdef __sequent__
	strcat( syslib, " -lpps -lseq" );
#endif
#ifdef __sgi__
	strcat( syslib, " -lmpc" );
#endif
#ifdef __encore__
	strcat( syslib, " -lpp" );
#endif
    } else {
	strcat( heading, " (single processor)" );
	multi = "";
    } /* if */

    if ( debug_flag ) {
	strcat( heading, " (debug)" );
	debug = "-d";
	vstrcat( flags, " -D__U_DEBUG__", 0 );
    } else {
	strcat( heading, " (no debug)" );
	debug = "";
    } /* if */

    if ( unixrc_flag ) {
	strcat( heading, " (unix i/o return codes)" );
	unixrc = "-u";
	vstrcat( flags, " -D__U_UNIXRC__", 0 );
    } else {
	strcat( heading, " (unix i/o exceptions)" );
	unixrc = "";
    } /* if */

    /*
     * Fill in the things that are vendor dependent.
     */
    
#ifdef __sgi__
    vstrcat( flags, " -D__EXTENSIONS__ -D_LANGUAGE_C", 0 );
#endif
#ifdef __ibm__
    vstrcat( flags, " -Xlinker -bnoobjreorder", 0 );	/* prevent linker from reordering code in memory */
#endif

    /*
     * Fill in the things that are compiler dependent.
     */
    
    clen = strlen( compiler );
    if ( clen >= 3 && (strcmp( &compiler[clen-3], "gcc" ) == 0 || strcmp( &compiler[clen-3], "g++" ) == 0) ) { /* gcc or g++ compiler? */
	if ( multi_flag ) {
	    vstrcat( opt, " -fshared-data", 0 );
	} /* if */
#if defined( __sequent__ ) || defined( __encore__ )
	vstrcat( opt, " -B", home, "/gnu/bin/", 0 ); /* force use of stock assembler if it exists */
#endif
	vstrcat( opt, " -fvolatile", 0 );
    } else if ( clen >= 2 && (strcmp( &compiler[clen-2], "cc" ) == 0 || strcmp( &compiler[clen-2], "CC" ) == 0) ) { /* cc or CC compiler? */
#ifdef __sequent__
	vstrcat( opt, " -i", 0 );
	if ( multi_flag ) {
	    vstrcat( opt, " -Y", 0 );
	} /* if */
#endif
    } /* if */

    /*
     * If performing the linking phase of compilation,
     * construct the full pathnames to the uSystem modules
     * which must be loaded.  Otherwise, null out all
     * system library modules.
     */
    
    if ( link_flag ) {
	vstrcat( lo, " ", home, "/kernel", dir, "/lib/uBegin.o", 0 );
	vstrcat( hi, " ", home, "/kernel", dir, "/lib/uEnd.o", 0 );
	vstrcat( kernel, " ", home, "/kernel", dir, "/lib/uSystem", multi, debug, ".a", 0 );
	vstrcat( library, " ", home, "/library", dir, "/lib/uLib", multi, debug, ".a", 0 );
	vstrcat( library, " ", home, "/library", dir, "/lib/uIO", multi, unixrc, ".a", 0 );
    } else {
	strcpy( syslib, "" );
    } /* if */

    if ( heading_flag ) {
	fprintf( stderr, "%s\n", heading );
    } /* if */

    /* have to scan the library twice, because the kernel might incur */
    /* some unresolved references to the stream objects in the library, */
    /* yet, we can't put the kernel in front of the library, because the */
    /* library uses many kernel functions. */
    
    vstrcat( com, compiler,
	    " -I", home, "/kernel", dir, "/inc",
	    " -I", home, "/library", dir, "/inc",
	    flags, lo, arg, opt, library, hi, kernel, library, syslib, 0 );
    
    if ( verbose_flag ) {
	fprintf( stderr, "concc\n %s\n", com );
    } /* if */
    
    exit( shell( com ) );

} /* main */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
