/*                               -*- Mode: C -*- 
 * uInter.h -- Provides the uSystem with interventions.
 * uSystem Version 4.4.3, Copyright (C) Hamish Macdonald 1991
 * Author          : Hamish Macdonald
 * Created On      : Fri Apr 12 09:34:04 1991
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Mon Jan 20 22:18:21 1992
 * Update Count    : 67
 */

#ifndef __U_INTERH__
#define __U_INTERH__

/*
 * The following macro is used to declare an
 * intervention routine type for an "extern"
 * intervention.
 */
#define uInterExtern( _uinname, _uintype ) \
    typedef _uintype __uf##_uinname

/*
 * The following macro defines an Intervention.
 * The two parameters are the intervention name and
 * the function pointer type for the intervention function.
 */
#define uIntervention( _uinname, _uintype )  \
    uInterName _uinname = #_uinname;         \
    uInterExtern( _uinname, _uintype )

/*
 * The following macro sets up an Intervention block.
 * The two parameters are the intervention name and the
 * routine to install.
 * The type of the routine passed is checked against that
 * provided when the intervention was declared.
 *
 * The routine provided is in force for the given intervention
 * during execution within the following block, terminated by the
 * uEndInter macro.
 */
#define uInter( _uinname, _uinfp )              \
    {                                           \
        extern uInterName _uinname;             \
        uStackBlockD _uinterblock;              \
	__uf##_uinname __fp = _uinfp;           \
                                                \
        _uinterblock.type = uIsInterBlock;      \
        _uinterblock.u.uIPart.name = &_uinname; \
        _uinterblock.u.uIPart.fp = __fp;        \
        uSetupInter( &_uinterblock );
						   
/*
 * The uEndInter macro signals the end of an intervention block.
 */
#define uEndInter                      \
        uDeleteInter( &_uinterblock ); \
    }

/*
 * The uInterCall macro is used to signal an Intervention in the current coroutine.
 * Its parameter is the name of the intervention.  The parameters for
 * the intervention should be placed in parentheses after the call to
 * uInterCall.  They are type checked against the parameters for the function
 * pointer provided when the given intervention was declared.  The return type for
 * the given intervention is checked as well.
 *
 * e.g.
 *   result = uInterCall( uZeroDivide )( arg1, arg2 );
 */
#define uInterCall( _uinname )                   \
    (*((__uf##_uinname)uInterFunc( &_uinname )))

extern void *uInterFunc( uInterName * );
extern void uSetupInter( uStackBlock );
extern void uDeleteInter( uStackBlock );

/*
 * The following definitions are for asynchronous interventions.
 * Asynchronous Interventions have a restricted routine type.
 * All Asynchronous Intervention routines must take a void* and an
 * integer as parameters, and they have a void return type.
 *
 * An asynchronous intervention is signalled in another
 * task using the uAsyncInterCall routine (macro?).
 * Its parameters are the task to signal, the message and
 * the length.
 */

typedef void (*uAsyncInterRoutine)( void*, int );

#define uAsyncIntervention( name ) uIntervention( name, uAsyncInterRoutine )
#define uAsyncInterExtern( name ) uInterExtern( name, uAsyncInterRoutine )

#define uAsyncInterCall( _task, _name, _ptr, _len ) \
    uAsyncInterCallFunc( _task, &_name, _ptr, _len )

extern void uAsyncInterCallFunc( uTask, uInterName*, void*, int );

extern void uAsyncInterEnable( void );
extern void uAsyncInterDisable( void );

#if defined(__U_KERNEL__)
extern void uAsyncInterDeliver( void );
#endif

#endif /* __U_INTERH__ */
