
#if defined( SVR3 ) || defined( SVR4 ) || defined( hpux ) || defined( __svr4__ ) /* System V */

#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>

inline void InitTime( void ) {
} /* InitTime */

inline int Time( void ) {
    struct tms usage;

    times( &usage );
    return usage.tms_utime * ( 1000000 / HZ ) +
	   usage.tms_stime * ( 1000000 / HZ );
} /* Time */

#else							/* BSD */

#include <sys/time.h>
#ifndef __U_CALIBRATE__
#include <sys/resource.h>
#endif

inline void InitTime( void ) {
} /* InitTime */

extern int getrusage( int, struct rusage * );

inline int Time( void ) {
    struct rusage usage;

    getrusage( RUSAGE_SELF, &usage );
    return usage.ru_utime.tv_sec * 1000000 + usage.ru_utime.tv_usec +
	   usage.ru_stime.tv_sec * 1000000 + usage.ru_stime.tv_usec;
} /* Time */

#endif
