#include <uSystem.h>

long random( void );

#define QueueSize 100
#define ElemType uTask
#include "TalkListen.c"
struct medium DeathRow;

uSemaphore Res = U_SEMAPHORE( 1 );
uSemaphore AsLock = U_SEMAPHORE( 1 );
int AsCnt = 0;
uSemaphore BsLock = U_SEMAPHORE( 1 );
int BsCnt = 0;

void A( void ) {
    uP( &AsLock );
    AsCnt += 1;
    if ( AsCnt == 1 ) {					/* 1st A ? */
        uP( &Res );					/* wait for resource to become free */
    } /* if */
    uV( &AsLock );

    uPrintf( "A:%x, concurrent As:%2d, Bs:%2d\n", uThisTask( ), AsCnt, BsCnt );
    uDelay( 3 );

    uP( &AsLock );
    AsCnt -= 1;
    if ( AsCnt == 0 ) {					/* all As finished ? */
        uV( &Res );					/* open resource */
    } /* if */
    uV( &AsLock );
    talk( &DeathRow, uThisTask() );
    uDie( NULL, 0 );
} /* A */

void B( void ) {
    uP( &BsLock );
    BsCnt += 1;
    if ( BsCnt == 1 ) {					/* 1st B ? */
        uP( &Res );					/* wait for resource to become free */
    } /* if */
    uV( &BsLock );
    
    uPrintf( "B:%x, concurrent Bs:%2d, As:%2d\n", uThisTask( ), BsCnt, AsCnt );
    uDelay( 3 );
    
    uP( &BsLock );
    BsCnt -= 1;
    if ( BsCnt == 0 ) {					/* all Bs finished ? */
        uV( &Res );					/* open resource */
    } /* if */
    uV( &BsLock );
    talk( &DeathRow, uThisTask() );
    uDie( NULL, 0 );
} /* B */

void Euthanasia( int NoOfProcesses ) {
    int i;
    uTask temp;
    
    for ( i = 1; i <= NoOfProcesses; i += 1 ) {
	temp = listen( &DeathRow );
	uAbsorb( temp, NULL, 0 );
    } /* for */
    uDie( NULL, 0 );
} /* Euthanasia */

#define MaxProcess 200

void uMain( ) {
    uTask euthanasia;
    int i;
    
    initmedium( &DeathRow );
    euthanasia = uEmit( Euthanasia, MaxProcess );
    for ( i = 0; i < MaxProcess; i += 1 ) {
	if ( random(  ) % 10 < 5 ) {			/* 50% of tasks are As */
	    uEmit( A );					/* start A */
	} else {
	    uEmit( B );					/* start B */
	} /* if */
	uDelay( 4 );
    } /* for */
    uAbsorb( euthanasia, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* uMain */
