/* Copyright (c) 1989  P. A. Buhr */

/*
  N-Process mutual exclusion
  
  Method: Each process is given a fixed priority. A process waits until
    it is the highest priority process waiting to enter the critical
    section. Then it waits until all lower priority processes either
    retract intent or finish executing the critical section.
  Work?: NO
  Problem: Bounded waiting problem
  */

#include <uSystem.h>

#define WantIn 1
#define DontWantIn 0
#define NoOfTasks 5

void NProcess(int intent[], int priority) {
    int i, j;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* execute critical section */

        /* entry protocol */
    
        /* step 1, wait until you are the highest priority process */
    
        do {
            intent[priority] = WantIn;			/* declare intent */
    
            /* check if process with higher priority wants in */
    
            for (j = priority + 1; j < NoOfTasks; j += 1) {
                if (intent[j] == WantIn) {
                    intent[priority] = DontWantIn;	/* retract intent */
                    while(intent[j] == WantIn) {}	/* busy wait */
                    break;				/* start all over again */
                } /* if */
            } /* for */
        } while (intent[priority] == DontWantIn);
    
        /* step 2, wait for any process that has lower priority */
    
        for (j = 0; j < priority; j += 1) {
            while(intent[j] == WantIn) {}		/* busy wait */
        } /* for */
    
        /* critical section */
        
        CriticalSection();
    
        /* exit protocol */
    
        intent[priority] = DontWantIn;			/* declare not interested */
    } /* for */

    uDie(NULL, 0);
} /* NProcess */

void uMain() {
    uTask processes[NoOfTasks];
    int Intent[NoOfTasks];
    int i;
 
    uSetTimeSlice(10);
    
    for (i = 0; i < NoOfTasks; i += 1) {
        Intent[i] = DontWantIn;				/* initialize intent */
    } /* for */

    for (i = 0; i < NoOfTasks; i += 1) {
        processes[i] = uEmit(NProcess, Intent, i);	/* start process */
    } /* for */
 
    for (i = 0; i < NoOfTasks; i += 1) {
        uAbsorb(processes[i], NULL, 0);			/* wait for completion of process */
    } /* for */
    uPrintf("successful execution\n");
} /* uMain */
