#include <uSystem.h>

int d = 1;						/* shared by reader and writer */
int status;

void Reader( void ) {
    for ( ;; ) {
        status = uScanf( "%d", &d );			/* read number from stdin */
      if ( status == EOF ) break;
    } /* for */
} /* Reader */

void Writer( void ) {
    int i;

    for ( i = 0;; i += 1 ) {
      if ( status == EOF ) break;
	if ( i % 100 == 0 ) {				/* don't print to much */
	    uPrintf( "%d", d );				/* write number to stdout */
	    uFflush( uStdout );				/* don't buffer output */
	} /* if */
	uDelay( 1 );
    } /* for */
    uPrintf( "\n" );
} /* Writer */

void uMain() {
    uTask reader = uEmit( Reader );
    uTask writer = uEmit( Writer );
    uAbsorb( reader, NULL, 0 );
    uAbsorb( writer, NULL, 0 );
} /* uMain */

/* Local Variables: */
/* compile-command: "concc NBStream.c" */
/* End: */
