#include <uSystem.h>

/*
 * Merge 2 files into a third file (assuming a high-key merge is not possible).
 * End of file is detected using exceptions.
 */

void uMain( int argc, char *argv[] ) {
    uStream in1, in2, out;
    int ch;
    uOpenExMsg *msg;
    uEofExMsg *eof;
    int len;
    char line1[256] = "", line2[256] = "";

    switch ( argc ) {
      case 3:
      case 4:
        uExcept {
            in1 = uFopen( argv[1], "r" );		/* open input file */
            in2 = uFopen( argv[2], "r" );		/* open input file */
        } uHandlers {
            uWhen( NULL, &uOpenEx, &msg ) {
                uAbort( "%sInput open error for file '%s'.\n", msg->base.msg, msg->path );
            } /* uWhen */
        } uEndExcept;
        if ( argc == 3 ) {				/* default output file */
            out = uStdout;
        } else {
            uExcept {
                out = uFopen( argv[3], "w" );		/* open output file */
            } uHandlers {
                uWhen( NULL, &uOpenEx, &msg ) {
                    uAbort( "%sOutput open error for file '%s'.\n", msg->base.msg, msg->path );
                } /* uWhen */
            } uEndExcept;
        } /* if */
        break;
      case 1:
      case 2:
      default:
        uAbort( "Usage: %s infile1 infile2 [outfile]\n", argv[0] );
    } /* switch */

    uExcept {						/* merge input files */
        uFgets( line1, sizeof(line1), in1 );		/* try to get a line from each file */
        uFgets( line2, sizeof(line2), in2 );

        for ( ;; ) {					/* output the smaller and attempt to replace it. */
            if ( strcmp( line1, line2 ) < 0 ) {
                uFprintf( out, "%s", line1 );
                uFgets( line1, sizeof(line1), in1 );
            } else {
                uFprintf( out, "%s", line2 );
                uFgets( line2, sizeof(line2), in2 );
            } /* if */
        } /* for */
    } uHandlers {
        uWhen ( in1, &uEofEx, &eof ) {			/* dump out the other non-empty file */
            uExcept {
                for ( ;; ) {
                    uFprintf( out, "%s", line2 );
                    uFgets( line2, sizeof(line2), in2 );
                } /* for */
            } uHandlers {
                uWhen ( in2, &uEofEx, &eof );
            } uEndExcept;
        } /* uWhen */
        uWhen ( in2, &uEofEx, &eof ) {
            uExcept {
                for ( ;; ) {
                    uFprintf( out, "%s", line1 );
                    uFgets( line1, sizeof(line1), in1 );
                } /* for */
            } uHandlers {
                uWhen ( in1, &uEofEx, &eof );
            } uEndExcept;
        } /* uWhen */
    } uEndExcept;

    uFclose( in1 ); uFclose( in2 );			/* close input files */
    uFclose( out );					/* close output file */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -nounixrc File.c" */
/* End: */
