/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.4.3, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1993
 * 
 * ClientINET.c -- Client for INET socket test
 * 
 * Author           : Peter A. Buhr
 * Created On       : Tue Mar  2 10:55:47 1993
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Jan  4 18:30:33 1994
 * Update Count     : 11
 */

#include <uSystem.h>
#include <uFile.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>

void reader( uFile sd ) {
    int c;

    for ( ;; ) {
        uRead( sd, &c, sizeof( c ) );
      if ( c == EOF ) break;
        uPutc( c, uStdout );
    } /* for */
} /* reader */

void writer( uFile sd ) {
    uEofExMsg *eof;
    int c;

    uExcept {
        for ( ;; ) {
            c = uGetc( uStdin );
            uWrite( sd, &c, sizeof( c ) );
        } /* for */
    } uHandlers {
        uWhen( uStdin, &uEofEx, &eof ) {
            c = EOF;
            uWrite( sd, &c, sizeof( c ) );		/* write EOF to socket */
        }
    } uEndExcept;
} /* writer */

void uMain( int argc, char *argv[] ) {
    uFile sd;
    struct sockaddr_in sockinfo;
    struct hostent *hp;
    uTask wr;
    uTask rd;
    
    switch ( argc ) {
      case 3:
        break;
      default:
        uAbort( "usage: %s port-number host-name\n", argv[0] );
    } /* switch */

    sd = uSocket( AF_INET, SOCK_STREAM, 0 );		/* create a socket */

    hp = gethostbyname( argv[2] );			/* get internet address from internet name */
    if ( hp == NULL ) {
	uAbort( "internet name lookup failure:%s\n", argv[2] );
    } /* if */

    sockinfo.sin_family = AF_INET;
    bcopy( hp->h_addr, &(sockinfo.sin_addr), hp->h_length );
    sockinfo.sin_port = htons( atoi( argv[1] ) );
    uConnect( sd, &sockinfo, sizeof(sockinfo) );	/* connection to destination socket */

    wr = uEmit( writer, sd );				/* emit a worker to read from file and write to socket */
    rd = uEmit( reader, sd );				/* emit a worker to read from socket and write to file */
    uAbsorb( wr, NULL, 0 );				/* absorb worker */
    uAbsorb( rd, NULL, 0 );				/* absorb worker */
    
    uClose( sd );					/* close socket */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -work -nounixrc -O -o Client ClientINET.c" */
/* End: */
