/* Producer-consumer problem, full coroutines */

#include <uSystem.h>

long random( void );

void Producer( uCoroutine *Cons, uCoroutine creator, int NoOfItems ) {
    int i, product;
    
    uSuspend( NULL, 0, NULL, 0 );			/* wait for consumer to be created */
    uPrintf( "Producer will produce %d items for the consumer\n", NoOfItems );
    for ( i = 1; i <= NoOfItems; i += 1 ) {
        product = random() % 100 + 1;
        uPrintf( "Producer: %2d\n", product );
        uResume( *Cons, NULL, 0, &product, sizeof(product) );
    } /* for */
    product = -1;					/* terminal value */
    uResume( *Cons, NULL, 0, &product, sizeof(product) ); /* terminate consumer */
    uResumeDie( creator, NULL, 0 );			/* restart creator */
} /* Producer */

void Consumer( uCoroutine *Prod ) {
    int product;
    
    uSuspend( &product, sizeof(product), NULL, 0 );	/* wait for producer */
    while ( product != -1 ) {
	uPrintf( "Consumer: %2d\n", product );
	uResume( *Prod, &product, sizeof(product), NULL, 0 );
    } /* while */
} /* Consumer */

void uMain() {
    uCoroutine prod, cons;

    prod = uCocall( NULL, 0, Producer, &cons, uThisCoroutine(), 10 ); /* create producer */
    cons = uCocall( NULL, 0, Consumer, &prod );		/* create consumer */
    
    uResume( prod, NULL, 0, NULL, 0 );			/* start producer */

    uPrintf( "successful completion\n" );
} /* uMain */
