/*
  Producer driven producer-consumer problem, semi-coroutines.
  */

#include <uSystem.h>

long random();

void Consumer() {
    int NoOfItems, i, product, flag;

    flag = 1;
    NoOfItems = random() % 10 + 1;			/* generate a random number of items to be consumed */
    printf("Consumer will consume %d items form the producer\n", NoOfItems);
    for (i = 1; i <= NoOfItems; i += 1) {
	uSuspend(&product, sizeof(product), &flag, sizeof(flag));
	printf("Consumer: %d\n", product);
    } /* for */
    flag = 0;
    uSuspendDie(&flag, sizeof(flag));			/* signal completion */
} /* Consumer */

void Producer() {
    uCoroutine cons;
    int product, flag;
    
    cons = uCocall(&flag, sizeof(flag), Consumer);
    while (flag) {
	product = random() % 100 + 1;
	printf("Producer: %d\n", product);
	uResume(cons, &flag, sizeof(flag), &product, sizeof(product));
    } /* while */
} /* Producer */

void uMain() {
    Producer();						/* someone must be the cocaller */
    printf("successful completion\n");
} /* uMain */
