#include <uSystem.h>
#include <string.h>

/*
  This grammar parses the language ab+c*d, where the number of b's must
  be exactly one greater than the number of c's. The coroutine has 3 states:
  
  CONT  => continue parsing
  ERROR => error in string
  MATCH => string occurs in language
  
  */

#include <stdio.h>

#define CONT	0
#define ERROR	1
#define MATCH	2

void grammar() {
    char ch;
    int ok, bcnt, ccnt;
    
    ok = CONT;
    uSuspend( &ch, sizeof(ch), NULL, 0 );
    if ( ch == 'a' ) {
	bcnt = 0;
	for ( ;; ) {
	    uSuspend( &ch, sizeof(ch), &ok, sizeof(ok) );
          if ( ch != 'b' ) break;
	    bcnt += 1;
	} /* for */
	ccnt = 0;
	for ( ;; ) {
          if ( ch != 'c' ) break;
	    ccnt += 1;
          if ( bcnt < ccnt + 1 ) break;
	    uSuspend( &ch, sizeof(ch), &ok, sizeof(ok) );
	} /* for */
	ok = ch == 'd' && bcnt == ccnt + 1 ? MATCH : ERROR;
    } else {
	ok = ERROR;
    } /*if */
    uSuspendDie( &ok, sizeof(ok) );
} /* grammar */

void uMain( int argc, char *argv[] ) {
    uStream input;
    uCoroutine gram;
    int status, i, state;
    char string[256];
    
    if ( argc == 1 ) {
	input = uStdin;
    } else if (argc == 2 ) {
	input = uFopen( argv[1], "r" );
	if ( input == NULL ) {
	    uAbort( "Error : file \"%s,\" does not exist\n", argv[1] );
	} /* if */
    } else {
	uAbort( "Usage:%s input-file\n", argv[0] );
    } /* if */
    
    for ( ;; ) {
	status = uFscanf( input, "%s", string );
      if (status == EOF) break;
	uPrintf( "string:\"%s\"\n", string );
	gram = uCocall( NULL, 0, grammar );
	for ( i = 0; i < strlen( string ) + 1; i += 1 ) { /* pass the string termination character, if necessary */
	    uResume( gram, &state, sizeof(state), &string[i], sizeof(string[i]) );
	  if ( state == ERROR ) {
		uPrintf( "string is NOT in language\n" );
		break;
	    } /* exit */
	  if ( state == MATCH ) {
		uPrintf( "string is in language\n" );
		break;
	    } /* exit */
	} /* for */
    } /* for */
} /* uMain */
