/* Copyright (c) 1989  P. A. Buhr */

/*
  This sort coroutine inputs positive integer values to be sorted and
  sorts then using the binary sort method. When the value -1 is received
  the sort coroutine changes mode and begins returning the sorted values.
  */

#include <uSystem.h>

void BinarySort() {
    uCoroutine less, greater;
    int pivot, n;
    
    /* input and sort values */

    uSuspend( &pivot, sizeof(pivot), NULL, 0 );
    if ( pivot == -1 ) {				/* no data values */
	uSuspend( NULL, 0, NULL, 0 );			/* acknowledge end of input */
	n = -1;
	uSuspendDie( &n, sizeof(n) );			/* terminate output */
    } /* if */
    
    less = uCocall( NULL, 0, BinarySort );		/* create siblings */
    greater = uCocall( NULL, 0, BinarySort );
    
    for ( ;; ) {
	uSuspend( &n, sizeof(n), NULL, 0 );		/* get more input */
      if ( n == -1 ) break;
	if ( n <= pivot ) {
	    uResume( less, NULL, 0, &n, sizeof(n) );
	} else {
	    uResume( greater, NULL, 0, &n, sizeof(n) );
	} /* if */
    } /* for */

    n = -1;
    uResume( less, NULL, 0, &n, sizeof(n) );		/* terminate input */
    uResume( greater, NULL, 0, &n, sizeof(n) );		/* terminate input */
    uSuspend( NULL, 0, NULL, 0 );			/* acknowledge end of input */
    
    /* return sorted values */
    
    for ( ;; ) {
	uResume( less, &n, sizeof(n), NULL, 0 );	/* retrieve the smaller values */
      if ( n == -1 ) break;				/* no more smaller values ? */
	uSuspend( NULL, 0, &n, sizeof(n) );		/* return smaller values */
    } /* for */

    uSuspend( NULL, 0, &pivot, sizeof(pivot) );		/* don't forget to return the pivot */
    
    for ( ;; ) {
	uResume( greater, &n, sizeof(n), NULL, 0 );	/* retrieve the larger values */
      if ( n == -1 ) break;				/* no more larger values ? */
	uSuspend( NULL, 0, &n, sizeof(n) );		/* return larger values */
    } /* for */

    n = -1;
    uSuspendDie( &n, sizeof(n) );			/* terminate output */
} /* BinarySort */

void uMain() {
    uCoroutine q;
    int value;
    
    q = uCocall(NULL, 0, BinarySort );
    
    /* sort values */
    
    value = 101;
    uResume(q, NULL, 0, &value, sizeof(value) );
    value =  75;
    uResume(q, NULL, 0, &value, sizeof(value));
    value =   2;
    uResume(q, NULL, 0, &value, sizeof(value) );
    value =  50;
    uResume(q, NULL, 0, &value, sizeof(value) );
    value =  10;
    uResume(q, NULL, 0, &value, sizeof(value) );
    value =   2;
    uResume(q, NULL, 0, &value, sizeof(value) );
    value =  -1;
    uResume(q, NULL, 0, &value, sizeof(value) );

    /* retrieve sorted values */
    
    for ( ;; ) {
	uResume(q, &value, sizeof(value), NULL, 0 );	/* retrieve values */
      if ( value == -1) break;				/* no more values ? */
	printf( "%d\n", value );			/* print values */
    } /* for */
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -quiet -work Binary.c" */
/* End: */
