//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// main.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 13:25:36 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jul 22 22:15:00 1998
// Update Count     : 40
// 

#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>


// Declare a variable in shared memory to obtain a return code from the user
// program.  Unless modified, the return code is zero.

int uRetCode = 0;


// The main routine that gets the first task started with the OS supplied
// arguments, waits for its completion, and returns the result code to the OS.

int main( int argc, char *argv[] ) {
    // The user task must be created on the heap (shared memory) because the
    // stack (where execution is currently taking place) is duplicated during a
    // fork (private memory).

    uMain *uUserMain = new uMain( *uKernelModule::uUserCluster, uMainStackSize(), argc, argv, uRetCode );
    delete uUserMain;					// wait for user task to terminate

    // Return the program return code to the operating system.

    return uRetCode;
} // main


// Local Variables: //
// compile-command: "dmake" //
// End: //
