//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Nikita Borisov 1995
// 
// u++.cc -- 
// 
// Author           : Nikita Borisov
// Created On       : Tue Apr 28 15:26:27 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Mar 19 17:54:38 1999
// Update Count     : 566
// 


#include <iostream.h>
#include <fstream.h>					// ifstream
#include <stdio.h>					// perror
#include <unistd.h>					// execvp
#include <stdlib.h>                                     // getenv
#include <string>					// STL version


//#define __U_DEBUG_H__


int main( int argc, char *argv[] ) {
    string installlibdir( INSTALLLIBDIR );
    string installincdir( INSTALLINCDIR );

    string tvendor( TVENDOR );
    string tos( TOS );
    string tcpu( TCPU );

    string Multi( MULTI );
    string Trace( TRACE );

    string heading;
    string mods;
    string arg;
    string Bprefix;
    string path;

    string compiler_name( "g++" );
    string compiler_path( compiler_name );
    string cpp_name;

    bool link = true;
    bool verbose = false;
    bool quiet = false;
    bool multi = false;
    bool debug = true;
    bool trace = false;
    bool bflag = false;
    bool Vflag = false;
    bool upp_flag = false;
    bool cpp_flag = false;
    bool Yield = false;					// name "yield" already taken
    bool verify = false;
    bool nonflags = false;
    bool profile = false;
    bool kernel_profile = false;

    const char *args[argc + 100];			// u++ command line values, plus some space for additional flags
    int iargs = 4;					// 0 => command name, 1 => -D__U_START__, 2 => uPrivate.o, 3 => uBegin.o
    int nargs = iargs;
    
    const char *libs[argc + 20];			// non-user libraries must come separately, plus some added libraries and flags
    int nlibs = 0;

    string tmppath;
    string mvdpath;
    string motifincdir;
    string motiflibdir;
    string uxincdir;
    string uxlibdir;
    string mvdincdir;
    string mvdlibdir;
    string libgdbincdir;
    string libgdblibdir;
    string *executable = 0;
    string configFilename;
    string token;
    ifstream *configFile;


    args[1] = "-D__U_CPP_FLAGS__";			// indicate start of user cpp flags

    // process all the arguments

    for ( int i = 1; i < argc; i += 1 ) {
#ifdef __U_DEBUG_H__
	cerr << "argv[" << i << "]:\"" << argv[i] << "\"" << endl;
#endif __U_DEBUG_H__
	arg = argv[i];
#ifdef __U_DEBUG_H__
	cerr << "arg:\"" << arg << "\"" << endl;
#endif __U_DEBUG_H__
	if ( arg.substr(0,1) == "-" ) {
	    if ( arg == "-Xlinker" ) {			// GNU linker pass through
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
	    } else if ( arg == "-U++" ) {
		upp_flag = true;			// strip the -U++ flag
		link = false;
	    } else if ( arg == "-multi" ) {
		multi = true;				// strip the multi flag
	    } else if ( arg == "-nomulti" ) {
		multi = false;				// strip the nomulti flag
	    } else if ( arg == "-debug" ) {
		debug = true;				// strip the debug flag
	    } else if ( arg == "-nodebug" ) {
		debug = false;				// strip the nodebug flag
	    } else if ( arg == "-trace" ) {
		trace = true;				// strip the trace flag
	    } else if ( arg == "-notrace" ) {
		trace = false;				// strip the notrace flag
	    } else if ( arg == "-quiet" ) {
		quiet = true;				// strip the quiet flag
	    } else if ( arg == "-noquiet" ) {
		quiet = false;				// strip the noquiet flag
	    } else if ( arg == "-yield" ) {
		Yield = true;				// strip the yield flag
	    } else if ( arg == "-noyield" ) {
		Yield = false;				// strip the noyield flag
	    } else if ( arg == "-verify" ) {
		verify = true;				// strip the verify flag
	    } else if ( arg == "-noverify" ) {
		verify = false;				// strip the noverify flag
	    } else if ( arg == "-profile" ) {
                profile = true;                         // strip the profile flag
            } else if ( arg == "-noprofile" ) {
                profile = false;                        // strip the noprofile flag
	    } else if ( arg == "-kernelprofile" ) {
                kernel_profile = true;			// strip the profile flag
            } else if ( arg == "-nokernelprofile" ) {
                kernel_profile = false;			// strip the noprofile flag
	    } else if ( arg == "-v" ) {
		verbose = true;				// verbosity required
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
	    } else if ( arg.substr(0,2) == "-B" ) {
		Bprefix = arg.substr(2);		// strip the -B flag
		args[nargs] = ( *new string( string("-D__U_GCC_BPREFIX__=") + Bprefix ) ).c_str();
		nargs += 1;
	    } else if ( arg == "-b" ) {
		bflag = true;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		args[nargs] = ( *new string( string("-D__U_GCC_MACHINE__=") + argv[i] ) ).c_str();
		nargs += 1;
	    } else if ( arg == "-V" ) {
		Vflag = true;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		args[nargs] = ( *new string( string("-D__U_GCC_VERSION__=") + argv[i] ) ).c_str();
		nargs += 1;
	    } else if ( arg == "-c" || arg == "-S" || arg == "-E" || arg == "-M" || arg == "-F" ) {
		link = false;                           // no linkage required
		args[nargs] = argv[i];			// pass the argument along
		nargs += 1;
		if ( arg == "-E" || arg == "-M" ) {
		    cpp_flag = true;
		} // if
	    } else if ( arg == "-compiler" ) {
		// use the user specified compiler
		compiler_path = argv[i + 1];
		// find actual name of the compiler independent of the path to it
		i += 1;
		int p = string(argv[i]).find_last_of( '/' ); // scan r -> l for first '/'
		if ( p == -1 ) {
		    compiler_name = argv[i];
		} else {
		    compiler_name = *new string( string( argv[i] ).substr( p + 1 ) );
		} // if
	    } else if ( arg == "-cpp" ) {
		// use the user specified preprocessor
		i += 1;
		cpp_name = argv[i];
	    } else if ( arg.substr(1,1) == "l" ) {
		// if the user specifies a library, load it after user code
		libs[nlibs] = argv[i];
		nlibs += 1;
	    } else if ( arg == "-o" ) {			// TEMPORARY: should be a way to find this name in the application
		args[nargs] = argv[i];
		nargs += 1;
		i += 1;
		args[nargs] = argv[i];
		nargs += 1;
		executable = new string( argv[i] );
	    } else {
		// concatenate any other arguments
		args[nargs] = argv[i];
		nargs += 1;
	    } // if
	} else {
	    // concatenate any other arguments
	    nonflags = true;
	    args[nargs] = argv[i];
	    nargs += 1;
	} // if
    } // for

    // if the user did not specify a cpp, use the specified compiler with the -E option

    if ( cpp_name.length() == 0 ) {
	cpp_name = compiler_path;
    } // if

    if ( trace && ! debug ) {
	cerr << argv[0] << ": Warning -trace flag implies -debug flag\n";
	debug = true;
    } // if

    string d;
    if ( debug ) {
	d = "-d";
    } // if

    string m;
    if ( multi ) {
	if ( Multi == "FALSE" ) {			// system support multiprocessor ?
	    cerr << argv[0] << ": Warning -multi flag not support on this system\n";
	} else {
	    m = "-m";
	} // if
    } // if

    string t;
    if ( trace ) {
	if ( Trace == "FALSE" ) {			// system support tracing ?
	    cerr << argv[0] << ": Warning -trace flag not support on this system\n";
	} else {
	    t = "-t";
	} // if
    } // if

    // profiling
    
    if ( kernel_profile && ! profile ) {
	cerr << argv[0] << ": Warning -kernelprofile flag implies -profile flag\n";
	profile = true;
    } // if

    if ( profile && link ) {
	char *mvdpathname = getenv( "MVDPATH" );	// get MVDPATH environment variable
	
	if ( mvdpathname == (char *)0 ) {
	    cerr << argv[0] << ": Warning environment variable MVDPATH not set.  Profiling disabled.\n";
	    profile = false;
	} else {
	    mvdpath = mvdpathname;			// make string
	    if ( mvdpathname[strlen( mvdpathname ) - 1] != '/' ) { // trailing slash ?
		mvdpath += "/";				// add slash
	    } // if

	    // Define lib and include directories 
	    uxincdir = mvdpath + "X11R6/include";
	    uxlibdir = mvdpath + "X11R6/lib";
	    libgdbincdir = mvdpath + "kdb/libgdb/inc";
	    libgdblibdir = mvdpath + "kdb/libgdb/lib";	    
	
	    // Read Motif and MVD lib and include directories from the MVD CONFIG file
	
	    configFilename = mvdpath + "CONFIG";
	    configFile = new ifstream( configFilename.c_str() );

	    if ( ! configFile->good() ) {
		cerr << argv[0] << ": Warning could not open file \"" << configFilename << "\".  Profiling disabled.\n";
		profile = false;
	    } else {
		const int dirnum = 5;
		struct {
		    char *dirkind;
		    int used;
		    string *dirname;
		} dirs[dirnum] = {
		    { "INSTALLINCDIR", 1, &mvdincdir },
		    { "INSTALLLIBDIR", 1, &mvdlibdir },
		    { "MOTIFINCLUDEDIR", 1, &motifincdir },
		    { "MOTIFLIBDIR", 1, &motiflibdir },
		    { "TMPDIR", 1, &tmppath },
		};
		string dirkind, equal, dirname;
		int cnt, i;
		int numOfDir = 0;

		for ( cnt = 0 ; cnt < dirnum; cnt += 1 ) { // names can appear in any order
		    for ( ;; ) {
			*configFile >> dirkind;
		  if ( configFile->eof() || ! configFile->good() ) goto fini;
			for ( i = 0; i < dirnum && dirkind != dirs[i].dirkind; i += 1 ); // linear search
		      if ( i < dirnum ) break;		// found a line to be parsed
		    } // for
		    *configFile >> equal;
		  if ( configFile->eof() || ! configFile->good() || equal != "=" ) break;
		    *configFile >> dirname;
		  if ( configFile->eof() || ! configFile->good() ) break;

		    numOfDir += dirs[i].used;		// handle repeats
		    dirs[i].used = 0;
		    *dirs[i].dirname = dirname;
#ifdef __U_DEBUG_H__
		    cerr << dirkind << equal << dirname << endl;
#endif __U_DEBUG_H__
		} // for
	      fini:
		if ( numOfDir != dirnum ) {
		    profile = false;
		    cerr << argv[0] << ": Warning file \"" << configFilename << "\" corrupt.  Profiling disabled.\n";
		} // if
	    } // if
	} // if
    } // if

    if ( link ) {
	// Wrap the arguments that the user passed, including source files,
	// object files and libraries with two modules, uBegin and uEnd, that
	// make it possible to determine at run time when executing in user
	// code.

	int sargs = 2;
	args[sargs] = ( *new string( installlibdir + "/uPrivate" + m + ".o" ) ).c_str();
	sargs += 1;

	if ( profile && ! kernel_profile ) {
	    // shift arguments to be able to squeeze the profiling library in

	    nargs += 5;					// 5 profiler arguments added at beginning
	    for ( int j = nargs + 4; j > sargs + 5; j -=1 ) {
		args[j] = args[j-5];
	    } // for

	    // link the profiling library before the user code
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "mcount";			// force profiler library to be loaded from archive
	    sargs += 1;
	    args[sargs] = "-u";
	    sargs += 1;
	    args[sargs] = "U_PROFILESW";		// force profiler start-up widgets to be loaded from archive
	    sargs += 1;
	    args[sargs] = ( *new string( mvdlibdir + "/uProfile"  + m + d + ".a" ) ).c_str();
	    sargs += 1;
	    
	    // link with the correct version of the kernel module

	    args[sargs] = ( *new string( installlibdir + "/uBegin" + m + ".o" ) ).c_str();
	    sargs += 1;
	} else {
	    // link with the correct version of the kernel module

	    args[sargs] = ( *new string( installlibdir + "/uBegin" + m + ".o" ) ).c_str();
	    sargs += 1;
	} // if    

	if ( tvendor == "sgi" ) {
	    args[nargs] = "-Xlinker";			// gcc trick to pass through next flag to linker
	    nargs += 1;
	    args[nargs] = "-dont_warn_unused";
	    nargs += 1;
	} // if
	
	// link with the correct version of the profiler module

	args[nargs] = ( *new string( installlibdir + "/uEndProfile" + ".o" ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( installlibdir + "/uProfilerFunctionPointers" + ".o" ) ).c_str();
	nargs += 1;

	// link with the correct version of the trace module

	args[nargs] = ( *new string( installlibdir + "/uTrace" + m + "-d.a" ) ).c_str();
	nargs += 1;

	// link with the correct version of the user module

	args[nargs] = ( *new string( installlibdir + "/uUserTrace" + m + d + t + ".a" ) ).c_str();
	nargs += 1;

	// debuggable part of kernel

	args[nargs] = ( *new string( installlibdir + "/uKernel" + m + d + ".a" ) ).c_str();
	nargs += 1;
#if 0
	// non-debuggable part of kernel

	args[nargs] = ( *new string( installlibdir + "/uNDebugBegin" + m + ".o" ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( installlibdir + "/uKernelNDB" + m + d + ".a" ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( installlibdir + "/uNDebugEnd" + m + ".o" ) ).c_str();
	nargs += 1;
#endif
	// link with the correct version of the local debugger module

	args[nargs] = ( *new string( installlibdir + "/uLocalDebugger" + m + "-d.a" ) ).c_str();
	nargs += 1;

	if ( kernel_profile && profile ) {
	    // link with the correct version of the profile module

	    args[nargs] = ( *new string( mvdlibdir + "/uProfile"  + m + d + ".a" ) ).c_str();
	    nargs += 1;
	} // if

	// link with the correct version of the library module

	args[nargs] = ( *new string( installlibdir + "/uLibrary" + m + d + ".a" ) ).c_str();
	nargs += 1;

	if ( tvendor == "sgi" ) {
	    args[nargs] = "-Xlinker";			// gcc trick to pass through next flag to linker
	    nargs += 1;
	    args[nargs] = "-warn_unused";
	    nargs += 1;
	} // if
	
	args[nargs] = ( *new string( installlibdir + "/uEnd" + m + ".o" ) ).c_str();
	nargs += 1;

	if ( tvendor == "ibm" ) {
	    // Prevent linker from reordering code in memory.  This is
	    // necessary for the correct implementation of time slicing and
	    // shared memory management.

	    args[nargs] = "-Xlinker";			// gcc trick to pass through next flag to linker
	    nargs += 1;
	    args[nargs] = "-bnoobjreorder";
	    nargs += 1;
	} // if

	// any machine specific libraries

	if ( tvendor == "ibm" ) {
	    libs[nlibs] = "-lbsd";
	    nlibs += 1;
	} // if

	if ( tvendor == "hp" ) {
	    libs[nlibs] = "-lBSD";
	    nlibs += 1;
	} // if
#if 0
	if ( tvendor == "pc" && tos == "linux" ) {
	    // Prevent linker from reordering code in memory.  This is
	    // necessary for the correct implementation of time slicing and
	    // shared memory management.

	    libs[nlibs] = "-Xlinker";			// gcc trick to pass through next flag to linker
	    nlibs += 1;
	    libs[nlibs] = "-Bstatic";
	    nlibs += 1;
	} // if
#endif
	if ( tvendor == "sun" ) {
	    if ( tos == "svr4" ) {
		libs[nlibs] = "-lnsl";
		nlibs += 1;
		libs[nlibs] = "-ldl";
		nlibs += 1;

		// if profiling flag is set, -lX11 -lXt -lSM and -lICE have to be dynamically linked as well
	    
		if ( profile ) {
		    libs[nlibs] = "-lXm";
		    nlibs += 1;
		    libs[nlibs] = "-lX11";
		    nlibs += 1;
		    libs[nlibs] = "-lXt";
		    nlibs += 1;
		    libs[nlibs] = "-lSM";
		    nlibs += 1;
		    libs[nlibs] = "-lICE";
		    nlibs += 1;
		    libs[nlibs] = ( *new string( string( "-R" ) + uxlibdir + string( ":" ) + motiflibdir ) ).c_str();
		    nlibs += 1;
		} // if
	    } // if

	    // All libraries are linked statically in multiprocessor to ensure
	    // that .data and .bss areas are memory mapped. The one exception
	    // is -nsl, which references -ldl, and there is no static version
	    // of -ldl.

	    if ( multi ) {
		libs[nlibs] = "-Xlinker";		// gcc trick to pass through next flag to linker
		nlibs += 1;
		libs[nlibs] = "-Bstatic";
		nlibs += 1;
	    } // if
	} // if

	if ( tvendor == "sun" && tos == "svr4" ) {
	    libs[nlibs] = "-lsocket";
	    nlibs += 1;
	    if ( profile ) {
		libs[nlibs] = "-lgen";
		nlibs += 1;
	    } // if
	} // if

	if ( profile ) {
	    args[nargs] = ( *new string( mvdlibdir + "/uVisual" + m + d + ".a" ) ).c_str();
	    nargs += 1;
	    args[nargs] = ( *new string( string("-L") + mvdlibdir ) ).c_str();
	    nargs += 1;
	    args[nargs] = ( *new string( string("-L") + uxlibdir ) ).c_str();
	    nargs += 1;
	    args[nargs] = ( *new string( string("-L") + libgdblibdir ) ).c_str();
	    nargs += 1;
	    args[nargs] = ( *new string( string("-L") + motiflibdir ) ).c_str();
	    nargs += 1;
	    libs[nlibs] = ( *new string( string("-luX") + m ) ).c_str();
	    nlibs += 1;
	    if ( tvendor != "sun" || tos != "svr4" ) {
		args[nargs] = ( *new string( "-Xlinker" ) ).c_str();
		nargs += 1;
		args[nargs] = ( *new string( "-rpath-link" ) ).c_str();	// needed for SunOS and ELF
		nargs += 1;
		args[nargs] = ( *new string( "-Xlinker" ) ).c_str();
		nargs += 1;
		args[nargs] = ( *new string( motiflibdir ) ).c_str();
		nargs += 1;
		args[nargs] = ( *new string( "-Xlinker" ) ).c_str();
		nargs += 1;
		args[nargs] = ( *new string( "-rpath" ) ).c_str(); // needed for SunOS and ELF
		nargs += 1;
		args[nargs] = ( *new string( "-Xlinker" ) ).c_str();
		nargs += 1;
		args[nargs] = ( *new string( uxlibdir + string(":") + motiflibdir ) ).c_str();
		nargs += 1;
		libs[nlibs] = "-lXm";
		nlibs += 1;
		libs[nlibs] = "-lX11";
		nlibs += 1;
		libs[nlibs] = "-lXt";
		nlibs += 1;
		libs[nlibs] = "-lSM";
		nlibs += 1;
		libs[nlibs] = "-lICE";
		nlibs += 1;
		libs[nlibs] = "-lXpm";
		nlibs += 1;
		libs[nlibs] = "-lXext";
		nlibs += 1;
	    } // if
	    libs[nlibs] = "-lm";
	    nlibs += 1;
	    libs[nlibs] = "-lbfd";
	    nlibs += 1;
	    libs[nlibs] = "-liberty";
	    nlibs += 1;
	} // if
    } else {
	// dummy args for uPrivate, uBegin, etc.
	for ( int i = 2; i < iargs; i += 1 ) {
	    char buf[10];
	    sprintf( buf, "%d", i );
	    args[i] = ( *new string( string("-D__U_NULL") + buf + string("__") ) ).c_str();
	} // for
    } // if

    if ( tvendor == "gizmo" ) {
	if ( ! bflag ) {
	    args[nargs] = "-b";
	    nargs += 1;
	    args[nargs] = "gizmo";
	    nargs += 1;
	    args[nargs] = ( *new string( "-D__U_GCC_MACHINE__=gizmo" ) ).c_str();
	    nargs += 1;
	} // if
	if ( ! Vflag ) {
	    args[nargs] = "-V";
	    nargs += 1;
	    args[nargs] = "2.6.2";
	    nargs += 1;
	    args[nargs] = ( *new string( "-D__U_GCC_VERSION__=2.6.2") ).c_str();
	    nargs += 1;
	} // if
	// TEMPORARY: _G_ssize_t is set incorrectly, patched in this directory
	args[nargs] = "-I/gnu/lib/G++-include-263";
	nargs += 1;
    } // if

    // add the directory that contains the include files to the list of
    // arguments after any user specified include directives

    args[nargs] = ( *new string( string("-I") + installincdir ) ).c_str();
    nargs += 1;

    if ( profile ) {
	args[nargs] = ( *new string( string( "-I" ) + mvdincdir ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( string( "-I" ) + uxincdir ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( string( "-I" ) + motifincdir ) ).c_str();
	nargs += 1;
	args[nargs] = ( *new string( string( "-I" ) + libgdbincdir ) ).c_str();
	nargs += 1;
    } // if

    // add the correct set of flags based on the type of compile this is

    string version( VERSION );
    int posn = version.find( "." );			// find the divider between major and minor version numbers
    string major = version.substr( 0, posn );
    string minor = version.substr( posn + 1 );

    args[nargs] = ( *new string( string("-D__U_CPLUSPLUS__=") + major ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__U_CPLUSPLUS_MINOR__=") + minor ) ).c_str();
    nargs += 1;

    if ( cpp_flag ) {
	args[nargs] = "-D__U_CPP__";
	nargs += 1;
    } // if

    if ( upp_flag ) {
	args[nargs] = "-D__U_UPP__";
	nargs += 1;
    } // if

    if ( ! cpp_name.length() == 0 ) {
	args[nargs] = ( *new string( string("-D__U_CPP_NAME__=") + cpp_name ) ).c_str();
	nargs += 1;
    } // if

    if ( multi ) {
	args[nargs] = "-D__U_MULTI__";
	nargs += 1;
	heading += " (multiple processor)";
	if ( link ) {
	    if ( tvendor == "sgi" ) {
		libs[nlibs] = "-lmpc";
		nlibs += 1;
	    } // if
	} // if
    } else {
	heading += " (single processor)";
    } // if

    if ( debug ) {
	heading += " (debug)";
	args[nargs] = "-D__U_DEBUG__";
	nargs += 1;
    } else {
	heading += " (no debug)";
    } // if

    if ( trace ) {
	heading += " (trace)";
	args[nargs] = "-D__U_TRACE__";
	nargs += 1;
    } else {
	heading += " (no trace)";
    } // if

    if ( Yield ) {
	heading += " (yield)";
	args[nargs] = "-D__U_YIELD__";
	nargs += 1;
    } else {
	heading += " (no yield)";
    } // if

    if ( verify ) {
	heading += " (verify)";
	args[nargs] = "-D__U_VERIFY__";
	nargs += 1;
    } else {
	heading += " (no verify)";
    } // if

    if ( profile ) {
        heading += " (profile)";
	args[nargs] = ( *new string( "-pg" ) ).c_str();
	nargs += 1;
        args[nargs] = "-D__U_PROFILE__";
        nargs += 1;
	if ( executable ) {
	    args[nargs] = ( *new string( string("-D__U_EXECUTABLE_FILENAME__=") + *executable ) ).c_str();
	    nargs += 1;
	    delete executable;
	} // if
    } else {
        heading += " (no profile)";
    } // if

    // If this is the g++ compiler, turn the -fvolatile flag on, else, do what
    // ever other local compilers specify that does the same thing as the
    // -fvolatile flag.

    if ( compiler_name == "g++" ) {
	args[nargs] = "-fvolatile"; 
	nargs += 1;
	args[nargs] = "-fvolatile-global"; 
	nargs += 1;
#if ( __GNUG__ == 2 && __GNUC_MINOR__ < 8 )		// gcc releases < 2.8
	args[nargs] = "-fhandle-exceptions"; 
	nargs += 1;
#endif
    } else if ( compiler_name == "CC" ) {
	// CC compiler requires the -E flag so it will not redirect output into
	// a temp file

	if ( upp_flag ) {
	    args[nargs] = "-E";
	    nargs += 1;
	} // if
    } // if

    // Add the uC++ definitions of vendor, cpu and os names to the compilation
    // command.

    args[nargs] = ( *new string( string("-D__") + TVENDOR + "__" ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__") + TCPU + "__" ) ).c_str();
    nargs += 1;
    args[nargs] = ( *new string( string("-D__") + TOS + "__" ) ).c_str();
    nargs += 1;

    if ( Bprefix.length() == 0 ) {
	Bprefix = installlibdir;
	args[nargs] = ( *new string( string("-D__U_GCC_BPREFIX__=") + Bprefix ) ).c_str();
	nargs += 1;
    } // if

    // execute the compilation command

    args[0] = compiler_path.c_str();			// set compiler command for exec

    if ( compiler_name == "g++" ) {
	args[nargs] = ( *new string( string("-B") + Bprefix + "/" ) ).c_str();
	nargs += 1;
	if ( profile && link ) {
	    args[nargs] = ( *new string( string( "-B" ) + mvdlibdir + "/" ) ).c_str(); // take profiler's loader
	    nargs += 1;
	} // if
    } else if ( compiler_name == "CC" ) {
	args[nargs] = "-Qpath";
	nargs += 1;
	args[nargs] = Bprefix.c_str();
	nargs += 1;
	if ( profile && link ) {
	    args[nargs] = "-Qpath";
	    nargs += 1;
	    args[nargs] = ( *new string( string( "-B" ) + mvdlibdir + "/" ) ).c_str(); // take profiler's loader
	    nargs += 1;
	} // if
    } else {
	cerr << argv[0] << ": Error compiler " << compiler_name << " not supported.\n";
	exit( -1 );
    } // if

    for ( int i = 0; i < nlibs; i += 1 ) {			// copy non-user libraries after all user libraries
	args[nargs] = libs[i];
	nargs += 1;
    } // for

    args[nargs] = NULL;					// terminate with NULL

#ifdef __U_DEBUG_H__
    cerr << "nargs: " << nargs << endl;
    cerr << "args:" << endl;
    for ( int i = 0; args[i] != NULL; i += 1 ) {
	cerr << " \"" << args[i] << "\"" << endl;
    } // for
    cerr << endl;
#endif __U_DEBUG_H__

    if ( ! quiet ) {
	cerr << "uC++ " << "Version " << VERSION << heading << "\n";
    } // if

    if ( verbose ) {
	if ( argc == 2 ) exit( 0 );			// if only the -v flag is specified, do not invoke g++

	for ( int i = 0; args[i] != NULL; i += 1 ) {
	    cerr << args[i] << " ";
	} // for
	cerr << "\n";
    } // if

    // execute the command and return the result

    if ( nonflags ) {
	execvp( args[0], (char *const *)args );		// should not return
    } else {
	// If there are no command arguments or no nonflag arguments, do not
	// pass any arguments to the compiler.

	args[1] = NULL;					// terminate with NULL
	execvp( args[0], (char *const *)args );		// should not return
    } // if
    perror( "uC++ translator error: u++ level, exec" );
    exit( -1 );
} // main

// Local Variables: //
// compile-command: "dmake" //
// End: //
