//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// token.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:48:16 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Mar 16 13:59:52 1997
// Update Count     : 28
// 

#ifndef __TOKEN_H__
#define __TOKEN_H__

class hash_t;
class symbol_t;

class token_t {
    friend class token_list_t;
  private:
  public:
    token_t *fore;
    token_t *aft;
    int value;
    hash_t *hash;
    symbol_t *symbol;
    token_t *left;
    token_t *right;
    void *operator new( long size );
    void operator delete( void *p );
    token_t( int value, hash_t *hash );
    token_t( token_t *forward, int val, token_t *back );
    ~token_t();
    void add_token_after( token_t &before ); 
    void add_token_before( token_t &after ); 
    void remove_token();
    token_t *next_parse_token();
    token_t *prev_parse_token();
    int connected() const;
}; // token_t

extern token_t *ahead;

class token_list_t {
  private:
    token_t head;
    token_t tail;
  protected:
  public:
    token_list_t();
    ~token_list_t();
    void add_to_head( token_t &insert );
    void add_to_tail( token_t &insert );
    token_t *remove_from_head();
    token_t *remove_from_tail();
    token_t *get_head();
    token_t *get_tail();
    int empty();
}; // token_list_t

extern token_list_t * list;

#endif __TOKEN_H__

// Local Variables: //
// compile-command: "dmake" //
// End: //
