//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// table.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:59:11 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb 10 11:34:20 1999
// Update Count     : 54
// 


#ifndef __TABLE_H__
#define __TABLE_H__

class table_t;

#include "symbol.h"
#include "structor.h"
#include "token.h"

struct table_t {
    symbol_t * list;
    table_t * search;
    table_t * parent;
    symbol_t * symbol;
    unsigned int access;
    structor_list_t constructor;			// list of constructors for class 
    structor_list_t destructor;				// list of destructors for class 
    bool defined;					// class body defined (i.e., not just prototype)
    bool hascopy;					// has a copy constructor
    bool haseqop;					// has an equal operator
    bool hasdefault;					// has a default constructor
    token_t *private_area;
    token_t *protected_area;
    token_t *public_area;
    
    table_t( symbol_t * symbol );
    ~table_t();

    void push_table();
    void display_table( int black );
    symbol_t * search_table( hash_t * hash );
    symbol_t * member_table( hash_t * hash );
    void insert_table( symbol_t * symbol );
};

extern table_t * top;
extern table_t * global;
extern table_t * focus;

extern table_t *keywords;
extern table_t *root;

table_t * pop_table();

#endif __TABLE_H__

// Local Variables: //
// compile-command: "dmake" //
// End: //
