//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// table.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:32:43 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb 10 11:33:16 1999
// Update Count     : 187
// 

#include <stdlib.h>
#include <stdio.h>

#include "assert.h"
#include "key.h"
#include "hash.h"
#include "symbol.h"
#include "structor.h"
#include "include.h"
#include "table.h"
#include "input.h"


//#define __U_DEBUG_H__
#ifdef __U_DEBUG_H__
#include <iostream.h>
#endif __U_DEBUG_H__


// define the initial contents of the root table

table_t *root, *keywords;

// define the pointers to the root table

table_t * global;					// pointer to global table
table_t * top;						// pointer to current top table
table_t * focus;					// pointer to current scope table

table_t::table_t( symbol_t * symbol ) {
    // initialize the fields of the table

    list = NULL;
    search = NULL;
    parent = NULL;
    table_t::symbol = symbol;
    access = 0;
    defined = false;
    hascopy = false;
    haseqop = false;
    hasdefault = false;
    private_area = NULL;
    protected_area = NULL;
    public_area = NULL;

    // remember which table is associated with this symbol

    if ( symbol != NULL ) {
	symbol->table = this;
    } // if
} // table_t::table_t


table_t::~table_t() {
    symbol_t * list = this->list;
    while ( list != NULL ) {
	symbol_t * symbol = list;

	// remember that the hash node pointed to by this symbol table
	// is not in this symbol table any more

	if ( symbol->hash != NULL ) {
	    symbol->hash->InSymbolTable -= 1;
	} // if

	list = list->link;
	// table is copied for typedef so don't delete it. original type will delete it.
	if ( symbol->table != NULL && ! ( symbol->attribute.value1 & TYPEDEF_ATTRIBUTE ) ) {
	    delete symbol->table;
	} // if
	delete symbol;
    } // while
} // table_t::~table_t


void table_t::push_table() {
    parent = top;
    top = focus = this;
} // table_t::push_table


static void print_blanks( int blank ) {
    for ( int i = 0; i < blank; i += 1 ) {
	fprintf( stderr, " " );
    } // for
} // print_blanks


void table_t::display_table( int blank ) {
    symbol_t * symbol;

    print_blanks( blank );
    fprintf( stderr, "** table 0x%p parent 0x%p search 0x%p **", this, this->parent, this->search );
    if ( this->symbol != NULL && this->symbol->hash != NULL ) {
	fprintf( stderr, " \"%s\"\n", this->symbol->hash->text );
    } else {
	fprintf( stderr, "\n" );
    } // if

    symbol = this->list;

    while ( symbol != NULL ) {
	print_blanks( blank );
	fprintf( stderr, "0x%p \"%s\" table 0x%p", symbol, symbol->hash->text, symbol->table );
	switch ( symbol->value ) {
	  case TYPE:
	    fprintf( stderr, " TYPE" );
	    switch( symbol->key ) {
	      case ENUM:
		fprintf( stderr, " ENUM" );
		break;
	      case STRUCT:
		fprintf( stderr, " STRUCT" );
		break;
	      case UNION:
		fprintf( stderr, " UNION" );
		break;
	      case CLASS:
		fprintf( stderr, " CLASS" );
		break;
	      case COROUTINE:
		fprintf( stderr, " COROUTINE" );
		break;
	      case PTASK:
		fprintf( stderr, " PTASK" );
		break;
	      case RTASK:
		fprintf( stderr, " RTASK" );
		break;
	      case STASK:
		fprintf( stderr, " STASK" );
		break;
	      case TASK:
		fprintf( stderr, " TASK" );
		break;
	      case DUALEVENT:
		fprintf( stderr, " DUALEVENT" );
		break;
	      case RAISEEVENT:
		fprintf( stderr, " RAISEEVENT" );
		break;
	      case THROWEVENT:
		fprintf( stderr, " THROWEVENT" );
		break;
	      default:
		break;
	    } // switch
	    fprintf( stderr, "\n" );
	    if ( symbol->table != NULL ) symbol->table->display_table( blank + 2 );
	    break;
	  case IDENTIFIER:
	    fprintf( stderr, " IDENTIFIER\n" );
	    break;
	  default:
	    fprintf( stderr, " UNKNOWN (%d)\n", symbol->value );
	} // switch
	symbol = symbol->link;
    } // while
} // table_t::display_table


symbol_t * table_t::search_table( hash_t * hash ) {
    // a simple check will determine if the hash is in any table

    if ( hash->InSymbolTable == 0 ) {
	return NULL;
    } // if

#if 0
    while ( table != NULL ) {
	list = table->list;
	while ( list != NULL ) {
	    if ( list->hash == hash ) {
		return list;
	    } // if
	    list = list->link;
	} // while
	table = table->search;
    } // while
#endif

#ifdef __U_DEBUG_H__
    cerr << "lookup:" << hash->text << endl;
#endif __U_DEBUG_H__

    // first search the current block

#ifdef __U_DEBUG_H__
    cerr << "current:" << endl;
    if ( this == root ) {
	cerr << "\troot" << endl;
    } else {
	if ( this->symbol != NULL ) {
	    cerr << "\t" << this->symbol->hash->text << endl;
	} // if
    } // if
#endif __U_DEBUG_H__
    for ( symbol_t *list = this->list; list != NULL; list = list->link ) {
#ifdef __U_DEBUG_H__
    cerr << "\t\t" << list->hash->text << endl;
#endif __U_DEBUG_H__
	if ( list->hash == hash ) return list;
    } // for

    // then up zero or one level and search the derived chain

#ifdef __U_DEBUG_H__
    cerr << "derived:" << endl;
#endif __U_DEBUG_H__
    if ( this->symbol != NULL && this->symbol->base != NULL ) {
	for ( symbol_t *sym = this->symbol->base; sym != NULL; sym = sym->base ) {
#ifdef __U_DEBUG_H__
	    cerr << "\t" << sym->hash->text << endl;
#endif __U_DEBUG_H__
	    if ( sym->table != NULL ) {
		for ( symbol_t *list = sym->table->list; list != NULL; list = list->link ) {
#ifdef __U_DEBUG_H__
		    cerr << "\t\t" << list->hash->text << endl;
#endif __U_DEBUG_H__
		    if ( list->hash == hash ) return list;
		} // for
	    } // if
	} // for
    } else if ( this->search != NULL && this->search->symbol != NULL ) {
	for ( symbol_t *sym = this->search->symbol->base; sym != NULL; sym = sym->base ) {
#ifdef __U_DEBUG_H__
	    cerr << "\t" << sym->hash->text << endl;
#endif __U_DEBUG_H__
	    if ( sym->table != NULL ) {
		for ( symbol_t *list = sym->table->list; list != NULL; list = list->link ) {
#ifdef __U_DEBUG_H__
		    cerr << "\t\t" << list->hash->text << endl;
#endif __U_DEBUG_H__
		    if ( list->hash == hash ) return list;
		} // for
	    } // if
	} // for
    } // if

    // then up one level and search the lexical chain

#ifdef __U_DEBUG_H__
    cerr << "lexical:" << endl;
#endif __U_DEBUG_H__
    for ( table_t *tbl = this->search; tbl != NULL; tbl = tbl->search ) {
#ifdef __U_DEBUG_H__
	if ( tbl->symbol != NULL ) {
	    cerr << "\t" << tbl->symbol->hash->text << endl;
	} else {
	    cerr << "\troot" << endl;
	} // if
#endif __U_DEBUG_H__
	for ( symbol_t *list = tbl->list; list != NULL; list = list->link ) {
#ifdef __U_DEBUG_H__
	    cerr << "\t\t" << list->hash->text << endl;
#endif __U_DEBUG_H__
	    if ( list->hash == hash ) return list;
	} // for
      if ( tbl == root ) break;
    } // for

    return NULL;
} // table_t::search_table


symbol_t * table_t::member_table( hash_t * hash ) {
    symbol_t * list;
    table_t  * table = this;

    while ( table != NULL ) {
	list = table->list;
	while ( list != NULL ) {
	    if ( list->hash == hash ) {
		return list;
	    } // if
	    list = list->link;
	} // while
	assert( table != NULL );
	assert( table->symbol != NULL );
	if ( table->symbol->base != NULL ) {
	    table = table->symbol->base->table;
	} else {
	    table = NULL;
	} // if
    } // while

    return NULL;
} // table_t::member_table


void table_t::insert_table( symbol_t *symbol ) {
    assert( symbol != NULL );

    // link this symbol into the list of symbols associated with this table

    symbol->link = this->list;
    this->list = symbol;

    // remember which table this symbol is found in

    symbol->found = this;

    // remember that the hash node pointed to by this symbol is in another
    // symbol table

    symbol->hash->InSymbolTable += 1;
} // table_t::insert_table


table_t * pop_table() {
    table_t *table = top;
    top = table->parent;
    focus = table->parent;
    return table;
} // pop_table

// Local Variables: //
// compile-command: "dmake" //
// End: //
