//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// symbol.h -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:47:21 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Feb 10 11:31:55 1999
// Update Count     : 46
// 

#ifndef __SYMBOL_H__
#define __SYMBOL_H__

#include "attribute.h"

class hash_t;
class table_t;
class token_t;

const int TIMEOUTPOSN = 0;				// bit 0 is reserved for timeout
const int DESTRUCTORPOSN = 1;				// bit 1 is reserved for destructor
const int MAXENTRYBITS = 127;				// 127 mutex members including destructor

class symbol_t {
  public:
    int value;						// symbol an identifier or type
    hash_t *hash;					// name of symbol in hash table
    symbol_t *link;					// next symbol at this level of table
    table_t *found;					// parent symbol table (where defined)
    table_t *table;					// nested symbol table for symbols defining scope
    unsigned int key;					// kind of class, e.g., class, mutex, coroutine, task, etc.
    attribute_t attribute;				// attribute information for a declarations
    unsigned int index;					// number of mutex member for bit mask
    symbol_t *base;					// base class if inheritance
    bool used;						// indicates if explicit call to constructor in initializer list
    token_t *base_token;				// location to insert implicit base class (e.g., uBaseTask)

    token_t *left;					// delimiter tokens for a template type
    token_t *right;					// used to copy template information
    
    symbol_t( int v, hash_t *h );
    symbol_t( const symbol_t & );
    ~symbol_t();
};

#endif __SYMBOL_H__

// Local Variables: //
// compile-command: "dmake" //
// End: //
