//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// scan.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:11:49 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Dec 17 16:49:48 1997
// Update Count     : 38
// 

#include <stdlib.h>
#include <stdio.h>

#include "assert.h"
#include "key.h"
#include "hash.h"
#include "symbol.h"
#include "include.h"
#include "token.h"
#include "table.h"
#include "input.h"
#include "scan.h"

static inline bool id( unsigned int value ) {
    return value == IDENTIFIER;
} // id

static bool op( unsigned int value ) {
    if ( value == NEW ) return true;
    if ( value == DELETE ) return true;
    if ( value == '+' ) return true;
    if ( value == '-' ) return true;
    if ( value == '*' ) return true;
    if ( value == '/' ) return true;
    if ( value == '%' ) return true;
    if ( value == '^' ) return true;
    if ( value == '&' ) return true;
    if ( value == '|' ) return true;
    if ( value == '~' ) return true;
    if ( value == '!' ) return true;
    if ( value == '=' ) return true;
    if ( value == '<' ) return true;
    if ( value == '>' ) return true;
    if ( value == PLUS_ASSIGN ) return true;
    if ( value == MINUS_ASSIGN ) return true;
    if ( value == MULTIPLY_ASSIGN ) return true;
    if ( value == DIVIDE_ASSIGN ) return true;
    if ( value == MODULUS_ASSIGN ) return true;
    if ( value == XOR_ASSIGN ) return true;
    if ( value == AND_ASSIGN ) return true;
    if ( value == OR_ASSIGN ) return true;
    if ( value == LSH ) return true;
    if ( value == RSH ) return true;
    if ( value == LSH_ASSIGN ) return true;
    if ( value == RSH_ASSIGN ) return true;
    if ( value == EQ ) return true;
    if ( value == NE ) return true;
    if ( value == LE ) return true;
    if ( value == GE ) return true;
    if ( value == AND_AND ) return true;
    if ( value == OR_OR ) return true;
    if ( value == PLUS_PLUS ) return true;
    if ( value == MINUS_MINUS ) return true;
    if ( value == ',' ) return true;
    if ( value == ARROW_STAR ) return true;
    if ( value == ARROW ) return true;
    if ( value == '(' ) return true;
    if ( value == ')' ) return true;
    if ( value == '[' ) return true;
    if ( value == ']' ) return true;
    
    return false;
} // op

void scan() {
    ahead = ahead->next_parse_token( );

    if ( ahead->value == EOF ) return;

    if ( ahead->hash->value != 0 ) {
	// if the value of the hash associated with the look ahead token
	// is non zero, it must be a keyword.  simply make the value
	// of the token the value of the keyword.
	
	ahead->value = ahead->hash->value;
    } else if ( id( ahead->value ) || op( ahead->value ) ) {
	// use the symbol to determine whether the identifier is
	// a type or a variable.
	
	ahead->symbol = focus->search_table( ahead->hash );
	if ( ahead->symbol != NULL ) {
	    ahead->value = ahead->symbol->value;
	} // if
    } // if
} // scan

// Local Variables: //
// compile-command: "dmake" //
// End: //
