//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// parse.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:10:34 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Apr 28 17:57:25 1999
// Update Count     : 1459
// 

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define DEBUG

#include "assert.h"
#include "main.h"
#include "name.h"
#include "key.h"
#include "hash.h"
#include "attribute.h"
#include "symbol.h"
#include "structor.h"
#include "include.h"
#include "token.h"
#include "table.h"
#include "input.h"
#include "scan.h"
#include "jump.h"
#include "parse.h"
#include "gen.h"


#define LC '{'
#define RC '}'

#define LP '('
#define RP ')'

#define LB '['
#define RB ']'

#define LA '<'
#define RA '>'


static bool eof() {
    return ahead->value == EOF;
} // eof


static bool check( int token ) {
    if ( token == ahead->value ) {
	return true;
    } // if
    return false;
} // check


static bool match( int token ) {
    if ( check( token ) ) {
	scan();
	return true;
    } // if
    return false;
} // match


static bool sync_raise_statement();


static match_closing( char left, char right, bool semicolon = true ) {
    // assume starting character is already matched
    int level = 0;
    for ( ;; ) {
	sync_raise_statement();
	if ( eof() ) return false;
	if ( semicolon && check( ';' ) ) return false;
	if ( match( right ) ) {
	    if ( level == 0 ) break;
	    level -= 1;
	} else if ( match( left ) ) {
	    level += 1;
	} else {
	    scan();
	} // if
    } // for
    return true;
} // match_brackets


static bool template_key( token_t *token ) {
    token_t *back = ahead;
    assert( token != (token_t *)0 );

    if ( match( LA ) ) {
	token->left = ahead->prev_parse_token();
	if ( match_closing( LA, RA ) ) {
	    token->right = ahead->prev_parse_token();
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // template_key


static token_t *type() {
    token_t *back = ahead;
    token_t *token;

    match( COLON_COLON );				// optional ::
    for ( ;; ) {
      if ( eof() ) break;
	token = ahead;
	if ( match( TYPE ) ) {
	    template_key( token );

	    if ( check( COLON_COLON ) ) {
		assert( token != NULL );
		assert( token->symbol != NULL );
		focus = token->symbol->table;
		if ( focus == NULL ) break;		// not defined, only forward
		scan();
	    } else {
		// reset the focus of the scanner to the top table, and return
		// the token that points to the type.

		focus = top; return token;
	    } // if
	} else {
	    break;
	} // if
    } // for

    focus = top; ahead = back; return NULL;
} // type


static token_t *epyt() {
    token_t *back = ahead;
    token_t *token;

    match( COLON_COLON );				// optional ::
    for ( ;; ) {
      if ( eof() ) break;
	token = ahead;
	if ( match( '~' ) ) {
	    token = ahead;
	    if ( match( TYPE ) ) {
		focus = top;
		return token;
	    } else {
		break;
	    } // if
	} else if ( match( TYPE ) ) {
	    template_key( token );

	    if ( check( COLON_COLON ) ) {
		assert( token != NULL );
		assert( token->symbol != NULL );
		focus = token->symbol->table;
		if ( focus == NULL ) break;		// not defined, only forward
		scan();
	    } else {
		break;
	    } // if
	} else {
	    break;
	} // if
    } // for

    focus = top; ahead = back; return NULL;
} // epyt


static token_t *identifier() {
    token_t *back = ahead;
    token_t *token;

    match( COLON_COLON );				// optional ::
    for ( ;; ) {
      if ( eof() ) break;
	token = ahead;
	if ( match( IDENTIFIER ) ) {
	    template_key( token );

	    // if this identifier has no symbol table entry associated with it,
	    // make one

	    assert( token != NULL );
	    if ( token->symbol == NULL ) {
		token->symbol = new symbol_t( token->value, token->hash );
	    } // if

	    // reset the scanner's focus and return the current token

	    focus = top; return token;
	} else if ( match( TYPE ) ) {
	    template_key( token );

	    if ( check( COLON_COLON ) ) {
		assert( token != NULL );
		assert( token->symbol != NULL );
		focus = token->symbol->table;
		if ( focus == NULL ) break;		// not defined, only forward
		scan();
	    } else {
		break;
	    } // if
	} else {
	    break;
	} // if
    } // for

    focus = top; ahead = back; return NULL;
} // identifier


static token_t *op() {
    token_t *back = ahead;

    if ( match( NEW ) ) return back;
    if ( match( DELETE ) ) return back;
    if ( match( '+' ) ) return back;
    if ( match( '-' ) ) return back;
    if ( match( '*' ) ) return back;
    if ( match( '/' ) ) return back;
    if ( match( '%' ) ) return back;
    if ( match( '^' ) ) return back;
    if ( match( '&' ) ) return back;
    if ( match( '|' ) ) return back;
    if ( match( '~' ) ) return back;
    if ( match( '!' ) ) return back;
    if ( match( '=' ) ) return back;
    if ( match( '<' ) ) return back;
    if ( match( '>' ) ) return back;
    if ( match( PLUS_ASSIGN ) ) return back;
    if ( match( MINUS_ASSIGN ) ) return back;
    if ( match( MULTIPLY_ASSIGN ) ) return back;
    if ( match( DIVIDE_ASSIGN ) ) return back;
    if ( match( MODULUS_ASSIGN ) ) return back;
    if ( match( XOR_ASSIGN ) ) return back;
    if ( match( AND_ASSIGN ) ) return back;
    if ( match( OR_ASSIGN ) ) return back;
    if ( match( LSH ) ) return back;
    if ( match( RSH ) ) return back;
    if ( match( LSH_ASSIGN ) ) return back;
    if ( match( RSH_ASSIGN ) ) return back;
    if ( match( EQ ) ) return back;
    if ( match( NE ) ) return back;
    if ( match( LE ) ) return back;
    if ( match( GE ) ) return back;
    if ( match( AND_AND ) ) return back;
    if ( match( OR_OR ) ) return back;
    if ( match( PLUS_PLUS ) ) return back;
    if ( match( MINUS_MINUS ) ) return back;
    if ( match( ',' ) ) return back;
    if ( match( ARROW_STAR ) ) return back;
    if ( match( ARROW ) ) return back;
    if ( match( MAX ) ) return back;
    if ( match( MIN ) ) return back;

    // because the following operators are denoted by multiple tokens, and we
    // only want to represent them with single tokens we will parse them as
    // multiple tokens, but pass only the first token to identify them later

    if ( match( LP ) && match( RP ) ) return back;
    if ( match( LB ) && match( RB ) ) return back;

    ahead = back; return NULL;
} // op


static bool specifier_list( attribute_t &attribute );
static bool pointer();


static token_t *operater() {
    token_t *back = ahead;
    token_t *token;
    attribute_t attribute;

    for ( ;; ) {
      if ( eof() ) break;
	token = ahead;
	if ( match( OPERATOR ) ) {
	    token_t *start = ahead;
	    if ( ( token = op() ) != NULL ) {
		// if this operator has no symbol table entry associated with
		// it, make one

		if ( token->symbol == NULL ) {
		    token->symbol = new symbol_t( token->value, token->hash );
		} // if

		// check if this a fundamental assignment operator so the
		// translator does not generate a null, private assignment
		// operator.

		if ( '=' == token->value && focus->symbol != NULL ) {
		    token_t *save = ahead;

		    if ( match( LP ) ) {
			while ( match( CONST ) || match( VOLATILE ) ) {} // eat up const & volatile
			if ( check( TYPE ) && ahead->symbol == focus->symbol ) {
			    scan();
			    if ( match( '&' ) ) {
				match( IDENTIFIER );
				// eat up an optional identifier
				if ( match( RP ) ) {
				    focus->haseqop = true;
				} // if
			    } // if
			} // if
		    } // if
		    ahead = save;
		} // if

		// reset the scanner's focus and return the current token

		focus = top;
		return token;
	    } else {
		table_t *savefocus = focus;		// specifier_list changes focus
		if ( specifier_list( attribute ) ) {
		    pointer();				// optional

		    focus = savefocus;
		    char name[256] = "\0";
		    for ( token_t *p = start; ; ) {	// build a name for the conversion operator
		      if ( p == ahead ) break;
			strcat( name, p->hash->text );
			token_t *c = p;
			p = p->next_parse_token();
			if ( p != ahead ) {
			    strcat( name, " " );
			} // if
			c->remove_token();		// remove tokens forming the name
			delete c;
		    } // for

		    token = new token_t( TYPE, hash_table->look( name ) );
		    token->symbol = focus->search_table( token->hash );

		    // insert this token into the token stream

		    token->add_token_before( *ahead );

		    // if this operator has no symbol table entry associated with
		    // it, make one

		    if ( token->symbol == NULL ) {
			token->symbol = new symbol_t( token->value, token->hash );
		    } // if

		    // reset the scanner's focus and return the current token

		    focus = top; return token;
		} // if
		focus = savefocus;
	    } // if
	} else if ( match( TYPE ) ) {
	    template_key( token );

	    if ( check( COLON_COLON ) ) {
		assert( token != NULL );
		assert( token->symbol != NULL );
		focus = token->symbol->table;
		if ( focus == NULL ) break;		// not defined, only forward
		scan();
	    } else {
		break;
	    } // if
	} else {
	    break;
	} // if
    } // for

    focus = top; ahead = back; return NULL;
} // operater


static bool statement( symbol_t *symbol );


static bool condition( bool semicolon = true ) {
    token_t *back = ahead;

    if ( match( LP ) ) {
	if ( match_closing( LP, RP, semicolon ) ) {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // condition


static bool wait_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( WAIT ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {					// look for the end of the statement
	  if ( eof() ) break;
	    if ( match( WITH ) ) {
		suffix = ahead;
		gen_wait_prefix( prefix, suffix );
		prefix = ahead;
		for ( ;; ) {
		  if ( eof() ) break;
		    if ( match( ';' ) ) {
			suffix = ahead->prev_parse_token();
			if ( prefix == suffix ) {
			    gen_error( suffix, "parse error, expected integer value after uWith" );
			    goto fini;
			} // if
			gen_with( prefix, suffix );
			gen_wait_suffix( suffix );
			return true;
		    } // if
		    scan();
		} // for
	    } // if
	    if ( match( ';' ) ) {
		suffix = ahead->prev_parse_token();
		if ( prefix == suffix ) {
		    gen_error( suffix, "parse error, expected condition value after uWait" );
		    goto fini;
		} // if
		gen_wait_prefix( prefix, suffix );
		gen_wait_suffix( suffix );
		return true;
	    } // if
	    scan();
	} // for
    } // if
  fini:
    ahead = back; return false;
} // wait_statement


static bool signal_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( SIGNAL ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {					// look for the end of the statement
	  if ( eof() ) break;
	    if ( match( ';' ) ) {
		suffix = ahead->prev_parse_token();
		if ( prefix == suffix ) {
		    gen_error( suffix, "parse error, expected condition after uSignal" );
		    goto fini;
		} // if
		gen_signal_prefix( prefix );
		gen_signal_suffix( suffix );
		return true;
	    } // if
	    scan();
	} // for
    } // if
  fini:
    ahead = back; return false;
} // signal_statement


static bool signalblock_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( SIGNALBLOCK ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {					// look for the end of the statement
	  if ( eof() ) break;
	    if ( match( ';' ) ) {
		suffix = ahead->prev_parse_token();
		if ( prefix == suffix ) {
		    gen_error( suffix, "parse error, expected condition after uSignalBlock" );
		    goto fini;
		} // if
		gen_signalblock_prefix( prefix );
		gen_signalblock_suffix( suffix );
		return true;
	    } // if
	    scan();
	} // for
    } // if
  fini:
    ahead = back; return false;
} // signalblock_statement


static bool suspend_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;

    if ( match( SUSPEND ) ) {
	prefix = ahead;
	if ( match( ';' ) ) {
	    gen_suspend_prefix( prefix, symbol );
	    gen_suspend_suffix( ahead, symbol );
	}  else {
	    gen_error( ahead, "parse error, expected ';' after uSuspend" );
	} // if
	return true;
    } // if

    ahead = back; return false;
} // suspend_statement


static bool resume_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;

    if ( match( RESUME ) ) {
	prefix = ahead;
	if ( match( ';' ) ) {
	    gen_resume_prefix( prefix, symbol );
	    gen_resume_suffix( ahead, symbol );
	} else {
	    gen_error( ahead, "parse error, expected ';' after uResume" );
	} // if
	return true;
    } // if

    ahead = back; return false;
} // resume_statement


static bool accept_statement( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol );
static bool or_clause( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol );
static bool uelse_clause( bool uncondaccept, jump_t *list, symbol_t *symbol );
static bool timeout_clause( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol );


static bool accept_start( token_t *&startposn, token_t *before, jump_t *list, symbol_t *symbol  ) {
    if ( list == NULL ) {
	gen_code( before, "{" );
	gen_code( before, "uSerial :: uProtectAcceptStmt uProtectAcceptStmtInstance ( uSerialInstance" );
	// broken off from previous code fragment to allow subsequent insertion by timeout
	gen_code( before, ") ;" );
	// remember previous location for subsequent insertion by timeout
	startposn = before->prev_parse_token();
	if ( trace ) {
	    gen_code( before, "uTraceAcceptStart uTraceAcceptStartInstance ( uTraceInstance ) ;" );
	} // if
    } // if
} // accept_start


static bool accept_end( token_t *before, jump_t *list, symbol_t *symbol  ) {
    gen_code( before, "switch ( uSerialInstance . uMutexMaskPosn ) {" );
    for ( ; list != NULL; list = list->link ) {
	gen_code( before, "case" );
	gen_mask( before, list->index );
	gen_code( before, ": goto" );
	gen_hash( before, list->label );
	gen_code( before, ";" );
    } // for
    // closing brace inserted after call
} // accept_end


static bool accept_clause( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol  ) {
    token_t *back = ahead;
    token_t *start;
    token_t *finish;
    token_t *member;
    jump_t jump;
    unsigned int index;

    start = ahead;
    if ( match( LP ) ) {
	gen_code( start, "uSerialInstance . uAcceptTry" ); // insert before LP
	start = ahead;
	if ( ( member = identifier() ) != NULL || ( member = operater() ) != NULL || ( member = epyt() ) != NULL ) {
	    finish = ahead;
	    while ( start != finish ) {			// remove the member name from the token stream as it is not printed
		token_t *dump = start;
		start = start->next_parse_token();
		dump->remove_token();
		delete dump;
	    } // while

	    symbol_t *msymbol = member->symbol;
	    assert( msymbol != NULL );

	    if ( msymbol->table != NULL || msymbol->index != DESTRUCTORPOSN ) {
		if ( msymbol->table != NULL ) {		// must be the destructor
		    assert( symbol->found != NULL );
		    // check destructor name is the same as the containing class
		    if ( symbol->found->symbol == msymbol ) {
			index = DESTRUCTORPOSN;
		    } else {
			gen_error( ahead, "accept on an invalid destructor" );
		    } // if
		} else {				// members other than destructor
		    index = msymbol->index;
		} // if

		// check if multiple accepts for this member in the accept
		// statement

		for ( jump_t *p = list; p != NULL; p = p->link ) {
		    if ( index == p->index ) {
			char msg[strlen(msymbol->hash->text) + 100];

			sprintf( msg, "multiple accepts of mutex member \"%s\" in accept statement", msymbol->hash->text );
			gen_error( ahead, msg );
			break;
		    } // if
		} // for
	    } else {
		index = DESTRUCTORPOSN;			// kludge to prevent errors about exceeding maximum number of mutex members
		gen_error( ahead, "accept on a non-mutex member, possibly caused by uAccept appearing before mutex member definition" );
	    } // if

	    gen_entry( ahead, index );
	    gen_code( ahead, "," );
	    gen_mask( ahead, index );

	    if ( match( RP ) ) {
		gen_code( ahead, ") {" );

		jump.index = index;			// initialize node
		jump.label = hash_table->look( name() );
		jump.link = list;			// add node to head of list
		list = &jump;				// set top of list

		gen_hash( ahead, jump.label );
		gen_code( ahead, ":" );

		statement( symbol );
		if ( or_clause( startposn, uncondaccept, list, symbol ) ) {
		} else if ( uelse_clause( uncondaccept, list, symbol ) ) {
		} else {
		    gen_code( ahead, "} else {" );
		    if ( ! uncondaccept ) {		// all accepts unconditional ?
			gen_code( ahead, "if ( uSerialInstance . uAcceptTestMask( ) ) { uAbort ( \"all guards false in accept statement\" ) ; }" );
		    } // if
		    gen_code( ahead, "uSerialInstance . uAcceptPause ( ) ;" );
		    accept_end( ahead, list, symbol );
		    gen_code( ahead, "}" );		// closing brace for switch
		    gen_code( ahead, "}" );
		} // if

		if ( jump.link == NULL ) {
		    if ( trace ) {
			gen_code( ahead, "{ uTraceAcceptDone uTraceAcceptDoneInstance ( uTraceInstance ) ; }" );
		    } // if
		    gen_code( ahead, "}" );
		} // if
		return true;
	    } // if
	} else {
	    gen_error( ahead, "parse error, expected mutex member name after parenthesis" );
	} // if
    } else {
	gen_error( ahead, "parse error, expected parenthesized mutex member name after uAccept" );
    } // if

    ahead = back; return false;
} // accept_clause


static bool or_clause( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol  ) {
    token_t *back = ahead;

    if ( match( OR ) ) {
	gen_code( ahead, "} else {" );
	if ( ! accept_statement( startposn, uncondaccept, list, symbol ) ) {
	    gen_error( ahead, "parse error, uAccept or uTimeout clause must follow uOr" );
	    goto fini;
	} // if
	gen_code( ahead, "}" );
	return true;
    } // if
  fini:
    ahead = back; return false;
} // or_clause


static bool uelse_clause( bool uncondaccept, jump_t *list, symbol_t *symbol  ) {
    token_t *back = ahead;

    if ( match( UELSE ) ) {
	gen_code( ahead, "} else {" );
	gen_code( ahead, "uSerialInstance . uAcceptElse ( ) ;" );
	statement( symbol );
	gen_code( ahead, "}" );
	return true;
    } // if

    ahead = back; return false;
} // uelse_clause


static bool timeout_clause( token_t *startposn, bool conditional, bool uncondaccept, jump_t *list, symbol_t *symbol  ) {
    token_t *back = ahead;
    token_t *start;

    if ( list == NULL ) {				// single statement
	start = ahead;
	if ( condition() ) {
	    gen_code( start, "{ uThisTask ( ) . uSleep (" ); // insert before timeout expression
	    gen_code( ahead, ") ;" );			// insert after timeout expression
	    statement( symbol );
	    gen_code( ahead, "}" );
	    return true;
	} else {
	    gen_error( ahead, "expected parenthesized expression after uTimeout" );
	} // if
    } else {
	gen_code( startposn, ", true" );
    
	start = ahead;
	if ( condition() ) {
	    gen_code( start, "{ uSerialInstance . uAcceptTry ( ) ; uSerialInstance . uAcceptPause (" ); // insert before timeout expression
	    gen_code( ahead, ") ;" );			// insert after timeout expression
	    if ( conditional ) {			// conditional timeout ?
		gen_code( ahead, "} else {" );
		if ( ! uncondaccept ) {			// all accepts conditional ?
		    gen_code( ahead, "if ( uSerialInstance . uAcceptTestMask( ) ) { uAbort ( \"all guards false in accept statement\" ) ; }" );
		} // if
		gen_code( ahead, "uSerialInstance . uAcceptPause ( ) ;" );
	    } // if
	    gen_code( ahead, "}" );
	    accept_end( ahead, list, symbol );
	    gen_code( ahead, "case 0x00 :" );		// add timeout case clause at end
	    statement( symbol );
	    gen_code( ahead, "}" );			// closing brace for switch
	    return true;
	} else {
	    gen_error( ahead, "expected expression after parenthesis" );
	} // if
    } // if

    ahead = back; return false;
} // timeout_clause


static bool accept_statement( token_t *startposn, bool uncondaccept, jump_t *list, symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *start;

    if ( match( WHEN ) ) {				// optional
	start = ahead;
	if ( ! condition() ) {
	    gen_error( ahead, "expected parenthesized conditional after uWhen" );
	    goto fini;
	} // if

	if ( match( ACCEPT ) ) {
	    accept_start( startposn, start, list, symbol ); // insert before condition
	    gen_code( start, "if (" );			// insert before condition
	    gen_code( ahead, "&&" );			// insert after condition
	    if ( accept_clause( startposn, uncondaccept, list, symbol ) ) {
		return true;
	    } // if
	} else if ( match ( TIMEOUT ) ) {
	    gen_code( start, "if (" );			// insert before condition
	    gen_code( ahead, ")" );			// insert after condition
	    if ( timeout_clause( startposn, true, uncondaccept, list, symbol ) ) {
		return true;
	    } // if
	} else {
	    gen_error( ahead, "expect uAccept or uTimeout after uWhen" );
	} // if
    } else {
	uncondaccept = true;				// unconditional accept found
	if ( match( ACCEPT ) ) {
	    accept_start( startposn, ahead, list, symbol );
	    gen_code( ahead, "if (" );
	    if ( accept_clause( startposn, uncondaccept, list, symbol ) ) {
		return true;
	    } // if
	} else if ( match( TIMEOUT ) ) {
	    if ( timeout_clause( startposn, false, uncondaccept, list, symbol ) ) {
		return true;
	    } // if
	} // if
    } // if
  fini:
    ahead = back; return false;
} // accept_statement


static bool labeled_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( identifier() ) {
	if ( match( ':' ) ) {
	    if ( statement( symbol ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // labeled_statement


static bool case_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( CASE ) ) {
	for ( ;; ) {
	    if ( eof() ) goto fini;
	  if ( match( ':' ) ) break;
	    scan();
	} // for
	if ( statement( symbol ) ) {
	    return true;
	} // if
    } // if
  fini:
    ahead = back; return false;
} // case_statement


static bool default_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( DEFAULT ) ) {
	if ( match( ':' ) ) {
	    if ( statement( symbol ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // default_statement


static bool compound_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( LC ) ) {
#if 0
	if ( user ) {
	    if ( verify ) gen_verify( ahead );
	    if ( Yield ) gen_yield( ahead );
	} // if
#endif
	while ( statement( symbol ) );
	if ( match( RC ) ) {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // compound_statement


static bool if_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( IF ) ) {
	if ( condition() ) {
	    if ( statement( symbol ) ) {
		if ( match( ELSE ) ) {
		    if ( statement( symbol ) ) {
			return true;
		    } // if
		} else {
		    return true;
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // if_statement


static bool switch_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( SWITCH ) ) {
	if ( condition() ) {
	    if ( statement( symbol ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // switch_statement


static bool while_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( WHILE ) ) {
	if ( condition() ) {
	    if ( statement( symbol ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // while_statement


static bool do_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( DO ) ) {
	if ( statement( symbol ) ) {
	    if ( match( WHILE ) ) {
		if ( condition() ) {
		    if ( match( ';' ) ) {
			return true;
		    } // if
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // do_statement


static bool for_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( FOR ) ) {
	if ( condition( false ) ) {			// ignore semicolon
	    if( statement( symbol ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // for_statement


static bool string();
static bool exception_declaration();


static bool catch_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;

    if ( match( CATCH ) ) {
	if ( match( LP ) ) {
	    if ( exception_declaration() || match( DOT_DOT_DOT ) ) {
		if ( match( RP ) ) {
		    prefix = ahead;
		    if ( statement( symbol ) ) {
			gen_code( prefix, "{" );
			gen_code( prefix, "uThisCoroutine ( ) . uThrowEventCnt -= 1 ;" );
			gen_code( prefix, "uAEHM :: uThrowLock -> uRelease ( ) ;" );
			gen_code( ahead, "uAEHM :: uThrowLock -> uAcquire ( ) ;" );
			gen_code( ahead, "}" );
			return true;
		    } // if
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // catch_statement


static bool resume_handler( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *befparn;
    token_t *startE;
    token_t *endE;
    token_t *startH;
    token_t *endH;
    token_t *startC;
    token_t *endC;

    befparn = ahead;
    if ( match( LA ) ) {
	befparn->value = LC;				// change '<' into '{'
	befparn->hash = hash_table->look( "{" );
//	gen_code( befparn, "uHandlerClause" );
	gen_code( ahead, "( void * ) &" );
	startE = ahead;
	for ( ;; ) {
	  if ( eof() ) goto fini;
	  if ( check( ';' ) ) goto fini;
	  if ( check( LC ) ) goto fini;
	  if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	  if ( check( RA ) ) break;
	  if ( check( ',' ) ) break;
	    scan();
	} // for
	if ( startE == ahead ) goto fini;
	endE = ahead;
	gen_code( endE, ":: uId" );
//	endE = endE->aft;				// ignore added text
	if ( match( ',' ) ) {
	    startH = ahead;
	    for ( ;; ) {
	      if ( eof() ) goto fini;
	      if ( check( ';' ) ) goto fini;
	      if ( check( LC ) ) goto fini;
	      if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	      if ( check( RA ) ) break;
	      if ( check( ',' ) ) break;
		scan();
	    } // for
	    if ( startH == ahead ) goto fini;
	    endH = ahead;
	    if ( match( ',' ) ) {
		startC = ahead;
		for ( ;; ) {
		  if ( eof() ) goto fini;
		  if ( check( ';' ) ) goto fini;
		  if ( check( LC ) ) goto fini;
		  if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
		  if ( check( RA ) ) break;
		    scan();
		} // for
		if ( startC == ahead ) goto fini;
		endC = ahead;
		gen_code( startH, "( void * ) (" );
//		int i = 0;
//		token_t *p;
//		for ( p = startE; i < 10 && p != endE; i += 1, p = p->fore ) {
//		    token_t *token = new token_t( p->value, p->hash );
//		    token->add_token_before( *startH );
//		} // for
//		gen_code( startH, "& , typeof (" );
//		for ( p = startC; i < 10 && p != endC; i += 1, p = p->fore ) {
//		    token_t *token = new token_t( p->value, p->hash );
//		    token->add_token_before( *startH );
//		} // for
//		gen_code( startH, ") & ) = (" );
		gen_code( endH, ")" );
		gen_code( startC, "& (" );
		gen_code( endC, ")" );
	    } else {
		gen_code( startH, "( void * ) (" );
//		int i = 0;
//		for ( token_t *p = startE; i < 10 && p != endE; i += 1, p = p->fore ) {
//		    token_t *token = new token_t( p->value, p->hash );
//		    token->add_token_before( *startH );
//		} // for
		gen_code( endH, ") , ( const uAEHM :: uClosure * const ) 0" );
	    } // if
	} else {
	    gen_code( endE, ", ( void * ) 0 , ( const uAEHM :: uClosure * const ) 0" );
	} // if
	befparn = ahead;
	match( RA );					// match closing '>'
	befparn->value = RC;				// change '>' into '}'
	befparn->hash = hash_table->look( "}" );
	return true;
      fini:
	gen_error( befparn, "parse error, incorrectly formed resume clause" );
    } // if

    ahead = back; return false;
} // resume_handler


static bool try_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    int resume_clauses = 0, catch_clauses = 0;

    prefix = ahead;
    if ( match( TRY ) ) {
	gen_code( prefix, "{ bool __U_Throw_Flag__ = true ;" );
	prefix = ahead;
	gen_code( prefix, "{" );
	if ( resume_handler( symbol ) ) {
	    gen_code( prefix->prev_parse_token(), "{ uAEHM :: uHandlerClause uFixed_name1 [ ] =" );
	    do {
		resume_clauses += 1;
		gen_code( ahead, "," );
	    } while ( resume_handler( symbol ) );
	    gen_code( ahead, "} ; uAEHM :: uResumptionHandlers uFixed_name2 ( uFixed_name1 ," );
	    char buffer[20];
	    sprintf( buffer, "%d", resume_clauses );
	    gen_code( ahead, buffer );
	    gen_code( ahead, ") ;" );
	} // if
	if ( statement( symbol ) ) {
	    gen_code( ahead, "__U_Throw_Flag__ = false ; }" );
	    while ( catch_statement( symbol ) ) catch_clauses += 1;
	    if ( resume_clauses != 0 && catch_clauses == 0 ) {
		// catch clause required, so create dummy clause
		gen_code( ahead, "catch ( uAEHM :: uHandlerClause ) { }" );
	    } // if
	    gen_code( ahead, "if ( __U_Throw_Flag__ ) uAEHM :: uThrowLock -> uRelease ( ) ; }" );
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // try_statement


static bool throw_statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( THROW ) ) {
	// look for the end of the statement

	for ( ;; ) {
	  if ( eof() ) break;
	    if ( match( ';' ) ) {
		return true;
	    } // if
	    scan();
	} // for
    } // if

    ahead = back; return false;
} // throw_statement


static bool uthrow_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( UTHROW ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {					// look for the end of the statement
	  if ( eof() ) break;
	    if ( match( AT ) ) {
		suffix = ahead;
		gen_uthrow_uat_prefix( prefix, suffix );
		prefix = ahead;
		for ( ;; ) {
		  if ( eof() ) break;
		    if ( match( ';' ) ) {
			suffix = ahead->prev_parse_token();
			if ( prefix == suffix ) {
			    gen_error( suffix, "parse error, expected task value after uAt" );
			    goto fini;
			} // if
			gen_uthrow_suffix( suffix );
			return true;
		    } // if
		    scan();
		} // for
	    } // if
	    if ( match( ';' ) ) {
		suffix = ahead->prev_parse_token();
		if ( prefix == suffix ) {		// rethrow ?
		    gen_code( suffix,
			      "{ "
			      "uThisCoroutine ( ) . uThrowEventCnt += 1 ; "
			      "uAEHM :: uThrowLock -> uAcquire ( ) ; "
			      "throw ; }" );
		} else {
		    gen_uthrow_prefix( prefix, suffix );
		    gen_uthrow_suffix( suffix );
		} // if
		return true;
	    } // if
	    scan();
	} // for
    } // if
  fini:
    ahead = back; return false;
} // uthrow_statement


static bool sync_raise_statement() {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( RAISE ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {
	  if ( eof() ) goto fini;
	  if ( match( LP ) && ! match_closing( LP, RP ) ) goto fini;
	  if ( check( ';' ) ) break;
	  if ( check( ',' ) ) break;
	  if ( check( RP ) ) break;
	    scan();
	} // for
	suffix = ahead;
	gen_raise_prefix( prefix, suffix );
	gen_raise_suffix( suffix );
	return true;
      fini:
	gen_error( prefix, "parse error, expected exception value after uRaise" );
    } // if

    ahead = back; return false;
} // sync_raise_statement


static bool async_raise_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    token_t *suffix;

    if ( match( RAISE ) ) {
	prefix = ahead;					// remember where to put the prefix

	for ( ;; ) {					// look for the end of the statement
	  if ( eof() ) break;
	    if ( match( AT ) ) {
		suffix = ahead;
		gen_raise_uat_prefix( prefix, suffix );
		prefix = ahead;
		for ( ;; ) {
		  if ( eof() ) break;
		    if ( match( ';' ) ) {
			suffix = ahead->prev_parse_token();
			if ( prefix == suffix ) {
			    gen_error( suffix, "parse error, expected task value after uAt" );
			    goto fini;
			} // if
			gen_raise_suffix( suffix );
			return true;
		    } // if
		    scan();
		} // for
	    } // if
	    if ( match( ';' ) ) {
		suffix = ahead->prev_parse_token();
		if ( prefix == suffix ) {
		    gen_error( suffix, "parse error, expected exception value after uRaise" );
		    goto fini;
		} // if
		gen_raise_prefix( prefix, suffix );
		gen_raise_suffix( suffix );
		return true;
	    } // if
	    scan();
	} // for
    } // if
  fini:
    ahead = back; return false;
} // async_raise_statement


static bool event_handler( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *befparn;
    token_t *startE;
    token_t *endE;

    befparn = ahead;
    if ( match( LA ) ) {
	gen_code( befparn, "( void * ) &" );
	befparn->value = LP;				// change '<' into '('
	befparn->hash = hash_table->look( "(" );
	startE = ahead;
	for ( ;; ) {
	  if ( eof() ) goto fini;
	  if ( check( ';' ) ) goto fini;
	  if ( check( LC ) ) goto fini;
	  if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	  if ( check( RA ) ) break;
	    scan();
	} // for
	if ( startE == ahead ) goto fini;
	endE = ahead;
	gen_code( endE, ":: uId" );
	endE = endE->aft;				// ignore added text
	befparn = ahead;
	match( RA );					// match closing '>'
	befparn->value = RP;				// change '>' into ')'
	befparn->hash = hash_table->look( ")" );
	return true;
      fini:
	gen_error( befparn, "parse error, incorrectly formed uEnable/uDisable clause" );
    } // if

    ahead = back; return false;
} // event_handler


static bool disable_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    int event_clauses = 0;

    if ( match( DISABLE ) ) {
	prefix = ahead;
	gen_code( prefix->prev_parse_token(), "{" );
	if ( event_handler( symbol ) ) {
	    gen_code( prefix->prev_parse_token(), "static void * uEventTable [ ] = {" );
	    do {
		event_clauses += 1;
		gen_code( ahead, "," );
	    } while ( event_handler( symbol ) );
	    gen_code( ahead, "} ; uAEHM :: uDeliverAEStack uNoName ( false, uEventTable ," );
	    char buffer[20];
	    sprintf( buffer, "%d", event_clauses );
	    gen_code( ahead, buffer );
	    gen_code( ahead, ") ;" );
	} else {
	    gen_code( ahead, "uAEHM :: uDeliverAEStack uNoName ( false ) ;" );
	} // if
	if ( statement( symbol ) ) {
	    gen_code( ahead, "}" );
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // disable_statement


static bool enable_statement( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *prefix;
    int event_clauses = 0;

    if ( match( ENABLE ) ) {
	prefix = ahead;
	gen_code( prefix->prev_parse_token(), "{" );
	if ( event_handler( symbol ) ) {
	    gen_code( prefix->prev_parse_token(), "static void * uEventTable [ ] = {" );
	    do {
		event_clauses += 1;
		gen_code( ahead, "," );
	    } while ( event_handler( symbol ) );
	    gen_code( ahead, "} ; uAEHM :: uDeliverAEStack uNoName ( true, uEventTable ," );
	    char buffer[20];
	    sprintf( buffer, "%d", event_clauses );
	    gen_code( ahead, buffer );
	    gen_code( ahead, ") ;" );
	} else {
	    gen_code( ahead, "uAEHM :: uDeliverAEStack uNoName ( true ) ;" );
	} // if
	if ( statement( symbol ) ) {
	    gen_code( ahead, "}" );
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // enable_statement


static bool object_declaration();


static bool statement( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( wait_statement( symbol ) ) return true;
    if ( signal_statement( symbol ) ) return true;
    if ( signalblock_statement( symbol ) ) return true;
    if ( resume_statement( symbol ) ) return true;
    if ( suspend_statement( symbol ) ) return true;
    if ( accept_statement( NULL, false, NULL, symbol ) ) return true;
    if ( disable_statement( symbol ) ) return true;
    if ( enable_statement( symbol ) ) return true;
    if ( labeled_statement( symbol ) ) return true;
    if ( compound_statement( symbol ) ) return true;
    if ( if_statement( symbol ) ) return true;
    if ( switch_statement( symbol ) ) return true;
    if ( case_statement( symbol ) ) return true;
    if ( default_statement( symbol ) ) return true;
    if ( while_statement( symbol ) ) return true;
    if ( do_statement( symbol ) ) return true;
    if ( for_statement( symbol ) ) return true;

    if ( try_statement( symbol ) ) return true;
    if ( throw_statement( symbol ) ) return true;
    if ( uthrow_statement( symbol ) ) return true;
    if ( async_raise_statement( symbol ) ) return true;

    if ( object_declaration() ) return true;

    // handles statements currently are not parsed: expression, break,
    // continue, goto, and return

    for ( ;; ) {
      if ( eof() ) break;
	sync_raise_statement();
	if ( match( ';' ) ) return true;
	if ( compound_statement( symbol ) ) return true;
	if ( check( RC ) ) return false;
	scan();
    } // for

    ahead = back; return false;
} // statement


static unsigned int access_specifier() {
    token_t *back = ahead;

    if ( match( PRIVATE ) ) return PRIVATE;
    if ( match( PROTECTED ) ) return PROTECTED;
    if ( match( PUBLIC ) ) return PUBLIC;

    ahead = back; return 0;
} // access_specifier


static token_t *base_specifier( unsigned int &access ) {
    token_t *back = ahead;
    token_t *base;

    if ( ( base = type() ) != NULL ) {
	access = PRIVATE;				// default
	return base;
    } else if ( match( VIRTUAL ) ) {
	access = access_specifier();
	if ( ( base = type() ) != NULL ) {
	    return base;
	} // if
    } else if ( ( access = access_specifier() ) != 0 ) {
	match( VIRTUAL );
	if ( ( base = type() ) != NULL ) {
	    return base;
	} // if
    } // if

    ahead = back; return NULL;
} // base_specifier


static bool base_specifier_list( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *token;
    symbol_t *base;
    unsigned int access;

    assert( symbol != NULL );

    if ( ( token = base_specifier( access ) ) != NULL && symbol != token->symbol ) { // prevent inheriting from oneself, e.g. class x : public x
	assert( token != NULL );
	base = token->symbol;
	assert( base != NULL );

	// classes (not mutex), structs, unions may have protected and private
	// inheritance from any kind of type constructor.

	if ( ( ( base->key == CLASS && base->index == DESTRUCTORPOSN ) || base->key == STRUCT || base->key == UNION ) && access != PUBLIC ) {
	    //
	} else {
	    // copy the left and right template delimiters from the scanned token
	    // to the base symbol

	    base->left = token->left;
	    base->right = token->right;

	    if ( base->key == 0 ) {
		char msg[strlen(base->hash->text) + strlen(symbol->hash->text) + 100];

		sprintf( msg, "unsupported use of typedef \"%s\" as base type", base->hash->text );
		gen_error( ahead, msg );
	    } else {
		// check that base kind only inherits from appropriate derived kind

		if ( ( ( symbol->key == COROUTINE && base->key != COROUTINE ) || ( symbol->key == TASK && base->key != TASK ) ||
		     ( symbol->key == DUALEVENT   && base->key != DUALEVENT ) || ( symbol->key == THROWEVENT && base->key != THROWEVENT ) ||
		     ( symbol->key == RAISEEVENT  && base->key != RAISEEVENT ) ) || access != PUBLIC ) {
		    char msg[strlen(base->hash->text) + strlen(symbol->hash->text) + 100];

		    if ( access != PUBLIC ) {
			sprintf( msg, "non-public inheritance disallowed between the base kind for \"%s\" and the derived kind for \"%s\"",
				base->hash->text, symbol->hash->text);
		    } else {
			sprintf( msg, "the base kind for \"%s\" is incompatible with the derived kind for \"%s\"",
				base->hash->text, symbol->hash->text);
		    } // if
		    gen_error( ahead, msg );
		} else {
		    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) ||
			 ( symbol->key == DUALEVENT ) || ( symbol->key == RAISEEVENT ) || ( symbol->key == THROWEVENT ) ) {
			if ( symbol->base != NULL ) {
			    gen_error( ahead, "multiple inheritance disallowed for this kind" );
			} else {
			    symbol->base = base;
			} // if
		    } else {
			if ( base->index != DESTRUCTORPOSN ) {	// mutex class
			    if ( symbol->base != NULL ) {
				gen_error( ahead, "can inherit from at most one mutex class" );
			    } else {
				symbol->base = base;
			    } // if
			} else {
			    // set the base class for this derived class. there
			    // should be a list of these to handle multiple
			    // inheritance, but MH is bad news, so ignore it
			    // for now.

			    symbol->base = base;
			} // if
		    } // if

		    // inherit the number of mutex members defined in the base class so
		    // that new mutex members in the derived class are numbered correctly

		    assert( symbol != NULL );
		    assert( base != NULL );
		    symbol->index = base->index;
		} // if
	    } // if
	} // if
	
	if ( match( ',' ) ) {
	    if ( base_specifier_list( symbol ) ) {
		return true;
	    } // if
	} else {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // base_specifier_list


static bool class_base( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( ':' ) ) {
	base_specifier_list( symbol );

	// make sure base_specifier_list terminates with one of ';', '{', or
	// EOF before continuing parse.

	while ( ! check( ';' ) && ! check( LC ) && ! eof() ) {
	    scan();
	} // while
	return true;
    } // if

    ahead = back; return false;
} // class_base


static bool mutex_parameter_list( attribute_t &attribute );


static int class_key( attribute_t &attribute ) {
    token_t *back = ahead;

    if ( match( CLASS ) ) return CLASS;
    if ( match( STRUCT ) ) return STRUCT;
    if ( match( UNION ) ) return UNION;

    if ( match( COROUTINE ) ) {
	gen_class( ahead );
	return COROUTINE;
    } // if

    if ( match( TASK ) ) {
	gen_class( ahead );
	if ( check( LA ) ) mutex_parameter_list( attribute );
	return TASK;
    } // if

    if ( match( PTASK ) ) {
	gen_class( ahead );
	attribute.value2 |= PERIODIC_ATTRIBUTE;
	if ( check( LA ) ) mutex_parameter_list( attribute );
	return TASK;
    } // if

    if ( match( RTASK ) ) {
	gen_class( ahead );
	attribute.value2 |= APERIODIC_ATTRIBUTE;
	if ( check( LA ) ) mutex_parameter_list( attribute );
	return TASK;
    } // if

    if ( match( STASK ) ) {
	gen_class( ahead );
	attribute.value2 |= SPORADIC_ATTRIBUTE;
	if ( check( LA ) ) mutex_parameter_list( attribute );
	return TASK;
    } // if

    if ( match( DUALEVENT ) ) {
	gen_class( ahead );
	return DUALEVENT;
    } // if

    if ( match( RAISEEVENT ) ) {
	gen_class( ahead );
	return RAISEEVENT;
    } // if

    if ( match( THROWEVENT ) ) {
	gen_class( ahead );
	return THROWEVENT;
    } // if

    ahead = back; return 0;
} // class_key


static void make_type( token_t *token, symbol_t *symbol ) {
    assert( token != NULL );
    assert( symbol != NULL );

    if ( symbol->found == top ) {
	// if the symbol already exists in the current symbol table as an
	// identifier, make it a type

	token->value = symbol->value = TYPE;
    } else {
	if ( symbol->found != NULL ) {
	    // if the symbol exists in some other symbol table, make a copy of
	    // the symbol

	    token->symbol = symbol = new symbol_t( symbol->value, symbol->hash );
	} // if

	// change the token and symbol value to type

	token->value = symbol->value = TYPE;

	// insert the symbol into the current symbol table

	top->insert_table( symbol );
    } // if
} // make_type


static bool template_parameter( attribute_t &attribute ) {
    token_t *back = ahead;
    int ckey;
    token_t *token;
    symbol_t *symbol;

    if ( ( ckey = class_key( attribute ) ) != 0 ) {
	// if a class key is found

	if ( ( token = identifier() ) != NULL ) {
	    assert( token != NULL );
	    symbol = token->symbol;

	    // change the token's and symbol's value to TYPE

	    if ( symbol->found == top ) {
		// if the symbol already exists in the current symbol table as
		// an identifier, make it a type

		token->value = symbol->value = TYPE;
	    } else {
		if ( symbol->found != NULL ) {
		    // if the symbol exists in some other symbol table, make a
		    // copy of the symbol

		    token->symbol = symbol = new symbol_t( symbol->value, symbol->hash );
		} // if

		// change the token and symbol value to type

		token->value = symbol->value = TYPE;

		// insert the symbol into the current symbol table

		attribute.plate->insert_table( symbol );
	    } // if

	    // set the symbol's class key to the class key

	    symbol->key = ckey;
	} else if ( ( token = type() ) != NULL ) {
	    // if a type token is found, grab the symbol associated with the
	    // token and prepare to do some analysis

	    symbol = token->symbol;
	    assert( symbol != NULL );

	    if ( symbol->found == attribute.plate ) {
		// if the symbol already exists in the current symbol table as
		// a type, verify that its kind is the same as the previous
		// definition

		char msg[strlen(symbol->hash->text) + 100];

		if ( symbol->key != ckey ) {
		    // struct and class are equivalent for prototype
		    if ( ! ( symbol->key == STRUCT && ckey == CLASS || symbol->key == CLASS && ckey == STRUCT ) ) {
			sprintf( msg, "\"%s\" redeclared with different kind", symbol->hash->text );
			gen_error( ahead, msg );
		    } // if
		} // if
	    } else {
		if ( symbol->found != NULL ) {
		    // if the symbol exists in some other symbol table make a
		    // new symbol for the current symbol table

		    token->symbol = symbol = new symbol_t( token->value, token->hash );
		} // if

		// set the symbol's class to the class key

		symbol->key = ckey;

		// insert the symbol into the template symbol 

		attribute.plate->insert_table( symbol );
	    } // if
	} // if

	// scan off any initialization value.

	if ( match( '=' ) ) {
	    for ( ;; ) {
	      if ( eof() ) break;
	      if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	      if ( check( ',' ) ) break;
	      if ( check( RA ) ) break;
		scan();
	    } // for
	} // if

	return true;
    } else if ( ! check( RA ) ) {
	// template arguments come in two forms.  the first type of arguments
	// are always prefixed by a class key and introduces a new type into
	// the definition of the class. this is handled by the first clause in
	// this if statement.  the second form of arguments do not introduce
	// new types, and the translator can simply eat them up without
	// interpreting them.  that is what occurs in this second clause.

	for ( ;; ) {
	  if ( eof() ) break;
	  if ( check( ',' ) ) break;
	  if ( check( RA ) ) break;
	    scan();
	} // for

	return true;
    } // if
  fini: ;
    ahead = back; return false;
} // template_parameter


static bool template_parameter_list( attribute_t &attribute ) {
    token_t *back = ahead;

    attribute.plate = new table_t( NULL );

    if ( template_parameter( attribute ) ) {
	while ( match( ',' ) ) {
	    template_parameter( attribute );
	} // while
	return true;
    } // if

    delete attribute.plate;
    attribute.plate = NULL;

    ahead = back; return false;
} // template_parameter_list


static bool mutex_parameter_list( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *startE;
    token_t *startM;
    token_t *endM;

    startE = ahead;
    if ( match( LA ) ) {
	for ( ;; ) {
	  if ( eof() ) goto fini;
	  if ( check( ';' ) ) goto fini;
	  if ( check( LC ) ) goto fini;
	  if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	  if ( check( RA ) ) break;
	  if ( check( ',' ) ) break;
	    scan();
	} // for
	if ( startE == ahead ) goto fini;
	startM = ahead;
	if ( match( ',' ) ) {
	    for ( ;; ) {
	      if ( eof() ) goto fini;
	      if ( check( ';' ) ) goto fini;
	      if ( check( LC ) ) goto fini;
	      if ( match( LA ) && ! match_closing( LA, RA ) ) goto fini;
	      if ( check( RA ) ) break;
	      if ( check( ',' ) ) break;
		scan();
	    } // for
	    if ( startM == ahead ) goto fini;
	    endM = ahead;
	    match( RA );				// match closing '>'
	    attribute.startE = startE;
	    attribute.startM = startM;
	    attribute.endM = endM;
	    return true;
	} // if
      fini:
	gen_error( startE, "parse error, incorrectly formed mutex qualifier" );
    } // if

    ahead = back; return false;
} // mutex_parameter_list


static bool type_qualifier( attribute_t &attribute ) {
    token_t *back = ahead;

    if ( match( AUTO ) ) return true;
    if ( match( REGISTER ) ) return true;
    if ( match( STATIC ) ) return true;
    if ( match( EXTERN ) ) return true;
    if ( match( MUTABLE ) ) return true;

    if ( match( EXTENSION ) ) return true;		// gcc specific

    if ( match( INLINE ) ) return true;
    if ( match( VIRTUAL ) ) return true;
    if ( match( EXPLICIT ) ) return true;

    if ( match( CONST ) ) return true;
    if ( match( VOLATILE ) ) return true;

    if ( match( FRIEND ) ) { attribute.value1 |= FRIEND_ATTRIBUTE; return true; }
    if ( match( TYPEDEF ) ) { attribute.value1 |= TYPEDEF_ATTRIBUTE; return true; }

    if ( match( MUTEX ) ) {
	attribute.value |= MUTEX_ATTRIBUTE;
	if ( check( LA ) ) mutex_parameter_list( attribute );
	return true;
    } // if

    if ( match( NOMUTEX ) ) { attribute.value |= NOMUTEX_ATTRIBUTE; return true; }

    ahead = back; return false;
} // type_qualifier


static bool template_qualifier( attribute_t &attribute ) {
    token_t *back = ahead;

    match( EXPORT );					// optional export clause

    if ( match( TEMPLATE ) ) {
	match( LA );
	template_parameter_list( attribute );
	match( RA );
	return true;
    } // if

    ahead = back; return false;
} // template_qualifier


static token_t *class_head( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;
    int key;
    symbol_t *symbol;

    if ( ( key = class_key( attribute ) ) != 0 ) {
	if ( attribute.value1 & FRIEND_ATTRIBUTE ) {	// friend declarations are ignored
	    return NULL;
	} // if

	// if a class key is found

	if ( ( token = identifier() ) != NULL ) {
	    assert( token != NULL );
	    symbol = token->symbol;

	    // change the token's and symbol's value to TYPE

	    make_type( token, symbol );

	    // set the symbol's class key to the class key

	    symbol->key = key;
	} else if ( ( token = type() ) != NULL ) {
	    // if a type token is found, grab the symbol associated with the
	    // token and prepare to do some analysis

	    symbol = token->symbol;
	    assert( symbol != NULL );

	    if ( ( symbol->found == top ) || ( symbol == top->symbol ) ) {
		// if the symbol already exists in the current symbol table as
		// a type, verify that its kind is the same as the previous
		// definition

		char msg[strlen(symbol->hash->text) + 100];
		if ( symbol->key != key ) {
		    // struct and class are equivalent for prototype
		    if ( ! ( symbol->key == STRUCT && key == CLASS || symbol->key == CLASS && key == STRUCT ) ) {
			sprintf( msg, "\"%s\" redeclared with different kind", symbol->hash->text );
			gen_error( ahead, msg );
		    } // if
		} // if
	    } else {
		// look ahead for forward declaration ?
		if ( ! check( ':' ) && ! check( LC ) ) {
		    // look ahead for old style C struct declarations.
		    if ( ( symbol->key == STRUCT || symbol->key == UNION ) && ( ! check( ';' ) || check( ')' ) ) ) return token;

		    if ( symbol->found != NULL ) {
			// if the symbol exists in some other symbol table make a
			// new symbol for the current symbol table

			token->symbol = symbol = new symbol_t( token->value, token->hash );
		    } // if

		    // insert the symbol into the current symbol table

		    top->insert_table( symbol );

		    // set the symbol's class to the class key

		    symbol->key = key;
		} // if
	    } // if

//	    if ( ( symbol->found == top ) || ( symbol == top->symbol ) ) {
//		// if the symbol already exists in the current symbol table as
//		// a type, verify that its kind is the same as the previous
//		// definition
//
//		char msg[strlen(symbol->hash->text) + 100];
//		if ( symbol->key != key ) {
//		    // struct and class are equivalent for prototype
//		    if ( ! ( symbol->key == STRUCT && key == CLASS || symbol->key == CLASS && key == STRUCT ) ) {
//			sprintf( msg, "\"%s\" redeclared with different kind", symbol->hash->text );
//			gen_error( ahead, msg );
//		    } // if
//		} // if
//	    } else {
//		if ( symbol->found != NULL ) {
//		    // if the symbol exists in some other symbol table make a
//		    // new symbol for the current symbol table
//
//		    token->symbol = symbol = new symbol_t( token->value, token->hash );
//		} // if
//
//		// set the symbol's class to the class key
//
//		symbol->key = key;
//
//		// insert the symbol into the current symbol table
//
//		top->insert_table( symbol );
//	    } // if
	} else {
	    // don't generate anonymous types, if they don't use a tag on the
	    // type, then we can't generated one because the order of includes
	    // may cause us to generated different tag names for different
	    // compilations.  if the user declares an anonymous coroutine or
	    // task, this will fail.  solution?  don't do that!

	    token = new token_t( TYPE, hash_table->look( "" ) );

	    // insert this token into the token stream

	    token->add_token_before( *ahead );

	    // create a symbol that must accompany this token as a type

	    token->symbol = symbol = new symbol_t( token->value, token->hash );

	    // insert the symbol into the current symbol table

	    top->insert_table( symbol );

	    if ( key == COROUTINE || key == TASK ) {
		gen_error( ahead, "cannot create anonymous coroutine or task because of the need for named constructors and destructors" );

		// By making this type look like a class, it will not generate
		// additional bogus tokens that might cause problems later on.

		symbol->key = CLASS;
	    } else {
		symbol->key = key;
	    } // if
	} // if

	// save a pointer to the next token so that if we have to insert a base
	// class definition later, we can do it

	symbol->base_token = ahead;
	class_base( symbol );

	// add the attribute to the symbol

	symbol->attribute = attribute;

	return token;
    } // if

    ahead = back; return NULL;
} // class_head


static bool access_declaration() {
    token_t *back = ahead;
    unsigned int access;

    if ( ( access = access_specifier() ) != 0 ) {
	if ( match( ':' ) ) {
	    // modify the access privileges of member functions added to the
	    // symbol table after this point

	    assert( top != NULL );
	    top->access = access;

	    return true;
	} // if
    } // if

    ahead = back; return false;
} // access_declaration


static bool member_module() {
    token_t *back = ahead;

    if ( access_declaration() ) return true;
    if ( object_declaration() ) return true;

    ahead = back; return false;
} // member_module


static bool class_specifier( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *clss;
    table_t *table;
    symbol_t *symbol;

    if ( ( clss = class_head( attribute ) ) != NULL ) {
	symbol = clss->symbol;

	// check that only one of the mutex attributes is specified

	if ( ( attribute.value & MUTEX_ATTRIBUTE ) && ( attribute.value & NOMUTEX_ATTRIBUTE ) ) {
	    gen_error( ahead, "may not specify both uMutex and uNoMutex attributes for a class" );
	} // if

	// compute the attribute of this class based on explicit specification
	// and default rules

	assert( symbol != NULL );
	if ( ( attribute.value & MUTEX_ATTRIBUTE ) || ( attribute.value & NOMUTEX_ATTRIBUTE ) ) {
	    symbol->attribute.value = attribute.value;
	} else {
	    if ( symbol->key == TASK ) {
		symbol->attribute.value = MUTEX_ATTRIBUTE;
	    } else {
		symbol->attribute.value = NOMUTEX_ATTRIBUTE;
	    } // if
	} // if

	if ( symbol->attribute.value == MUTEX_ATTRIBUTE && attribute.startE != NULL ) {
	    symbol->attribute.startE = attribute.startE;
	    symbol->attribute.startM = attribute.startM;
	    symbol->attribute.endM = attribute.endM;
	} // if

	// check for a {, don't match because a symbol table has to be built
	// before scanning the next token, which may be an identifier

	if ( check( LC ) ) {
	    // define the base class only if this is a class definition

	    if ( symbol->base == NULL ) {
		gen_class_base( symbol->base_token, symbol );
	    } // if

	    if ( symbol->attribute.plate != NULL ) {
		// use the template table as the symbol table for this class

		symbol->table = table = symbol->attribute.plate;

		// link the symbol and table together because it was not
		// originally done when the template table was created because
		// the class symbol was not yet known.

		table->symbol = symbol;
	    } else {
		// create a new symbol table

		symbol->table = table = new table_t( symbol );
	    } // if

	    table->push_table();

	    // set the search path to the current lexical context (table).

	    assert( symbol != NULL );
	    table->search = symbol->found;

	    table->access = PRIVATE;
	    table->defined = false;

	    // now scan passed the '{' for the next token

	    scan();

	    // generate the class prefix stuff

	    gen_class_prefix( ahead, symbol );

	    while ( member_module() );

	    table->defined = true;
	    table->access = PRIVATE;

	    gen_class_suffix( ahead, symbol );

	    match( RC );

	    pop_table();
	} // if

	return true;
    } else {
	if ( attribute.value1 & FRIEND_ATTRIBUTE ) {	// friend declarations are ignored
	    attribute.value1 &= ~FRIEND_ATTRIBUTE;
	    while ( ! check( ';' ) && ! eof() ) {
		scan();
	    } // while
	    return true;
	} // if
    } // if
  fini:
    ahead = back; return false;
} // class_specifier


static bool enumerator() {
    token_t *back = ahead;

    if ( identifier() ) {
	for ( ;; ) {
	    if ( eof() ) return false;
	  if ( check( ',' ) ) break;
	  if ( check( RC ) ) break;
	    scan();
        } // for
	return true;
    } // if

    ahead = back; return false;
} // enumerator


static bool enumerator_list() {
    token_t *back = ahead;

    if ( enumerator() ) {
	if ( match( ',' ) ) {
	    if ( enumerator_list() ) {
		return true;
	    } else {
		return true;
	    } // if
	} else {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // enumerator_list


static bool enumerator_specifier() {
    token_t *back = ahead;
    token_t *token;

    if ( match( ENUM ) ) {
	if ( ( token = identifier() ) != NULL ) {
	    make_type( token, token->symbol );
	} else if ( type() ) {
	} // if

	if ( match( LC ) ) {
	    enumerator_list();
	    if ( match( RC ) ) {
		return true;
	    } // if
	} else {
	    return true;
	} // if

    } // if

    ahead = back; return false;
} // enumerator_specifier


static bool specifier( attribute_t &attribute, bool &rt );


static bool formal_parameter_empty( attribute_t &attribute ) {
    token_t *back = ahead;

    if ( match( RP ) ) { attribute.emptyparms = true; return true; }
    if ( match( VOID ) && match( RP ) ) { attribute.emptyparms = true; return true; }

    ahead = back; return false;
} // formal_parameter_empty


static bool formal_parameter( attribute_t &attribute ) {
    token_t *back = ahead;

    if ( match( LP ) ) {
	if ( formal_parameter_empty( attribute ) ) return true;

	// Quick check to determine if this is a formal parameter list by
	// looking at the first token. If the first token forms any part of a
	// parameter declaration, this must be a formal declaration context. If
	// the first token is a type name nested in a class containing this
	// member routine, the symbol table focus has to be correct. It should
	// have been set when the function name was looked up.

	bool rt = false;				// return type
	if ( specifier( attribute, rt ) || match( DOT_DOT_DOT ) ) {
	    // Having determined that that this construct is a formal argument
	    // list, simply scan for the closing parentheses.

	    if ( match_closing( LP, RP ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // formal_parameter


static bool pointer_qualifier() {
    token_t *back = ahead;

    if ( match( CONST ) ) return true;
    if ( match( VOLATILE ) ) return true;

    ahead = back; return false;
} // pointer_qualifier


static bool pointer() {
    token_t *back = ahead;

    if ( match( '*' ) || match( '&' ) ) {
	while ( pointer_qualifier() );
	return true;
    } else if ( type() != NULL ) {
	if ( match( COLON_COLON ) ) {
	    if ( match( '*' ) || match( '&' ) ) {
		while ( pointer_qualifier() );
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // pointer


static bool attribute_clause() {			// gcc attribute clause
    token_t *back = ahead;

    if ( match( ATTRIBUTE ) ) {
	if ( match( LP ) ) {
	    if ( match_closing( LP, RP ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // attribute_clause


static bool asm_clause() {				// gcc asm clause
    token_t *back = ahead;

    if ( match( ASM ) ) {
	if ( match( LP ) ) {
	    if ( match_closing( LP, RP ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // asm_clause


static bool cv_qualifier_list() {
    while ( match( CONST ) || match( VOLATILE ) || attribute_clause() || asm_clause() );
    return true;
} // cv_qualifier_list


static bool exception_list() {
    token_t *back = ahead;

    if ( match( THROW ) ) {
	if ( match( LP ) ) {
	    if ( match_closing( LP, RP ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // exception_list


static bool more_declarator( attribute_t &attribute ) {
    token_t *back = ahead;

    if ( match( LB ) ) {				// array declarator
	for ( ;; ) {
	    if ( eof() ) return false;
	  if ( check( RB ) ) break;
	    scan();
	} // for
	if ( match( RB ) ) {
	    more_declarator( attribute );
	    return true;
	} // if
    } else if ( formal_parameter( attribute ) ) {	// function declarator
	cv_qualifier_list();
	more_declarator( attribute );
	return true;
    } else if ( match( ':' ) ) {			// bit slice declarator
	if ( match( NUMBER ) ) {			// should really be constant expression
	    return true;
	} // if
    } else if (	exception_list() ) {			// optional exception list
	return true;
    } else if (	attribute_clause() ) {			// gcc attribute clause
	return true;
    } // if

    ahead = back; return false;
} // more_declarator


static token_t *declarator( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;

    if ( match( LP ) ) {
	if ( ( token = declarator( attribute ) ) != NULL ) {
	    if ( match( RP ) ) {
		more_declarator( attribute );
		return token;
	    } // if
	} // if
    } else if ( pointer() ) {
	if ( ( token = declarator( attribute ) ) != NULL ) {
	    more_declarator( attribute );
	    return token;
	} // if
    } else if ( ( token = identifier() ) != NULL ) {
	if ( token->symbol->found != NULL && token->symbol->found != global ) {	// if the identifier is in a nested scope
	    focus = token->symbol->found;		// establish that scope for name lookup in identifying a formal parameter list
	} // if
	more_declarator( attribute );
	return token;
    } else if ( ( token = type() ) != NULL ) {
	if ( token->symbol->found != NULL && token->symbol->found != global ) {	// if the identifier is in a nested scope
	    focus = token->symbol->found;		// establish that scope for name lookup in identifying a formal parameter list
	} // if
	more_declarator( attribute );
	return token;
    } else if ( ( token = operater() ) != NULL ) {
	if ( token->symbol->found != NULL && token->symbol->found != global ) {	// if the identifier is in a nested scope
	    focus = token->symbol->found;		// establish that scope for name lookup in identifying a formal parameter list
	} // if
	more_declarator( attribute );
	return token;
    } else if ( match( ':' ) ) {			// anonymous bit slice declarator
	if ( match( NUMBER ) ) {			// should really be constant expression
	    return new token_t( IDENTIFIER, hash_table->look( "" ) );
	} // if
//    } else if ( more_declarator( attribute ) ) {
//	// attempt to cope with what look like abstract declarators because the
//	// fool programmer was stupid enough to use a type where a variable was
//	// supposed to go.  its hard to tell when to stop looking at types in a
//	// declaration, because things like "int long" are okay, whereas "x y"
//	// where x and y are types is not okay.  sheesh.
//
//	return new token_t( IDENTIFIER, hash_table->look( "" ) );
    } // if

    ahead = back; return NULL;
} // declarator


static token_t *function_declarator( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;
    token_t *curr;
    unsigned int rp;
    unsigned int lp;

    if ( ( token = declarator( attribute ) ) != NULL ) {
	// if the token is not connected, that is, it must have been created as
	// a special, don't bother trying to look back and forth to see if it
	// is a function.  it isn't, and that will only cause segment faults.

	if ( ! token->connected() ) return NULL;

	// a declarator is a function declarator if the identifier associated
	// with the declarator binds most closely to the argument list
	// associated with the declarator.  to determine this, the parser looks
	// both forward and backward to determine if the argument list exists,
	// and if so, does the identifier bind to the argument list.

	curr = token->next_parse_token();
	rp = 0;
	for ( ;; ) {
	    if ( curr == ahead ) {
		break;
	    } // if
	    if ( curr->value == RP ) {
		rp += 1;
	    } // if
	    if ( curr->value == LP ) {
		curr = token;
		lp = 0;
		for ( ;; ) {
		    assert( curr != NULL );
		    if ( curr == back ) {
			return token;
		    } // if
		    if ( curr->value == LP ) {
			lp += 1;
		    } // if
		    if ( curr->value == '*' ) {
			if ( lp >= rp ) {
			    return token;
			} else {
			    return NULL;
			} // if
		    } // if
		    curr = curr->prev_parse_token();
		} // for
	    } // if
	    curr = curr->next_parse_token();
	} // for
    } // if

    ahead = back; return NULL;
} // function_declarator


static bool copy_constructor( const token_t *token ) {
    token_t *back = ahead;

    if ( token->symbol == NULL || token->symbol->table == NULL ) return false;

    if ( match( LP ) ) {
	while ( match( CONST ) || match( VOLATILE ) );	// eat up const and volatile specifiers
	if ( check( TYPE ) && ahead->symbol == token->symbol ) {
	    scan();
	    if ( match( '&' ) ) {			// looks good so far
		int commas = 0;				// if a copy constructor, every comma has a corresponding '=' after it
		int level = 1;
		match( IDENTIFIER );			// optional identifier
		for ( ;; ) {
		    if ( eof() ) {
			ahead = back;
			return false;
                    } else if ( match( ',' ) ) {
		        commas += 1;
		    } else if ( match( '=' ) ) {
			// ignore an '=' in something like X(X & a = b)
			if ( commas > 0 ) {
			    commas -= 1;
			} // if
		    } else if ( match( LP ) ) {		// match parentheses
			level += 1;
                    } else if ( match( RP ) ) {
			level -= 1;
			if ( level == 0 ) break;
                    } else
			scan();				// ignore everything else
                } // for
		if ( commas == 0 ) {
		    token->symbol->table->hascopy = true;
		    return true;
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // copy_constructor


static token_t *constructor_declarator( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;

    if ( ( token = type() ) != NULL ) {
	// constructors and destructors are not put in the symbol table.  the
	// class symbol table is the one set for further name look ups.

	if ( token->symbol->table != NULL ) {		// should be class symbol table for a constructor
	    focus = token->symbol->table;		// establish scope for name lookup in identifying a formal parameter list
	} // if

	if ( copy_constructor( token ) || formal_parameter( attribute ) ) {
	    return token;
	} // if
    } // if

    ahead = back; return NULL;
} // constructor_declarator


static token_t *destructor_declarator( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;

    if ( ( token = epyt() ) != NULL ) {
	if ( formal_parameter( attribute ) ) {		// should be empty
	    return token;
	} // if
    } // if

    ahead = back; return NULL;
} // destructor_declarator


static bool body( table_t *search, token_t *function, attribute_t &attribute, symbol_t *symbol ) {
    token_t *back = ahead;

    if ( check( LC ) ) {
	table_t *table;

	if ( attribute.plate != NULL ) {
	    table = attribute.plate;
	} else {
	    table = new table_t( NULL );
	} // if

	table->push_table();
	table->search = search;

	scan();

	if ( function ) {
	    if ( user &&
		 // Since these routines are used at boot time, they cannot be annotated.
		 strcmp( function->hash->text, "uDefaultHeapExpansion" ) != 0 &&
		 strcmp( function->hash->text, "uDefaultStackSize" ) != 0 &&
		 strcmp( function->hash->text, "uMainStackSize" ) != 0 &&
		 strcmp( function->hash->text, "uDefaultSpin" ) != 0 &&
		 strcmp( function->hash->text, "uDefaultPreemption" ) != 0
		) {
		if ( verify ) gen_verify( ahead );
		if ( Yield ) gen_yield( ahead );
	    } // if
	} // if

	while ( statement( symbol ) );
	delete pop_table();
	match(RC);
	return true;
    } // if

    ahead = back; return false;
} // body


static bool pure() {
    token_t *back = ahead;

    if ( match( '=' ) ) {
	if ( match( NUMBER ) ) {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // pure


static void make_mutex_class( symbol_t *clss ) {
    table_t *table;

    assert( clss != NULL );
    table = clss->table;
    assert( table != NULL );

    // If there are no mutex members, make the type mutex. Notice, a subtype
    // may find existing mutex members from the base type, and hence, does not
    // create declarations that appear in the root base type of the inheritance
    // chain.

    if ( clss->index == DESTRUCTORPOSN ) {
	gen_mutex( table->protected_area, clss );
	gen_mutex_entry( table->protected_area, clss );
	clss->index += 1;				// advance to next bit in the entry mask
    } // if
} // make_mutex_class


static void make_mutex_member( symbol_t *symbol ) {
    table_t *table;
    symbol_t *clss;

    assert( symbol != NULL );
    table = symbol->found;
    assert( table != NULL );
    clss = table->symbol;
    assert( clss != NULL );

    if ( clss->index == DESTRUCTORPOSN ) {
	make_mutex_class( clss );
    } // if

    if ( symbol->index == DESTRUCTORPOSN ) {
	symbol->index = clss->index;
	gen_mutex_entry( table->protected_area, symbol );
	clss->index += 1;				// advance to next bit in the entry mask
    } // if
} // make_mutex_member


// Constructs a string corresponding to the attribute.

static const char *attr_string( attribute_t &attribute ) {
    static char str[50];
    str[0] = '\0';					// start with a null string

    if ( attribute.value1 & TYPEDEF_ATTRIBUTE ) {
	strcat( str, " typedef" );
    } // if

    if ( attribute.value & MUTEX_ATTRIBUTE ) {
	strcat( str, " uMutex" );
    }  // if

    if ( attribute.value & NOMUTEX_ATTRIBUTE ) {
	strcat( str, " uNoMutex" );
    } // if

    if ( str[0] == '\0' ) {				// no attributes
	strcpy( str, " (none)" );
    } //if

    return &str[1];					// remove leading blank
} // attr_string


static bool function_declaration( int explict, attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *function;
    symbol_t *symbol;
    table_t *table;
    token_t *prefix;
    token_t *suffix;

    // template qualifier removed by specifier

    // if the declarator is indeed a function declarator and either an explicit
    // type specifier or type qualifier was given or we are in global scope or
    // we are in class scope we are looking at a function declarator

    assert( top != NULL );

    if ( ( ( function = function_declarator( attribute ) ) != NULL ) && ( explict || ( top == global ) || ( top->symbol != NULL ) ) ) {
	int copy = 0; // a flag to copy the symbol later

	// eat up the optional pure specifier for virtual functions
	pure();

	// grab the symbol associated with the token
	symbol = function->symbol;

	// if the symbol is not yet defined in the symbol table, define it
	assert( symbol != NULL );
	if ( symbol->found == NULL ) {
	    top->insert_table( symbol );
	} else if ( ( symbol->found != top ) && ( top != global ) ) {
            if (symbol->found->symbol == NULL ) {
		symbol_t *temp = new symbol_t( *symbol );
		// I'm not sure if copying the index makes that much sense -
		// symbol tables should be reworked.
		temp->index = symbol->index;
		// If the symbol is not already in a class, copy it into
		// current symbol table and work with that. 
		symbol = temp;
	    	top->insert_table( symbol );
	    } else {
		// The symbol is already in a class, parse its mutex attributes
		// now, then make a local copy.

	    	copy = 1;
	    } // if
	} // if

	table = symbol->found;				// grab the table in which this symbol is found

	// spend some time determining what attributes are attached to this
	// function.  attributes can be explicitly specified, inherited from
	// the class in which a member function is defined, or specified by the
	// default rules of the language.

	assert( table != NULL );
	if ( table->symbol != NULL ) {
	    // if this symbol is found in a table that has a symbol associated
	    // with it, this table must be a class table.  follow the default
	    // rules for other members, constructors and destructors

	    if ( attribute.value == NO_ATTRIBUTE ) {
		attribute.value = symbol->attribute.value;
	    } // if

	    if ( attribute.value == NO_ATTRIBUTE ) {
		// if we still don't know...

		// if no attribute is specified explicitly, we must use
		// some rules to infer the attribute of this symbol

		assert( table != NULL );
		if ( table->access == PUBLIC &&
		     strcmp(symbol->hash->text, "new") != 0 && strcmp(symbol->hash->text, "delete") != 0 ) {
		    // if we are in the public area of a class use the
		    // attribute associated with the class unless we're the new
		    // or delete operator

		    assert( table != NULL );
		    assert( table->symbol != NULL );
		    attribute.value = table->symbol->attribute.value;
		} else {
		    // if we are in the private or protected area of a class,
		    // use the no mutex attribute

		    attribute.value = NOMUTEX_ATTRIBUTE;
		} // if
	    } else if ( attribute.value & MUTEX_ATTRIBUTE ) {
		if ( strcmp(symbol->hash->text, "new") == 0 || strcmp(symbol->hash->text, "delete") == 0 ) { // new and delete operators can't be mutex
		    char buf[strlen(symbol->hash->text) + 100];

		    sprintf( buf, "\"%s\" operator cannot be mutex, uMutex attribute ignored", symbol->hash->text );

		    gen_error(ahead, buf);
		    attribute.value &= ~MUTEX_ATTRIBUTE;
		} // if
		if ( attribute.startE != NULL ) {
		    char buf[strlen(symbol->hash->text) + 100];

		    sprintf( buf, "mutex qualifier on member \"%s\" can only specify queue types when modifying a class or task, queue types ignored.",
			     symbol->hash->text );

		    gen_error(ahead, buf);
		} // if
	    } // if

	    // once an attribute is determined, assign this attribute to the
	    // symbol if it does not have an attribute

	    if ( symbol->attribute.value == NO_ATTRIBUTE ) {
		symbol->attribute.value = attribute.value;
	    } else if ( attribute.value != NO_ATTRIBUTE && symbol->attribute.value != attribute.value ) {
		// conflicting attributes 
		char buf[strlen(attr_string(attribute)) + strlen(table->symbol->hash->text) + strlen(symbol->hash->text) +
			 strlen(attr_string(symbol->attribute)) + 100];

		sprintf( buf, "%s attribute of \"%s::%s\" conflicts with previously declared",
			 attr_string(attribute), table->symbol->hash->text, symbol->hash->text );
		sprintf( &buf[strlen(buf)], " %s attribute",
			 attr_string(symbol->attribute) );
		gen_error( ahead, buf );
	    } // if

	    // if the symbol has a mutex attribute, make it a mutex member

	    if ( symbol->attribute.value & MUTEX_ATTRIBUTE ) {
		make_mutex_member(symbol);
	    } // if
	} else if ( attribute.value & MUTEX_ATTRIBUTE || attribute.value & NOMUTEX_ATTRIBUTE ){
	    // assigning a (no)Mutex attribute to a function that's not a class
	    // member

	    char buf[strlen(symbol->hash->text) + 100];
	    sprintf( buf, "routine \"%s\" not a class member, u%sMutex attribute ignored",
		     symbol->hash->text, attribute.value & MUTEX_ATTRIBUTE ? "" : "No" );
	    gen_error( ahead, buf );
	    symbol->attribute.value &= ~( MUTEX_ATTRIBUTE | NOMUTEX_ATTRIBUTE );
	} // if

	if ( copy ) {					// now copy the symbol
	    symbol_t *temp = new symbol_t( *symbol );
	    temp->index = symbol->index;		// the usefullness of this is questionable
	    symbol = temp;
	    top->insert_table( symbol );
	    table = symbol->found;
	} // if

	prefix = ahead;
	if ( body( table, function, attribute, symbol ) ) {
	    suffix = ahead;
	    assert( table != NULL );
	    assert( function != NULL );
	    assert( function->hash != NULL );
	    if ( symbol->index != DESTRUCTORPOSN ) {
		gen_member_prefix( prefix, symbol );
		// must be contained between member prefix and suffix
		if ( ( table->symbol != NULL ) && ( strcmp( function->hash->text, "main" ) == 0 ) ) {
		    gen_main_prefix( prefix, symbol );
		    gen_main_suffix( suffix, symbol );
		} // if
		gen_member_suffix( suffix, symbol );
	    } else if ( ( table->symbol != NULL ) && ( strcmp( function->hash->text, "main" ) == 0 ) ) {
		gen_main_prefix( prefix, symbol );
		gen_main_suffix( suffix, symbol );
	    } // if
	    return true;
	} else if ( match( ';' ) ) {
	    if ( attribute.value1 & TYPEDEF_ATTRIBUTE ) {
		make_type( function, symbol );
	    } // if
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // function_declaration


static bool member_initializer( symbol_t *symbol ) {
    token_t *back = ahead;
    token_t *token;
    token_t *rp;

    if ( ( token = type() ) != NULL ) {
	if ( condition() ) {
	    assert( symbol != NULL );
	    if ( ( symbol->key == COROUTINE ) || ( symbol->key == TASK ) || ( symbol->index != DESTRUCTORPOSN ) ) {
		symbol_t *base = token->symbol;
		if ( symbol->base == base ) {
		    assert( base != NULL );
		    base->used = true;
		    if ( ( base->key == COROUTINE ) || ( base->key == TASK ) || ( base->index != DESTRUCTORPOSN ) ) {
			rp = ahead->prev_parse_token();
			if ( rp->prev_parse_token()->value == LP ) {
			    gen_code( rp, "uNo" );
			} else {
			    gen_code( rp, ", uNo" );
			} // if
		    } // if
		} // if
	    } // if
	    return true;
	} // if
    } else if ( ( token = identifier() ) != NULL ) {
	if ( condition() ) {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // member_initializer


static bool member_initializer_list( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( member_initializer( symbol ) ) {
	if ( match( ',' ) ) {
	    if ( member_initializer_list( symbol ) ) {
		return true;
	    } // if
	} else {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // member_initializer_list


static bool constructor_initializer( symbol_t *symbol ) {
    token_t *back = ahead;

    if ( match( ':' ) ) {
	assert( symbol != NULL );

	// if a base class exists, clear the used flag for now

	if ( symbol->base != NULL ) {
	    symbol->base->used = false;
	} // if

	if ( member_initializer_list( symbol ) ) {
	    // if a base class exists, and the used flags is still cleared, it
	    // means the user has not called its constructor explicitly.  that
	    // means the translator has to add a call to its constructor.

	    if ( symbol->base != NULL && ! symbol->base->used ) {
		gen_initializer( ahead, symbol, "," );
	    } // if

	    return true;
	} // if
    } // if

    ahead = back; return false;
} // constructor_initializer


static bool constructor_declaration( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *constructor;
    symbol_t *symbol;
    table_t *table;
    token_t *prefix;
    token_t *suffix;
    token_t *rp;
    bool initializer;

    while ( type_qualifier( attribute ) || template_qualifier( attribute ) );

    if ( ( constructor = constructor_declarator( attribute ) ) != NULL ) {
	assert( constructor != NULL );
	symbol = constructor->symbol;
	assert( symbol != NULL );

	table = symbol->table;

	if ( table != NULL ) {				// must be complete type
	    // remember where the right parenthese of the argument list of the
	    // constructor is

	    rp = ahead->prev_parse_token();

	    if ( attribute.emptyparms ) {		// default constructor ?
		symbol->table->hasdefault = true;
	    } // if

	    if ( match( TRY ) ) {			// exceptions for constructor body ?
		gen_error( ahead, "try block for constructor body not supported" );
	    } // if
	    
	    // eat the constructor initializers.  remember if we saw one

	    initializer = constructor_initializer( symbol );

	    prefix = ahead;

	    if ( attribute.value == NO_ATTRIBUTE ) {
		// if no attribute is specified explicitly, use some rules to
		// infer the attribute of this symbol

		assert( table != NULL );
		if ( table->access == PUBLIC ) {
		    // if we are in the public area of a class use the attribute
		    // associated with the class

		    assert( table != NULL );
		    assert( table->symbol != NULL );
		    attribute.value = table->symbol->attribute.value;

		} else {
		    // if in the private or protected area of a class, use the
		    // no mutex attribute

		    attribute.value = NOMUTEX_ATTRIBUTE;
		} // if
	    } else {
		if ( ( attribute.value & MUTEX_ATTRIBUTE ) ) {
		    gen_error( ahead, "constructor must be no-mutex, uMutex attribute ignored" );
		    attribute.value = NOMUTEX_ATTRIBUTE;
		} // if
	    } // if

	    // once an attribute is determined, assign this attribute to the
	    // symbol if it does not have an attribute yet, else check to make
	    // sure that the attributes match

	    if ( symbol->attribute.value == NO_ATTRIBUTE ) {
		symbol->attribute.value = attribute.value;
	    } // if

	    assert( symbol != NULL );
	    if ( symbol->attribute.value & MUTEX_ATTRIBUTE ) {
		make_mutex_class( symbol );
	    } // if

	    if ( body( symbol->table, NULL, attribute, symbol ) ) {
		catch_statement( symbol );		// exception for initializers

		assert( table != NULL );

		if ( ! initializer ) {
		    // if there was no initializer, may have some work to do to
		    // initialize the class

		    gen_initializer( prefix, symbol, ":" );
		} // if
    
		suffix = ahead->prev_parse_token();

		if ( table->defined ) {
		    gen_constructor_parameter( rp, symbol, false );
		    gen_serial_initializer( rp, symbol );
		    gen_constructor_prefix( prefix, symbol );
		    gen_constructor_suffix( suffix, symbol );
		} else {
		    structor_t *structor = new structor_t;
		    assert( structor != NULL );
		    structor->rp = rp;
		    structor->defarg = false;
		    structor->prefix = prefix;
		    structor->suffix = suffix;
		    table->constructor.add_structor( structor );

		    gen_serial_initializer( rp, symbol );
		} // if

		return true;
	    } else if ( match( ';' ) ) {
		assert( table != NULL );

		if ( table->defined ) {
		    gen_constructor_parameter( rp, symbol, true );
		} else {
		    structor_t *structor = new structor_t;
		    assert( structor != NULL );
		    structor->rp = rp;
		    structor->defarg = true;
		    structor->prefix = NULL;
		    structor->suffix = NULL;
		    table->constructor.add_structor( structor );
		} // if

		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // constructor_declaration


static bool destructor_declaration( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *destructor;
    symbol_t *symbol;
    table_t *table;
    token_t *prefix;
    token_t *suffix;

    while ( type_qualifier( attribute ) || template_qualifier( attribute ) );

    if ( ( destructor = destructor_declarator( attribute ) ) != NULL ) {
	prefix = ahead;

	assert( destructor != NULL );
	symbol = destructor->symbol;
	assert( symbol != NULL );
	table = symbol->table;
	assert( table != NULL );
#if 0
	if ( attribute.value == NO_ATTRIBUTE ) {
	    // if no attribute is specified explicitly, we must use some rules
	    // to infer the attribute of this symbol

	    assert( table != NULL );
	    if ( table->access == PUBLIC ) {
		// if we are in the public area of a class use the attribute
		// associated with the class

		assert( table != NULL );
		assert( table->symbol != NULL );
		attribute.value = table->symbol->attribute.value;
	    } else {
		// if we are in the private or protected area of a class, use
		// the no mutex attribute

		attribute.value = NOMUTEX_ATTRIBUTE;
	    } // if
	} else {
	    // kind of destructor must match with the kind of its containing class
	    if ( ( attribute.value & NOMUTEX_ATTRIBUTE ) && ( table->symbol->attribute.value & MUTEX_ATTRIBUTE ) ) {
		gen_error( ahead, "destructor must be mutex, uNoMutex attribute ignored" );
		attribute.value = MUTEX_ATTRIBUTE;
	    } // if
	} // if
#endif
	// once an attribute is determined, assign this attribute to the symbol
	// if it does not have an attribute yet, else check to make sure that
	// the attributes match

	if ( symbol->attribute.value == NO_ATTRIBUTE ) {
	    symbol->attribute.value = attribute.value;
	} // if

	assert( symbol != NULL );
	if ( symbol->attribute.value & MUTEX_ATTRIBUTE ) {
	    make_mutex_class( symbol );
	} // if

	if ( body( symbol->table, NULL, attribute, symbol ) ) {
	    suffix = ahead->prev_parse_token();

	    assert( table != NULL );

	    if ( table->defined ) {
		gen_destructor_prefix( prefix, symbol );
		gen_destructor_suffix( suffix, symbol );
	    } else {
		structor_t *structor = new structor_t();

		assert( structor != NULL );
		structor->prefix = prefix;
		structor->suffix = suffix;
		structor->value = attribute.value;
		table->destructor.add_structor( structor );
	    } // if

	    return true;
	} else if ( match( ';' ) ) {
	    assert( table != NULL );

	    if ( ! table->defined ) {
		structor_t *structor = new structor_t();

		assert( structor != NULL );
		structor->prefix = NULL;
		structor->suffix = NULL;
		structor->value = attribute.value;
		table->destructor.add_structor( structor );
	    } // if

	    return true;
	} // if
    } // if

    ahead = back; return false;
} // destructor_declaration


static bool string() {
    token_t *back = ahead;

    if ( match( STRING ) ) {
	while ( match( STRING ) );
	return true;
    } // if

    ahead = back; return false;
} // string


static bool simple_type_specifier() {
    token_t *back = ahead;

    if ( epyt() != NULL ) return true;
    if ( match( CHAR ) ) return true;
    if ( match( WCHAR_T ) ) return true;
    if ( match( BOOL ) ) return true;
    if ( match( SHORT ) ) return true;
    if ( match( INT ) ) return true;
    if ( match( LONG ) ) return true;
    if ( match( SIGNED ) ) return true;
    if ( match( UNSIGNED ) ) return true;
    if ( match( FLOAT ) ) return true;
    if ( match( DOUBLE ) ) return true;
    if ( match( VOID ) ) return true;

    ahead = back; return false;
} // simple_type_specifier


static bool template_type_specifier( attribute_t &attribute ) {
    token_t *back = ahead;

    // This routine is a bit of a hack.
    // It is designed to parse the following piece of code.
    //
    // template < class t > t c::();
    //
    // The normal parsing rules will miss this is a valid function
    // declaration because the return type of the function will be missed
    // as a valid type, because the parser is not yet in the class'es
    // symbol table and the template qualifier's symbol table has not
    // yet been pushed on the stack.
    //
    // This function simply checks if the next token is an identifier,
    // then if it is, it searches for it explicitly in the template
    // qualifier symbol table if it exists and if it finds it, returns
    // the fact that it found a type.

    token_t *token = ahead;
    if ( match( IDENTIFIER ) ) {
	if ( attribute.plate != NULL ) {
	    assert( token != NULL );
	    if ( attribute.plate->search_table( token->hash ) ) {
		return true;
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // template_type_specifier


static bool elaborated_type_specifier( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;

    if ( match( TYPENAME ) || match( ENUM ) || class_key( attribute ) ) {
	match( COLON_COLON );				// optional ::
	for ( ;; ) {
	  if ( eof() ) break;
	    token = ahead;
	    if ( ! ( match( IDENTIFIER ) || match( TYPE ) ) ) {
		break;
	    } // if
	    template_key( token );
	    if ( ! match( COLON_COLON ) ) {
		attribute.value1 |= TYPEDEF_ATTRIBUTE;
		return true;
	    } // if
	} // for
    } // if

    ahead = back; return false;
} // elaborated_type_specifier


static bool type_specifier( attribute_t &attribute, bool &rt ) {
    token_t *back = ahead;

    if ( simple_type_specifier() ) { rt = true; return true; }
    if ( ! rt && type() != NULL ) { rt = true; return true; }
    if ( enumerator_specifier() ) return true;
    if ( class_specifier( attribute ) ) return true;
    if ( elaborated_type_specifier( attribute ) ) return true;
    if ( template_type_specifier( attribute ) ) return true;

    ahead = back; return false;
} // type_specifier


static bool specifier( attribute_t &attribute, bool &rt ) {
    token_t *back = ahead;

    if ( template_qualifier( attribute ) ) return true;
    if ( type_qualifier( attribute ) ) return true;
    if ( type_specifier( attribute, rt ) ) return true;

    ahead = back; return false;
} // specifier


static bool specifier_list( attribute_t &attribute ) {
    token_t *back = ahead;
    bool rt = false;					// return type

    if ( specifier( attribute, rt ) ) {
	for ( ;; ) {
	    if ( ahead->value == TYPE && attribute.value1 & TYPEDEF_ATTRIBUTE ) {
		attribute.typedef_base = ahead->symbol;
	    } // if
	 if ( ! specifier( attribute, rt ) ) break;
	} // for
	return true;
    } // if

    ahead = back; return false;
} // specifier_list


static bool initializer() {
    token_t *back = ahead;

    if ( match( '=' ) ) {
	if ( match( LC ) && match_closing( LC, RC ) ) {
	    return true;
	} else {
	    for ( ;; ) {				// scan off the expression
	      if ( eof() ) break;
	      if ( match( LP ) && ! match_closing( LP, RP ) ) break;
	      if ( match( LA ) && ! match_closing( LA, RA ) ) break;
	      if ( check( ';' ) ) return true;
	      if ( check( ',' ) ) return true;
		scan();
	    } // for
	} // if
    } else if ( match( LP ) && match_closing( LP, RP ) ) {
	return true;
    } // if

    ahead = back; return false;
} // initializer


static bool declarator_list( attribute_t &attribute ) {
    token_t *back = ahead;
    token_t *token;
    symbol_t *symbol;

    if ( ( token = declarator( attribute ) ) != NULL ) {
	if ( attribute.value1 & TYPEDEF_ATTRIBUTE ) {
	    symbol = token->symbol;
	    assert( symbol != NULL );
	    make_type( token, symbol );

	    if ( attribute.typedef_base != NULL ) {	// if null => base type without substructure
		// Copy pertinent information to make this symbol look like
		// what it is typedef to. This does not work for uC++ class
		// types because the fields (like index) must be the same for
		// both types.

		symbol->table = attribute.typedef_base->table;
		symbol->key = attribute.typedef_base->key;
		symbol->attribute = attribute.typedef_base->attribute;
		symbol->attribute.value1 |= TYPEDEF_ATTRIBUTE; // override these 2 fields
		symbol->attribute.typedef_base = attribute.typedef_base;
		symbol->base = attribute.typedef_base->base;
		symbol->left = attribute.typedef_base->left;
		symbol->right = attribute.typedef_base->right;
	    } // if
	} // if
	initializer();
	if ( match( ',' ) ) {
	    if ( declarator_list( attribute ) ) {
		return true;
	    } // if
	} else {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // declarator_list


static bool exception_declaration() {
    token_t *back = ahead;
    attribute_t attribute;

    if ( specifier_list( attribute ) ) {
	if ( declarator( attribute ) ) {
	    return true;
	} else {
	    return true;
	} //if
    } else {
	return false;
    } // if

    ahead = back; return false;
} // exception_declaration


static bool object_declaration() {
    token_t *back = ahead;
    attribute_t attribute;
    int explict;

    if ( constructor_declaration( attribute ) ) return true;
    if ( destructor_declaration( attribute ) ) return true;

    explict = specifier_list( attribute );
    if ( function_declaration( explict, attribute ) ) {
	return true;
    } else {
	while ( declarator_list( attribute ) );
	if ( match( ';' ) ) {
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // declaration


static bool asm_declaration() {
    token_t *back = ahead;

    if ( match( ASM ) ) {
	if ( match( LP ) ) {
	    if ( string() ) {
		if ( match( RP ) ) {
		    if ( match( ';' ) ) {
			return true;
		    } // if
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // asm_declaration


static bool module();


static bool linkage_specification() {
    token_t *back = ahead;

    if ( match( EXTERN ) ) {
	if ( string() ) {
	    if ( match( LC ) ) {
		while ( module() );
		match( RC );
		return true;
	    } else {
		object_declaration();
		return true;
	    } // if
	    return true;
	} // if
    } // if

    ahead = back; return false;
} // linkage_specification


static bool namespace_definition() {
    token_t *back = ahead;

    if ( match( NAMESPACE ) ) {
	match( IDENTIFIER );				// optional name
	if ( match( LC ) ) {
	    while ( module() );
	    match( RC );
	    return true;
	} // if
	return true;
    } // if

    ahead = back; return false;
} // namespace_definition


static bool namespace_alias_definition() {
    token_t *back = ahead;

    if ( match( NAMESPACE ) ) {
	if ( match( IDENTIFIER ) ) {
	    if ( match( '=' ) ) {
		if ( identifier() != NULL ) {
		    return true;
		} // if
	    } // if
	} // if
    } // if

    ahead = back; return false;
} // namespace_alias_definition


static bool module() {
    if ( eof() ) return false;

    if ( asm_declaration() ) return true;
    if ( linkage_specification() ) return true;
    if ( namespace_definition() ) return true;
    if ( namespace_alias_definition() ) return true;
    if ( object_declaration() ) return true;

    return false;
} // module


void parse( const char *name ) {
    ahead = list->get_head();

    scan();

    while ( ! eof() ) {
	if ( ! module() ) {
	    // did not recognize something.  it was probably an error or some
	    // construct that was added to the language that was not
	    // anticipated.  in any case, simply scan for the next
	    // synchronizing token and continue parsing from there.

//	    gen_warning( ahead, "unrecognizable text, possible CC syntax problem, skipping text to allow the CC compiler to print an appropriate error" );
//	    printf( "\n\"" );
	    while ( ! ( eof() || match( ';' ) || match( LC ) || match( RC ) ) ) {
//		printf( "%s ", ahead->hash->text );
		scan();
	    } // while
//	    printf( "\"\n" );

	} // if
    } // while
} // parse


// Local Variables: //
// compile-command: "dmake" //
// End: //
