//                              -*- Mode: C++ -*- 
// 
// uC++ Version 4.7, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// output.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:09:30 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Oct 28 10:04:21 1998
// Update Count     : 83
// 

#include <stdlib.h>
#include <stdio.h>

#include "assert.h"
#include "main.h"
#include "key.h"
#include "hash.h"
#include "include.h"
#include "token.h"
#include "input.h"
#include "output.h"

static char * file = NULL;
static unsigned int line = 1;

static inline int isdigit( char c ) {
    return c >= '0' && c <= '9';
} // isdigit

static void parse_directive( char *text ) {	
    char *c = text + 1;					// get past '#'
    while ( *c == ' ' || *c == '\t' ) c += 1;		// skip blanks
    if ( isdigit( *c ) ) {				// must be a line directive
	line = 0;
	while ( isdigit( *c ) ) {
	    line = line * 10 + ( *c - '0' );
	    c += 1;
	} // while
	while ( ( *c == ' ' ) || ( *c == '\t' ) ) {
	    c += 1;					// skip blanks
	} // while
	if ( *c == '\"' ) {				// must be a file directive "
	    char *s = c + 1;				// remember where the string begins
	    c = s;
	    while ( *c != '\"' ) {			// look for the end of the file name "
		c += 1;
	    } // while
	    *c = '\0';					// terminate the string containing the file name
	    if ( file != NULL ) delete file;		// deallocate old string
	    file = new char[ strlen( s ) + 1 ];		// allocate new string
	    strcpy( file, s );				// copy the file name into this string
	    *c = '\"';					// fill in the end quote again "
	} // if
    } else {
	line += 1;					// it was a normal directive, increment the line number
    } // if
} // parse_directive

// The routine 'output' converts a token value into text.  A considerable
// amount of effort is taken to keep track of the current file name and line
// number so that when error and warning messages appear, the exact origin of
// those messages can be displayed.

void output( token_t * token ) {
    assert( token != NULL );
    assert( token->hash != NULL );
    assert( token->hash->text != NULL );

    switch ( token->value ) {
      case '\n':
      case '\r':
	line += 1;
	fprintf( yyout, "%s", token->hash->text );
	break;
      case '#':
	parse_directive( token->hash->text );
	fprintf( yyout, "%s", token->hash->text );
	break;
      case ERROR:
	fprintf( stderr, "%s:%d: uC++ translator error: %s\n", file, line, token->hash->text );
	break;
      case WARNING:
	fprintf( stderr, "%s:%d: uC++ translator warning: %s\n", file, line, token->hash->text );
	break;
      case COROUTINE:					// do not print these keywords
      case DISABLE:
      case DUALEVENT:
      case ENABLE:
      case MUTEX:
      case NOMUTEX:
      case PTASK:
      case RAISEEVENT:
      case RTASK:
      case STASK:
      case TASK:
      case THROWEVENT:
	break;
      case ACCEPT:
      case AT:
      case OR:
      case RAISE:
      case RESUME:
      case SIGNAL:
      case SIGNALBLOCK:
      case SUSPEND:
      case TIMEOUT:
      case UELSE:
      case UTHROW:
      case WAIT:
      case WITH:
      case WHEN:
	{
	    // if no code or error was generated, print an error now
	    int value = token->next_parse_token()->value;
	    if ( value != CODE && value != ERROR ) {
		fprintf( stderr, "%s:%d: uC++ translator error: parse error before %s\n", file, line, token->hash->text );
	    } // if
	    break;
	}
      default:
	fprintf( yyout, " %s", token->hash->text );
	break;
    } // switch
} // output

// The routine 'write_all_output' takes the stream of tokens and calls 'output'
// to convert them all to a stream of text.  It then deletes each token in the
// list.

void write_all_output() {
    for ( ;; ) {
	token_t * token = list->remove_from_head();
      if ( token->value == EOF ) break;
	output( token );
    } // for
} // write_all_output

// Local Variables: //
// compile-command: "dmake" //
// End: //
